/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.server;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.common.accessLog.AccessLogConfig;
import org.apache.servicecomb.common.accessLog.AccessLogInitializer;
import org.apache.servicecomb.common.accessLog.core.AccessLogGenerator;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDefaultInitializer
implements AccessLogInitializer {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"accesslog");
    private AccessLogGenerator accessLogGenerator;

    @Override
    public void init(EventBus eventBus, AccessLogConfig accessLogConfig) {
        if (!accessLogConfig.isServerLogEnabled()) {
            return;
        }
        this.accessLogGenerator = new AccessLogGenerator(accessLogConfig.getServerLogPattern());
        eventBus.register((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRequestReceived(ServerAccessLogEvent accessLogEvent) {
        LOGGER.info(this.accessLogGenerator.generateServerLog(accessLogEvent));
    }
}

