/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.common.rest.codec.param.RestClientRequestImpl;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;

public class HttpMethodAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerRequest request = accessLogEvent.getRoutingContext().request();
        if (null == request || null == request.method()) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(request.method().toString());
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        OperationMeta operationMeta = finishEvent.getInvocation().getOperationMeta();
        if (operationMeta != null && !StringUtils.isEmpty((CharSequence)operationMeta.getHttpMethod())) {
            builder.append(operationMeta.getHttpMethod());
            return;
        }
        RestClientRequestImpl restRequestImpl = (RestClientRequestImpl)finishEvent.getInvocation().getHandlerContext().get("servicecomb-invocation-hanlder-requestclient");
        if (null == restRequestImpl || null == restRequestImpl.getRequest() || null == restRequestImpl.getRequest().method()) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(restRequestImpl.getRequest().method().toString());
    }
}

