/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.api.registry;

import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;

public class MicroserviceInstances {
    private boolean microserviceNotExist;
    private boolean needRefresh = true;
    private String revision;
    private FindInstancesResponse instancesResponse;

    public boolean isMicroserviceNotExist() {
        return this.microserviceNotExist;
    }

    public MicroserviceInstances setMicroserviceNotExist(boolean microserviceNotExist) {
        this.microserviceNotExist = microserviceNotExist;
        return this;
    }

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public MicroserviceInstances setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public MicroserviceInstances setRevision(String revision) {
        this.revision = revision;
        return this;
    }

    public FindInstancesResponse getInstancesResponse() {
        return this.instancesResponse;
    }

    public MicroserviceInstances setInstancesResponse(FindInstancesResponse instancesResponse) {
        this.instancesResponse = instancesResponse;
        return this;
    }

    public void mergeMicroserviceInstances(MicroserviceInstances other) {
        this.mergeNeedRefresh(other.needRefresh);
        this.mergeMicroserviceNotExist(other.microserviceNotExist);
        this.mergeRevision(other.revision);
        this.mergeInstanceResponse(other.getInstancesResponse());
    }

    private void mergeRevision(String revision) {
        if (revision == null) {
            return;
        }
        if (this.revision == null || this.revision.compareTo(revision) < 0) {
            this.revision = revision;
        }
    }

    private void mergeMicroserviceNotExist(boolean microserviceNotExist) {
        if (this.microserviceNotExist) {
            this.microserviceNotExist = microserviceNotExist;
        }
    }

    private void mergeNeedRefresh(boolean needRefresh) {
        if (!this.needRefresh) {
            this.needRefresh = needRefresh;
        }
    }

    private void mergeInstanceResponse(FindInstancesResponse instancesResponse) {
        if (instancesResponse == null) {
            return;
        }
        if (this.instancesResponse == null) {
            this.instancesResponse = instancesResponse;
            return;
        }
        this.instancesResponse.mergeInstances(instancesResponse.getInstances());
    }
}

