/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.common.rest.RestProducerInvocationFlow;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.StandardHttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.StandardHttpServletResponseEx;
import org.apache.servicecomb.transport.rest.servlet.RestAsyncListener;
import org.apache.servicecomb.transport.rest.servlet.RestServletProducerInvocation;
import org.apache.servicecomb.transport.rest.servlet.RestServletProducerInvocationCreator;
import org.apache.servicecomb.transport.rest.servlet.ServletConfig;

public class ServletRestDispatcher {
    private RestAsyncListener restAsyncListener = new RestAsyncListener();
    private Transport transport;
    private MicroserviceMeta microserviceMeta;
    private List<HttpServerFilter> httpServerFilters = SPIServiceUtils.getSortedService(HttpServerFilter.class);

    public void service(HttpServletRequest request, HttpServletResponse response) {
        if (this.transport == null) {
            this.transport = SCBEngine.getInstance().getTransportManager().findTransport("rest");
            this.microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        }
        AsyncContext asyncCtx = request.startAsync();
        asyncCtx.addListener((AsyncListener)this.restAsyncListener);
        asyncCtx.setTimeout(ServletConfig.getAsyncServletTimeout());
        StandardHttpServletRequestEx requestEx = new StandardHttpServletRequestEx(request);
        StandardHttpServletResponseEx responseEx = new StandardHttpServletResponseEx(response);
        if (SCBEngine.getInstance().isFilterChainEnabled()) {
            requestEx.setCacheRequest(true);
            RestServletProducerInvocationCreator creator = new RestServletProducerInvocationCreator(this.microserviceMeta, this.transport.getEndpoint(), (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx);
            new RestProducerInvocationFlow((InvocationCreator)creator, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx).run();
            return;
        }
        RestServletProducerInvocation restProducerInvocation = new RestServletProducerInvocation();
        restProducerInvocation.invoke(this.transport, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx, this.httpServerFilters);
    }
}

