/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.retry.Retry;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.provider.consumer.SyncResponseExecutor;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.governance.handler.RetryHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.handler.governance.MatchType;
import org.apache.servicecomb.handler.governance.ServiceCombInvocationContext;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGovernanceHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerGovernanceHandler.class);
    private RetryHandler retryHandler = (RetryHandler)BeanUtils.getBean(RetryHandler.class);
    private static final ScheduledExecutorService RETRY_POOL = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "governance-retry-pool-thread-" + this.count.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        SyncResponseExecutor originalExecutor;
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequest request = MatchType.createGovHttpRequest(invocation);
        try {
            ServiceCombInvocationContext.setInvocationContext((InvocationContext)invocation);
            this.addRetry((Decorators.DecorateCompletionStage<Response>)dcs, request);
        }
        finally {
            ServiceCombInvocationContext.removeInvocationContext();
        }
        if (invocation.getResponseExecutor() instanceof SyncResponseExecutor) {
            originalExecutor = (SyncResponseExecutor)invocation.getResponseExecutor();
            Executor newExecutor = command -> RETRY_POOL.submit(command);
            invocation.setResponseExecutor(newExecutor);
        } else {
            originalExecutor = null;
            Object newExecutor = null;
        }
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                if (originalExecutor != null) {
                    originalExecutor.execute(() -> asyncResp.complete(r));
                } else {
                    asyncResp.complete(r);
                }
                return;
            }
            if (originalExecutor != null) {
                originalExecutor.execute(() -> asyncResp.consumerFail(e));
            } else {
                asyncResp.consumerFail(e);
            }
        });
    }

    private void addRetry(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequest request) {
        Retry retry = (Retry)this.retryHandler.getActuator(request);
        if (retry != null) {
            dcs.withRetry(retry, RETRY_POOL);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation) {
        int currentHandler = invocation.getHandlerIndex();
        AtomicBoolean isRetryHolder = new AtomicBoolean(false);
        return () -> {
            CompletableFuture result = new CompletableFuture();
            if (isRetryHolder.getAndSet(true)) {
                invocation.setHandlerIndex(currentHandler);
                LOGGER.info("retry operation {}, trace id {}", (Object)invocation.getOperationMeta().getMicroserviceQualifiedName(), (Object)invocation.getTraceId());
            }
            try {
                invocation.next(response -> result.complete(response));
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return result;
        };
    }
}

