/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.springframework.util.StringUtils;

public class RetryPolicy
extends AbstractPolicy {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final int DEFAULT_WAIT_DURATION = 1;
    public static final String DEFAULT_RETRY_ON_RESPONSE_STATUS = "502";
    private int maxAttempts = 3;
    private int waitDuration = 1;
    private String retryOnResponseStatus;

    public String getRetryOnResponseStatus() {
        if (StringUtils.isEmpty((Object)this.retryOnResponseStatus)) {
            this.retryOnResponseStatus = DEFAULT_RETRY_ON_RESPONSE_STATUS;
        }
        return this.retryOnResponseStatus;
    }

    public void setRetryOnResponseStatus(String retryOnResponseStatus) {
        this.retryOnResponseStatus = retryOnResponseStatus;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getWaitDuration() {
        return this.waitDuration;
    }

    public void setWaitDuration(int waitDuration) {
        this.waitDuration = waitDuration;
    }

    @Override
    public boolean isValid() {
        if (this.maxAttempts < 1) {
            return false;
        }
        if (this.waitDuration < 0) {
            return false;
        }
        return super.isValid();
    }

    public String toString() {
        return "RetryPolicy{maxAttempts=" + this.maxAttempts + ", waitDuration=" + this.waitDuration + ", retryOnResponseStatus='" + this.retryOnResponseStatus + '\'' + '}';
    }
}

