/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.ext.RetryExtension;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.RetryPolicy;
import org.apache.servicecomb.governance.properties.RetryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RetryHandler
extends AbstractGovernanceHandler<Retry, RetryPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryHandler.class);
    @Autowired
    private RetryProperties retryProperties;
    @Autowired
    private RetryExtension retryExtension;

    @Override
    protected String createKey(RetryPolicy policy) {
        return "servicecomb.retry." + policy.getName();
    }

    @Override
    public RetryPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (RetryPolicy)this.matchersManager.match(governanceRequest, this.retryProperties.getParsedEntity());
    }

    @Override
    protected Retry createProcessor(RetryPolicy policy) {
        return this.getRetry(policy);
    }

    private Retry getRetry(RetryPolicy retryPolicy) {
        LOGGER.info("applying new policy: {}", (Object)retryPolicy.toString());
        List<Integer> statusList = Arrays.stream(retryPolicy.getRetryOnResponseStatus().split(",")).map(Integer::parseInt).collect(Collectors.toList());
        RetryConfig config = RetryConfig.custom().maxAttempts(retryPolicy.getMaxAttempts()).retryOnResult(this.getPredicate(statusList)).retryExceptions((Class[])this.retryExtension.retryExceptions()).waitDuration(Duration.ofMillis(retryPolicy.getWaitDuration())).build();
        RetryRegistry registry = RetryRegistry.of((RetryConfig)config);
        return registry.retry(retryPolicy.getName());
    }

    private Predicate<Object> getPredicate(List<Integer> statusList) {
        return response -> this.retryExtension.isRetry(statusList, response);
    }
}

