/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.CircuitBreakerPolicy;
import org.apache.servicecomb.governance.properties.CircuitBreakerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CircuitBreakerHandler
extends AbstractGovernanceHandler<CircuitBreaker, CircuitBreakerPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakerHandler.class);
    @Autowired
    private CircuitBreakerProperties circuitBreakerProperties;

    @Override
    protected String createKey(CircuitBreakerPolicy policy) {
        return "servicecomb.circuitBreaker." + policy.getName();
    }

    @Override
    public CircuitBreakerPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (CircuitBreakerPolicy)this.matchersManager.match(governanceRequest, this.circuitBreakerProperties.getParsedEntity());
    }

    @Override
    protected CircuitBreaker createProcessor(CircuitBreakerPolicy policy) {
        return this.getCircuitBreaker(policy);
    }

    private CircuitBreaker getCircuitBreaker(CircuitBreakerPolicy policy) {
        LOGGER.info("applying new policy: {}", (Object)policy.toString());
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold((float)policy.getFailureRateThreshold()).slowCallRateThreshold((float)policy.getSlowCallRateThreshold()).waitDurationInOpenState(Duration.ofMillis(policy.getWaitDurationInOpenState())).slowCallDurationThreshold(Duration.ofMillis(policy.getSlowCallDurationThreshold())).permittedNumberOfCallsInHalfOpenState(policy.getPermittedNumberOfCallsInHalfOpenState()).minimumNumberOfCalls(policy.getMinimumNumberOfCalls()).slidingWindowType(policy.getSlidingWindowTypeEnum()).slidingWindowSize(policy.getSlidingWindowSize()).build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig);
        return circuitBreakerRegistry.circuitBreaker(policy.getName(), circuitBreakerConfig);
    }
}

