/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.transport.AbstractTransport;
import org.apache.servicecomb.foundation.vertx.SimpleJsonObject;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.transport.highway.HighwayClient;
import org.apache.servicecomb.transport.highway.HighwayConfig;
import org.apache.servicecomb.transport.highway.HighwayServerVerticle;

public class HighwayTransport
extends AbstractTransport {
    private HighwayClient highwayClient = new HighwayClient();

    public String getName() {
        return "highway";
    }

    public boolean init() throws Exception {
        this.highwayClient.init(this.transportVertx);
        DeploymentOptions deployOptions = new DeploymentOptions().setInstances(HighwayConfig.getServerThreadCount());
        this.setListenAddressWithoutSchema(HighwayConfig.getAddress(), Collections.singletonMap("login", "true"));
        SimpleJsonObject json = new SimpleJsonObject();
        json.put("servicecomb.endpoint", (Object)this.getEndpoint());
        deployOptions.setConfig((JsonObject)json);
        deployOptions.setWorkerPoolName("pool-worker-transport-highway");
        return VertxUtils.blockDeploy((Vertx)this.transportVertx, HighwayServerVerticle.class, (DeploymentOptions)deployOptions);
    }

    public void send(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        this.highwayClient.send(invocation, asyncResp);
    }

    public HighwayClient getHighwayClient() {
        return this.highwayClient;
    }
}

