/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.ProtobufManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpData;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.highway.HighwayClient;
import org.apache.servicecomb.transport.highway.HighwayClientPackage;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.HighwayTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HighwayClientFilter
implements ConsumerFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayClientFilter.class);
    public static final String NAME = "highway-client";

    @Nonnull
    public String getName() {
        return NAME;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        LOGGER.debug("Sending request by highway, operation={}, endpoint={}.", (Object)invocation.getMicroserviceQualifiedName(), (Object)invocation.getEndpoint().getEndpoint());
        invocation.getInvocationStageTrace().startClientFiltersRequest();
        OperationProtobuf operationProtobuf = ProtobufManager.getOrCreateOperation((Invocation)invocation);
        return ((CompletableFuture)((CompletableFuture)this.send(invocation, operationProtobuf).thenApply(tcpData -> this.convertToResponse(invocation, operationProtobuf, (TcpData)tcpData))).thenApply(this::convertFailedResponseToException)).whenComplete((response, throwable) -> invocation.getInvocationStageTrace().finishClientFiltersResponse());
    }

    protected CompletableFuture<TcpData> send(Invocation invocation, OperationProtobuf operationProtobuf) {
        invocation.onStartSendRequest();
        HighwayClient highwayClient = ((HighwayTransport)invocation.getTransport()).getHighwayClient();
        HighwayClientPackage clientPackage = highwayClient.createClientPackage(invocation, operationProtobuf);
        CompletionStage sendFuture = highwayClient.findClientPool(invocation).send(clientPackage).whenComplete((tcpData, throwable) -> this.afterSend(invocation, clientPackage));
        return invocation.optimizeSyncConsumerThread((CompletableFuture)sendFuture);
    }

    protected void afterSend(Invocation invocation, HighwayClientPackage clientPackage) {
        invocation.getInvocationStageTrace().finishWriteToBuffer(clientPackage.getFinishWriteToBuffer());
        invocation.getInvocationStageTrace().finishReceiveResponse();
        invocation.getInvocationStageTrace().startClientFiltersResponse();
    }

    protected Response convertToResponse(Invocation invocation, OperationProtobuf operationProtobuf, TcpData tcpData) {
        try {
            return HighwayCodec.decodeResponse(invocation, operationProtobuf, tcpData);
        }
        catch (Exception e) {
            AsyncUtils.rethrow((Throwable)e);
            return null;
        }
    }

    protected Response convertFailedResponseToException(Response response) {
        if (response.isFailed()) {
            Object errorData = response.getResult();
            if (errorData instanceof InvocationException) {
                errorData = ((InvocationException)errorData).getErrorData();
            }
            throw Exceptions.create((Response.StatusType)response.getStatus(), (Object)errorData);
        }
        return response;
    }
}

