/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.distribute;

import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.router.cache.RouterRuleCache;
import org.apache.servicecomb.router.distribute.RouterDistributor;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.apache.servicecomb.router.model.RouteItem;
import org.apache.servicecomb.router.model.TagItem;
import org.apache.servicecomb.router.util.VersionCompareUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRouterDistributor<T extends Server, E>
implements RouterDistributor<T, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRouterDistributor.class);
    private Function<T, E> getIns;
    private Function<E, String> getVersion;
    private Function<E, String> getServerName;
    private Function<E, Map<String, String>> getProperties;

    @Override
    public List<T> distribute(String targetServiceName, List<T> list, PolicyRuleItem invokeRule) {
        this.initLatestVersion(targetServiceName, list);
        invokeRule.check(RouterRuleCache.getServiceInfoCacheMap().get(targetServiceName).getLatestVersionTag());
        Map<TagItem, List<T>> versionServerMap = this.getDistributList(targetServiceName, list, invokeRule);
        if (CollectionUtils.isEmpty(versionServerMap)) {
            LOGGER.debug("route management can not match any rule and route the latest version");
            return this.getLatestVersionList(list, targetServiceName);
        }
        TagItem targetTag = this.getFiltedServerTagItem(invokeRule, targetServiceName);
        if (versionServerMap.containsKey(targetTag)) {
            return versionServerMap.get(targetTag);
        }
        return this.getLatestVersionList(list, targetServiceName);
    }

    @Override
    public void init(Function<T, E> getIns, Function<E, String> getVersion, Function<E, String> getServerName, Function<E, Map<String, String>> getProperties) {
        this.getIns = getIns;
        this.getVersion = getVersion;
        this.getServerName = getServerName;
        this.getProperties = getProperties;
    }

    public TagItem getFiltedServerTagItem(PolicyRuleItem rule, String targetServiceName) {
        return RouterRuleCache.getServiceInfoCacheMap().get(targetServiceName).getNextInvokeVersion(rule);
    }

    private Map<TagItem, List<T>> getDistributList(String serviceName, List<T> list, PolicyRuleItem invokeRule) {
        String latestV = RouterRuleCache.getServiceInfoCacheMap().get(serviceName).getLatestVersionTag().getVersion();
        HashMap<TagItem, List<T>> versionServerMap = new HashMap<TagItem, List<T>>();
        for (Server server : list) {
            E ms = this.getIns.apply(server);
            if (!this.getServerName.apply(ms).equals(serviceName)) continue;
            TagItem tagItem = new TagItem(this.getVersion.apply(ms), this.getProperties.apply(ms));
            TagItem targetTag = null;
            int maxMatch = 0;
            for (RouteItem entry : invokeRule.getRoute()) {
                int nowMatch = entry.getTagitem().matchNum(tagItem);
                if (nowMatch <= maxMatch) continue;
                maxMatch = nowMatch;
                targetTag = entry.getTagitem();
            }
            if (invokeRule.isWeightLess() && this.getVersion.apply(ms).equals(latestV)) {
                TagItem latestVTag = invokeRule.getRoute().get(invokeRule.getRoute().size() - 1).getTagitem();
                if (!versionServerMap.containsKey(latestVTag)) {
                    versionServerMap.put(latestVTag, new ArrayList());
                }
                ((List)versionServerMap.get(latestVTag)).add(server);
            }
            if (targetTag == null) continue;
            if (!versionServerMap.containsKey(targetTag)) {
                versionServerMap.put(targetTag, new ArrayList());
            }
            ((List)versionServerMap.get(targetTag)).add(server);
        }
        return versionServerMap;
    }

    public void initLatestVersion(String serviceName, List<T> list) {
        String latestVersion = null;
        for (Server server : list) {
            E ms = this.getIns.apply(server);
            if (!this.getServerName.apply(ms).equals(serviceName) || latestVersion != null && VersionCompareUtil.compareVersion(latestVersion, this.getVersion.apply(ms)) != -1) continue;
            latestVersion = this.getVersion.apply(ms);
        }
        TagItem tagitem = new TagItem(latestVersion);
        RouterRuleCache.getServiceInfoCacheMap().get(serviceName).setLatestVersionTag(tagitem);
    }

    public List<T> getLatestVersionList(List<T> list, String targetServiceName) {
        String latestV = RouterRuleCache.getServiceInfoCacheMap().get(targetServiceName).getLatestVersionTag().getVersion();
        return list.stream().filter(server -> this.getVersion.apply(this.getIns.apply((Server)server)).equals(latestV)).collect(Collectors.toList());
    }
}

