/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.http.client.common.HttpConfiguration;

public class TransportUtils {
    public static HttpConfiguration.SSLProperties createSSLProperties(boolean sslEnabled, Configuration configuration, String tag) {
        HttpConfiguration.SSLProperties sslProperties = new HttpConfiguration.SSLProperties();
        sslProperties.setEnabled(sslEnabled);
        if (!sslEnabled) {
            return sslProperties;
        }
        SSLOption option = new SSLOption();
        option.setEngine(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getEngine(), "ssl." + tag + ".engine", "ssl.engine"));
        option.setProtocols(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getProtocols(), "ssl." + tag + ".protocols", "ssl.protocols"));
        option.setCiphers(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".ciphers", "ssl.ciphers"));
        option.setAuthPeer(TransportUtils.getBooleanProperty(configuration, SSLOption.DEFAULT_OPTION.isAuthPeer(), "ssl." + tag + ".authPeer", "ssl.authPeer"));
        option.setCheckCNHost(TransportUtils.getBooleanProperty(configuration, SSLOption.DEFAULT_OPTION.isCheckCNHost(), "ssl." + tag + ".checkCN.host", "ssl.checkCN.host"));
        option.setCheckCNWhite(TransportUtils.getBooleanProperty(configuration, SSLOption.DEFAULT_OPTION.isCheckCNWhite(), "ssl." + tag + ".checkCN.white", "ssl.checkCN.white"));
        option.setCheckCNWhiteFile(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".checkCN.white.file", "ssl.checkCN.white.file"));
        option.setAllowRenegociate(TransportUtils.getBooleanProperty(configuration, SSLOption.DEFAULT_OPTION.isAllowRenegociate(), "ssl." + tag + ".allowRenegociate", "ssl.allowRenegociate"));
        option.setStorePath(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getStorePath(), "ssl." + tag + ".storePath", "ssl.storePath"));
        option.setTrustStore(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getTrustStore(), "ssl." + tag + ".trustStore", "ssl.trustStore"));
        option.setTrustStoreType(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getTrustStoreType(), "ssl." + tag + ".trustStoreType", "ssl.trustStoreType"));
        option.setTrustStoreValue(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getTrustStoreValue(), "ssl." + tag + ".trustStoreValue", "ssl.trustStoreValue"));
        option.setKeyStore(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getKeyStore(), "ssl." + tag + ".keyStore", "ssl.keyStore"));
        option.setKeyStoreType(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getKeyStoreType(), "ssl." + tag + ".keyStoreType", "ssl.keyStoreType"));
        option.setKeyStoreValue(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getKeyStoreValue(), "ssl." + tag + ".keyStoreValue", "ssl.keyStoreValue"));
        option.setCrl(TransportUtils.getStringProperty(configuration, SSLOption.DEFAULT_OPTION.getCrl(), "ssl." + tag + ".crl", "ssl.crl"));
        option.setSslCustomClass(TransportUtils.getStringProperty(configuration, null, "ssl." + tag + ".sslCustomClass", "ssl.sslCustomClass"));
        sslProperties.setSslOption(option);
        sslProperties.setSslCustom(SSLCustom.createSSLCustom((String)option.getSslCustomClass()));
        return sslProperties;
    }

    private static String getStringProperty(Configuration configuration, String defaultValue, String ... keys) {
        for (String key : keys) {
            if (!configuration.containsKey(key)) continue;
            return configuration.getString(key);
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(Configuration configuration, boolean defaultValue, String ... keys) {
        for (String key : keys) {
            if (!configuration.containsKey(key)) continue;
            return configuration.getBoolean(key);
        }
        return defaultValue;
    }
}

