/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.Swagger;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.converter.Converter;
import org.apache.servicecomb.swagger.converter.ConverterMgr;

public abstract class AbstractConverter
implements Converter {
    protected abstract Map<String, Object> findVendorExtensions(Object var1);

    protected abstract JavaType doConvert(Swagger var1, Object var2);

    protected JavaType convertRef(Swagger swagger, String ref) {
        Object def = swagger.getDefinitions().get(ref);
        return ConverterMgr.findJavaType(swagger, def);
    }

    @Override
    public JavaType convert(Swagger swagger, Object def) {
        Map<String, Object> vendorExtensions = this.findVendorExtensions(def);
        String canonical = SwaggerUtils.getClassName(vendorExtensions);
        if (StringUtils.isEmpty((CharSequence)canonical)) {
            return this.doConvert(swagger, def);
        }
        try {
            return TypeFactory.defaultInstance().constructFromCanonical(canonical);
        }
        catch (Throwable e) {
            return OBJECT_JAVA_TYPE;
        }
    }
}

