/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.servicecomb.foundation.common.http.HttpUtils;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletRequest;

public class VertxClientRequestToHttpServletRequest
extends AbstractHttpServletRequest {
    private HttpClientRequest clientRequest;
    private String characterEncoding;

    public VertxClientRequestToHttpServletRequest(HttpClientRequest clientRequest, Buffer bodyBuffer) {
        this.clientRequest = clientRequest;
        this.setBodyBuffer(bodyBuffer);
    }

    @Override
    public String getRequestURI() {
        return this.clientRequest.path();
    }

    @Override
    public String getQueryString() {
        return this.clientRequest.query();
    }

    @Override
    public String getHeader(String name) {
        return this.clientRequest.headers().get(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.clientRequest.headers().getAll(name));
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.clientRequest.headers().names());
    }

    @Override
    public void setHeader(String name, String value) {
        this.clientRequest.headers().set(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.clientRequest.headers().add(name, value);
    }

    @Override
    public String getContextPath() {
        return "";
    }

    @Override
    public String getMethod() {
        return this.clientRequest.method().name();
    }

    @Override
    public String getContentType() {
        return this.clientRequest.headers().get("Content-Type");
    }

    @Override
    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = HttpUtils.getCharsetFromContentType((String)this.getContentType());
        }
        return this.characterEncoding;
    }
}

