/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;

public abstract class AbstractArgumentsMapperCreator {
    protected SerializationConfig serializationConfig;
    protected Map<Class<?>, ContextArgumentMapperFactory> contextFactorys;
    protected Method providerMethod;
    protected Class<?> providerClass;
    protected SwaggerOperation swaggerOperation;
    protected List<ArgumentMapper> mappers = new ArrayList<ArgumentMapper>();
    protected List<Parameter> swaggerParameters;
    protected int swaggerBodyIdx;
    protected BodyParameter bodyParameter;
    protected Map<String, Property> swaggerBodyProperties;
    protected Set<String> processedSwaggerParamters;

    public AbstractArgumentsMapperCreator(SerializationConfig serializationConfig, Map<Class<?>, ContextArgumentMapperFactory> contextFactorys, Class<?> providerClass, Method providerMethod, SwaggerOperation swaggerOperation) {
        this.serializationConfig = serializationConfig;
        this.contextFactorys = contextFactorys;
        this.providerClass = providerClass;
        this.providerMethod = providerMethod;
        this.swaggerOperation = swaggerOperation;
        this.swaggerParameters = new ArrayList<Parameter>(this.swaggerOperation.getOperation().getParameters());
        this.bodyParameter = this.findSwaggerBodyParameter();
        this.swaggerBodyProperties = SwaggerUtils.getBodyProperties((Swagger)swaggerOperation.getSwagger(), (Parameter)this.bodyParameter);
        this.processedSwaggerParamters = new HashSet<String>();
    }

    private BodyParameter findSwaggerBodyParameter() {
        for (int idx = 0; idx < this.swaggerParameters.size(); ++idx) {
            Parameter parameter = this.swaggerParameters.get(idx);
            if (!(parameter instanceof BodyParameter)) continue;
            this.swaggerBodyIdx = idx;
            return (BodyParameter)parameter;
        }
        return null;
    }

    protected Integer findSwaggerParameterIndex(String name) {
        for (int idx = 0; idx < this.swaggerParameters.size(); ++idx) {
            Parameter parameter = this.swaggerParameters.get(idx);
            if (parameter == null || !name.equals(parameter.getName())) continue;
            return idx;
        }
        return null;
    }

    protected void doCreateArgumentsMapper() {
        java.lang.reflect.Parameter[] providerParameters = this.providerMethod.getParameters();
        for (int providerParamIdx = 0; providerParamIdx < providerParameters.length; ++providerParamIdx) {
            java.lang.reflect.Parameter providerParameter = providerParameters[providerParamIdx];
            if (this.processContextParameter(providerParamIdx, providerParameter)) continue;
            String parameterName = SwaggerGeneratorUtils.collectParameterName((java.lang.reflect.Parameter)providerParameter);
            if (this.processKnownParameter(providerParamIdx, providerParameter, parameterName)) {
                this.processedSwaggerParamters.add(parameterName);
                continue;
            }
            if (this.processSwaggerBodyField(providerParamIdx, providerParameter, parameterName)) {
                this.processedSwaggerParamters.add(parameterName);
                continue;
            }
            JavaType providerType = TypeFactory.defaultInstance().constructType(providerParameter.getParameterizedType());
            if (SwaggerUtils.isBean((Type)providerType)) {
                this.processBeanParameter(providerParamIdx, providerParameter);
                continue;
            }
            this.processUnknownParameter(parameterName);
        }
        for (Parameter parameter : this.swaggerParameters) {
            if (this.processedSwaggerParamters.contains(parameter.getName())) continue;
            this.processPendingSwaggerParameter(parameter);
        }
    }

    protected boolean processContextParameter(int providerParamIdx, java.lang.reflect.Parameter providerParameter) {
        ContextArgumentMapperFactory contextFactory = this.contextFactorys.get(providerParameter.getType());
        if (contextFactory == null) {
            return false;
        }
        this.mappers.add(contextFactory.create(this.providerMethod.getParameters()[providerParamIdx].getName(), providerParameter.getName()));
        return true;
    }

    protected boolean processKnownParameter(int providerParamIdx, java.lang.reflect.Parameter providerParameter, String parameterName) {
        Integer swaggerIdx = this.findSwaggerParameterIndex(parameterName);
        if (swaggerIdx == null) {
            return false;
        }
        if (this.bodyParameter != null && !SwaggerUtils.isBean(providerParameter.getType()) && swaggerIdx == this.swaggerBodyIdx && SwaggerUtils.isBean((Model)this.bodyParameter.getSchema())) {
            return false;
        }
        ArgumentMapper mapper = this.createKnownParameterMapper(providerParamIdx, swaggerIdx);
        this.mappers.add(mapper);
        return true;
    }

    protected abstract ArgumentMapper createKnownParameterMapper(int var1, Integer var2);

    protected boolean processSwaggerBodyField(int providerParamIdx, java.lang.reflect.Parameter providerParameter, String parameterName) {
        if (this.swaggerBodyProperties == null) {
            return false;
        }
        Property property = this.swaggerBodyProperties.get(parameterName);
        if (property == null) {
            return false;
        }
        ArgumentMapper mapper = this.createSwaggerBodyFieldMapper(providerParamIdx, parameterName, this.swaggerBodyIdx);
        this.mappers.add(mapper);
        return true;
    }

    protected abstract ArgumentMapper createSwaggerBodyFieldMapper(int var1, String var2, int var3);

    protected abstract void processBeanParameter(int var1, java.lang.reflect.Parameter var2);

    protected abstract void processUnknownParameter(String var1);

    protected abstract void processPendingSwaggerParameter(Parameter var1);
}

