/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.sentry.service.thrift.SentryState;
import org.apache.sentry.service.thrift.SentryStateBank;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSentryStateBank {
    @Before
    public void setUp() {
        SentryStateBank.clearAllStates();
    }

    @Test
    public void testEnableState() {
        SentryStateBank.enableState((String)"TestState", (SentryState)TestState.FIRST_STATE);
        Assert.assertTrue((String)"Expected FIRST_STATE to be enabled", (boolean)SentryStateBank.isEnabled((String)"TestState", (SentryState)TestState.FIRST_STATE));
        Assert.assertFalse((String)"Expected SECOND_STATE to be disabled", (boolean)SentryStateBank.isEnabled((String)"TestState", (SentryState)TestState.SECOND_STATE));
    }

    @Test
    public void testStatesGetDisabled() {
        SentryStateBank.enableState((String)"TestState", (SentryState)TestState.FIRST_STATE);
        Assert.assertTrue((String)"Expected FIRST_STATE to be enabled", (boolean)SentryStateBank.isEnabled((String)"TestState", (SentryState)TestState.FIRST_STATE));
        SentryStateBank.disableState((String)"TestState", (SentryState)TestState.FIRST_STATE);
        Assert.assertFalse((String)"Expected FIRST_STATE to be disabled", (boolean)SentryStateBank.isEnabled((String)"TestState", (SentryState)TestState.FIRST_STATE));
    }

    @Test
    public void testCheckMultipleStateCheckSuccess() {
        SentryStateBank.enableState((String)"TestState", (SentryState)TestState.FIRST_STATE);
        SentryStateBank.enableState((String)"TestState", (SentryState)TestState.SECOND_STATE);
        Assert.assertTrue((String)"Expected both FIRST_STATE and SECOND_STATE to be enabled", (boolean)SentryStateBank.hasStatesEnabled((String)"TestState", new HashSet<TestState>(Arrays.asList(TestState.FIRST_STATE, TestState.SECOND_STATE))));
    }

    @Test
    public void testCheckMultipleStateCheckFailure() {
        SentryStateBank.enableState((String)"TestState", (SentryState)TestState.FIRST_STATE);
        Assert.assertFalse((String)"Expected only FIRST_STATE to be enabled", (boolean)SentryStateBank.hasStatesEnabled((String)"TestState", new HashSet<TestState>(Arrays.asList(TestState.FIRST_STATE, TestState.SECOND_STATE))));
    }

    public static enum TestState implements SentryState
    {
        FIRST_STATE,
        SECOND_STATE;

        public static final String COMPONENT = "TestState";

        public long getValue() {
            return 1 << this.ordinal();
        }
    }
}

