/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.sentry.provider.db.service.persistent.PathsImage;
import org.apache.sentry.service.thrift.HMSClient;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.sentry.service.thrift.SentryHMSClient;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestSentryHMSClient {
    private static final Configuration conf = new Configuration();
    private static SentryHMSClient client;
    private static MockHMSClientFactory hiveConnectionFactory;

    private static Database makeDb(String name) {
        Database db = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)db.getName()).thenReturn((Object)name);
        Mockito.when((Object)db.getLocationUri()).thenReturn((Object)("hdfs:///" + name));
        return db;
    }

    private static Table makeTable(String dbName, String tableName) {
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)table.getDbName()).thenReturn((Object)dbName);
        Mockito.when((Object)table.getTableName()).thenReturn((Object)tableName);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)sd.getLocation()).thenReturn((Object)String.format("hdfs:///%s/%s", dbName, tableName));
        Mockito.when((Object)table.getSd()).thenReturn((Object)sd);
        return table;
    }

    private static Partition makePartition(String dbName, String tableName, String partName) {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)sd.getLocation()).thenReturn((Object)String.format("hdfs:///%s/%s/%s", dbName, tableName, partName));
        Mockito.when((Object)partition.getSd()).thenReturn((Object)sd);
        return partition;
    }

    @BeforeClass
    public static void initialize() throws IOException, LoginException {
        hiveConnectionFactory = new MockHMSClientFactory();
        client = new SentryHMSClient(conf, (HiveConnectionFactory)hiveConnectionFactory);
    }

    @Test
    public void testSnapshotCreationWithOutClientConnected() throws Exception {
        Assert.assertFalse((boolean)client.isConnected());
        PathsImage snapshotInfo = client.getFullSnapshot();
        Assert.assertTrue((boolean)snapshotInfo.getPathImage().isEmpty());
    }

    @Test
    public void testSnapshotCreationWithNoHmsData() throws Exception {
        MockClient mockClient = new MockClient(new HiveSnapshot(), 1L);
        client.setClient(mockClient.client);
        Assert.assertTrue((boolean)client.isConnected());
        PathsImage snapshotInfo = client.getFullSnapshot();
        Assert.assertTrue((boolean)snapshotInfo.getPathImage().isEmpty());
    }

    @Test
    public void testSnapshotCreationWhenDataIsActivelyUpdated() throws Exception {
        HiveTable tab21 = new HiveTable("tab21");
        HiveTable tab31 = new HiveTable("tab31").add("part311").add("part312");
        HiveDb db3 = new HiveDb("db3", Lists.newArrayList((Object[])new HiveTable[]{tab31}));
        HiveDb db2 = new HiveDb("db2", Lists.newArrayList((Object[])new HiveTable[]{tab21}));
        HiveDb db1 = new HiveDb("db1");
        HiveSnapshot snap = new HiveSnapshot().add(db1).add(db2).add(db3);
        final MockClient mockClient = new MockClient(snap, 1L);
        client.setClient(mockClient.client);
        hiveConnectionFactory.setClient(mockClient);
        Assert.assertTrue((boolean)client.isConnected());
        PathsImage snapshotInfo = client.getFullSnapshot();
        Assert.assertTrue((!snapshotInfo.getPathImage().isEmpty() ? 1 : 0) != 0);
        Mockito.when((Object)mockClient.client.getCurrentNotificationEventId()).thenAnswer((Answer)new Answer<CurrentNotificationEventId>(){

            public CurrentNotificationEventId answer(InvocationOnMock invocation) throws Throwable {
                return new CurrentNotificationEventId(mockClient.incrementNotificationEventId().longValue());
            }
        });
        snapshotInfo = client.getFullSnapshot();
        Assert.assertTrue((boolean)snapshotInfo.getPathImage().isEmpty());
    }

    @Test
    public void testSnapshotCreationSuccess() throws Exception {
        HiveTable tab21 = new HiveTable("tab21");
        HiveTable tab31 = new HiveTable("tab31");
        HiveDb db3 = new HiveDb("db3", Lists.newArrayList((Object[])new HiveTable[]{tab31}));
        HiveDb db2 = new HiveDb("db2", Lists.newArrayList((Object[])new HiveTable[]{tab21}));
        HiveDb db1 = new HiveDb("db1");
        HiveSnapshot snap = new HiveSnapshot().add(db1).add(db2).add(db3);
        MockClient mockClient = new MockClient(snap, 1L);
        Mockito.when((Object)mockClient.client.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(mockClient.eventId));
        client.setClient(mockClient.client);
        hiveConnectionFactory.setClient(mockClient);
        Assert.assertTrue((boolean)client.isConnected());
        PathsImage snapshotInfo = client.getFullSnapshot();
        Assert.assertEquals((long)5L, (long)snapshotInfo.getPathImage().size());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db1"}), snapshotInfo.getPathImage().get("db1"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db2"}), snapshotInfo.getPathImage().get("db2"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db3"}), snapshotInfo.getPathImage().get("db3"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db2/tab21"}), snapshotInfo.getPathImage().get("db2.tab21"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db3/tab31"}), snapshotInfo.getPathImage().get("db3.tab31"));
        Assert.assertEquals((long)snapshotInfo.getId(), (long)mockClient.eventId);
    }

    private static class MockClient {
        public HiveMetaStoreClient client;
        public long eventId;

        MockClient(HiveSnapshot snapshot, long eventId) throws TException {
            this.eventId = eventId;
            this.client = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
            ArrayList<String> dbNames = new ArrayList<String>(snapshot.databases.size());
            for (HiveDb mdb : snapshot.databases) {
                String dbName = mdb.name;
                dbNames.add(dbName);
                Database db = TestSentryHMSClient.makeDb(dbName);
                Mockito.when((Object)this.client.getDatabase(dbName)).thenReturn((Object)db);
                ArrayList<String> tableNames = new ArrayList<String>(mdb.tables.size());
                for (HiveTable table : mdb.tables) {
                    String tableName = table.name;
                    tableNames.add(tableName);
                    Table mockTable = TestSentryHMSClient.makeTable(dbName, tableName);
                    Mockito.when((Object)this.client.getTableObjectsByName(dbName, (List)Lists.newArrayList((Object[])new String[]{tableName}))).thenReturn((Object)Lists.newArrayList((Object[])new Table[]{mockTable}));
                    Mockito.when((Object)this.client.listPartitionNames(dbName, tableName, (short)-1)).thenReturn((Object)table.partitions);
                    for (String partName : table.partitions) {
                        Partition p = TestSentryHMSClient.makePartition(dbName, tableName, partName);
                        Mockito.when((Object)this.client.getPartitionsByNames(dbName, tableName, (List)Lists.newArrayList((Object[])new String[]{partName}))).thenReturn((Object)Lists.newArrayList((Object[])new Partition[]{p}));
                    }
                }
                Mockito.when((Object)this.client.getAllTables(dbName)).thenReturn(tableNames);
            }
            Mockito.when((Object)this.client.getAllDatabases()).thenReturn(dbNames);
            Mockito.when((Object)this.client.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(eventId));
        }

        public Long incrementNotificationEventId() {
            ++this.eventId;
            return this.eventId;
        }
    }

    private static class MockHMSClientFactory
    implements HiveConnectionFactory {
        private HiveMetaStoreClient mClient = null;

        void setClient(MockClient mockClient) {
            this.mClient = mockClient.client;
        }

        public HMSClient connect() throws IOException, InterruptedException, MetaException {
            return new HMSClient(this.mClient);
        }

        public void close() throws Exception {
        }
    }

    private static class HiveSnapshot {
        final List<HiveDb> databases = new ArrayList<HiveDb>();

        HiveSnapshot() {
        }

        HiveSnapshot(Collection<HiveDb> dblist) {
            if (dblist != null) {
                this.databases.addAll(dblist);
            }
        }

        HiveSnapshot add(HiveDb db) {
            this.databases.add(db);
            return this;
        }
    }

    private static class HiveDb {
        final String name;
        Collection<HiveTable> tables;

        HiveDb(String name) {
            this.name = name;
            this.tables = new ArrayList<HiveTable>();
        }

        HiveDb(String name, Collection<HiveTable> tables) {
            this.name = name;
            this.tables = tables;
            if (this.tables == null) {
                this.tables = new ArrayList<HiveTable>();
            }
        }

        void add(HiveTable table) {
            this.tables.add(table);
        }
    }

    private static class HiveTable {
        private final String name;
        private final List<String> partitions;

        HiveTable(String name) {
            this.name = name;
            this.partitions = new ArrayList<String>();
        }

        HiveTable add(String partition) {
            this.partitions.add(partition);
            return this;
        }
    }
}

