/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageFactory;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.service.thrift.NotificationProcessor;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestNotificationProcessor {
    private static final SentryStore sentryStore = (SentryStore)Mockito.mock(SentryStore.class);
    private static final String hiveInstance = "server2";
    private static final Configuration conf = new Configuration();
    private final SentryJSONMessageFactory messageFactory = new SentryJSONMessageFactory();
    private NotificationProcessor notificationProcessor;

    @BeforeClass
    public static void setup() {
        conf.set("sentry.hive.sync.create", "true");
        conf.set("sentry.hive.sync.drop", "true");
        conf.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        conf.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
    }

    @After
    public void resetConf() {
        conf.set("sentry.hive.sync.create", "true");
        conf.set("sentry.hive.sync.drop", "true");
        Mockito.reset((Object[])new SentryStore[]{sentryStore});
    }

    @Test
    public void testCreateDatabase() throws Exception {
        long seqNum = 1L;
        String dbName = "db1";
        String uriPrefix = "hdfs:///";
        String location = "user/hive/warehouse";
        this.notificationProcessor = new NotificationProcessor(sentryStore, hiveInstance, conf);
        NotificationEvent notificationEvent = new NotificationEvent(seqNum, 0, EventMessage.EventType.CREATE_DATABASE.toString(), this.messageFactory.buildCreateDatabaseMessage(new Database(dbName, null, uriPrefix + location, null)).toString());
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
        Mockito.reset((Object[])new SentryStore[]{sentryStore});
        this.notificationProcessor.setSyncStoreOnCreate(false);
        dbName = "db2";
        notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), this.messageFactory.buildCreateDatabaseMessage(new Database(dbName, null, "hdfs:///db2", null)).toString());
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb(dbName);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)0))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testDropDatabase() throws Exception {
        String dbName = "db1";
        this.notificationProcessor = new NotificationProcessor(sentryStore, hiveInstance, conf);
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.DROP_DATABASE.toString(), this.messageFactory.buildDropDatabaseMessage(new Database(dbName, null, "hdfs:///db1", null)).toString());
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).deleteAuthzPathsMapping(Mockito.anyString(), (Iterable)Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
        Mockito.reset((Object[])new SentryStore[]{sentryStore});
        this.notificationProcessor.setSyncStoreOnDrop(false);
        dbName = "db2";
        notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.DROP_DATABASE.toString(), this.messageFactory.buildDropDatabaseMessage(new Database(dbName, null, "hdfs:///db2", null)).toString());
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb(dbName);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).deleteAuthzPathsMapping(Mockito.anyString(), (Iterable)Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)0))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testCreateTable() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        this.notificationProcessor = new NotificationProcessor(sentryStore, hiveInstance, conf);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), Collections.emptyIterator()).toString());
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        authorizable.setTable(tableName);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
        Mockito.reset((Object[])new SentryStore[]{sentryStore});
        this.notificationProcessor.setSyncStoreOnCreate(false);
        dbName = "db2";
        tableName = "table2";
        sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table2");
        notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), Collections.emptyIterator()).toString());
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb(dbName);
        authorizable.setTable(tableName);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)0))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testDropTable() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        Configuration authConf = new Configuration();
        authConf.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        authConf.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
        this.notificationProcessor = new NotificationProcessor(sentryStore, hiveInstance, authConf);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.DROP_TABLE.toString(), this.messageFactory.buildDropTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        authorizable.setTable(tableName);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).deleteAllAuthzPathsMapping(Mockito.anyString(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testAlterTable() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        String newDbName = "db1";
        String newTableName = "table2";
        Configuration authConf = new Configuration();
        authConf.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        authConf.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
        this.notificationProcessor = new NotificationProcessor(sentryStore, hiveInstance, authConf);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.ALTER_TABLE.toString(), this.messageFactory.buildAlterTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), new Table(newTableName, newDbName, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        notificationEvent.setDbName(newDbName);
        notificationEvent.setTableName(newTableName);
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb(dbName);
        authorizable.setTable(tableName);
        TSentryAuthorizable newAuthorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        newAuthorizable.setDb(newDbName);
        newAuthorizable.setTable(newTableName);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).renameAuthzObj(Mockito.anyString(), Mockito.anyString(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).renamePrivilege(authorizable, newAuthorizable, NotificationProcessor.getPermUpdatableOnRename((TSentryAuthorizable)authorizable, (TSentryAuthorizable)newAuthorizable));
    }

    @Test
    public void testRenameTableWithLocationUpdate() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        String newDbName = "db1";
        String newTableName = "table2";
        Configuration authConf = new Configuration();
        authConf.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        authConf.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
        this.notificationProcessor = new NotificationProcessor(sentryStore, hiveInstance, authConf);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        StorageDescriptor new_sd = new StorageDescriptor();
        new_sd.setLocation("hdfs:///db1.db/table2");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.ALTER_TABLE.toString(), this.messageFactory.buildAlterTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), new Table(newTableName, newDbName, null, 0, 0, 0, new_sd, null, null, null, null, null)).toString());
        notificationEvent.setDbName(newDbName);
        notificationEvent.setTableName(newTableName);
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb(dbName);
        authorizable.setTable(tableName);
        TSentryAuthorizable newAuthorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        newAuthorizable.setDb(newDbName);
        newAuthorizable.setTable(newTableName);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).renameAuthzPathsMapping(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).renamePrivilege(authorizable, newAuthorizable, NotificationProcessor.getPermUpdatableOnRename((TSentryAuthorizable)authorizable, (TSentryAuthorizable)newAuthorizable));
    }

    @Test
    public void testAlterTableWithInvalidEvent() throws Exception {
        String dbName = "db1";
        String tableName1 = "table1";
        String tableName2 = "table2";
        long inputEventId = 1L;
        ((SentryStore)Mockito.doNothing().when((Object)sentryStore)).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        ((SentryStore)Mockito.doNothing().when((Object)sentryStore)).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        Configuration authConf = new Configuration();
        authConf.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        authConf.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
        this.notificationProcessor = new NotificationProcessor(sentryStore, hiveInstance, authConf);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs://db1.db/table1");
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName1, dbName, null, 0, 0, 0, sd, partCols, null, null, null, null);
        NotificationEvent notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(table, Collections.emptyIterator()).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        ++inputEventId;
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        Mockito.reset((Object[])new SentryStore[]{sentryStore});
        notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.ALTER_TABLE.toString(), this.messageFactory.buildAlterTableMessage(new Table(tableName1, dbName, null, 0, 0, 0, sd, null, null, null, null, null), new Table(tableName1, dbName, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        ++inputEventId;
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)0))).renameAuthzObj(Mockito.anyString(), Mockito.anyString(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)0))).deleteAuthzPathsMapping(Mockito.anyString(), (Iterable)Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        Mockito.reset((Object[])new SentryStore[]{sentryStore});
        sd = new StorageDescriptor();
        sd.setLocation("hdfs://db1.db/table2");
        partCols = new ArrayList();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table1 = new Table(tableName2, dbName, null, 0, 0, 0, sd, partCols, null, null, null, null);
        notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(table1, Collections.emptyIterator()).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName2);
        this.notificationProcessor.processNotificationEvent(notificationEvent);
        ((SentryStore)Mockito.verify((Object)sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
    }
}

