/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.persistent.HAContext;
import org.apache.sentry.service.thrift.LeaderStatusMonitor;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLeaderStatusMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestLeaderStatusMonitor.class);
    private static final int DELAY_MS = 500;
    private static final int NTRIES = 360;
    private static final int ITERATIONS = 10;

    private boolean isLeader(LeaderStatusMonitor monitor) {
        for (int i = 0; i < 360; ++i) {
            if (monitor.isLeader()) {
                return true;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
            }
        }
        return false;
    }

    @Test
    public void testNoZk() throws Exception {
        Configuration conf = new Configuration();
        LeaderStatusMonitor monitor = new LeaderStatusMonitor(conf);
        Assert.assertTrue((boolean)monitor.isLeader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleServer() throws Exception {
        try (TestingServer zkServer = new TestingServer();){
            zkServer.start();
            Configuration conf = new Configuration();
            conf.set("sentry.ha.zookeeper.quorum", zkServer.getConnectString());
            try (LeaderStatusMonitor monitor = new LeaderStatusMonitor(conf);){
                monitor.init();
                for (int i = 0; i < 10; ++i) {
                    Assert.assertTrue((boolean)this.isLeader(monitor));
                    LOGGER.debug("testSingleServer(): deactivating leader");
                    monitor.deactivate();
                    Thread.sleep(1000L);
                    Assert.assertTrue((boolean)this.isLeader(monitor));
                    LOGGER.info("testSingleServer({}, leaderCount = {}", (Object)i, (Object)monitor.getLeaderCount());
                }
                Assert.assertEquals((long)11L, (long)monitor.getLeaderCount());
            }
        }
        finally {
            HAContext.resetHAContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleServerZkRestart() throws Exception {
        try (TestingServer zkServer = new TestingServer();){
            zkServer.start();
            Configuration conf = new Configuration();
            conf.set("sentry.ha.zookeeper.quorum", zkServer.getConnectString());
            try (LeaderStatusMonitor monitor = new LeaderStatusMonitor(conf);){
                monitor.init();
                for (int i = 0; i < 10; ++i) {
                    Assert.assertTrue((boolean)this.isLeader(monitor));
                    LOGGER.debug("testSingleServerZkRestart(): restarting Zk server");
                    zkServer.restart();
                    Assert.assertTrue((boolean)this.isLeader(monitor));
                    LOGGER.info("testSingleServerZkRestart({}, leaderCount = {}", (Object)i, (Object)monitor.getLeaderCount());
                    Assert.assertEquals((long)(i + 2), (long)monitor.getLeaderCount());
                }
            }
        }
        finally {
            HAContext.resetHAContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoServers() throws Exception {
        try (TestingServer zkServer = new TestingServer();){
            zkServer.start();
            Configuration conf = new Configuration();
            conf.set("sentry.ha.zookeeper.quorum", zkServer.getConnectString());
            try (LeaderStatusMonitor monitor1 = new LeaderStatusMonitor(conf, "1");
                 LeaderStatusMonitor monitor2 = new LeaderStatusMonitor(conf, "2");){
                int i;
                monitor1.init();
                monitor2.init();
                for (i = 0; i < 360 && !monitor1.isLeader() && !monitor2.isLeader(); ++i) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException ignored) {
                        Thread.interrupted();
                    }
                }
                for (i = 0; i < 10; ++i) {
                    monitor2.deactivate();
                    Assert.assertTrue((boolean)this.isLeader(monitor1));
                    monitor1.deactivate();
                    Assert.assertTrue((boolean)this.isLeader(monitor2));
                }
            }
        }
        finally {
            HAContext.resetHAContext();
        }
    }
}

