/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.service.thrift.HMSClient;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.sentry.service.thrift.HiveNotificationFetcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestHiveNotificationFetcher {
    @Test
    public void testGetEmptyNotificationsWhenHmsReturnsANullResponse() throws Exception {
        SentryStore store = (SentryStore)Mockito.mock(SentryStore.class);
        HiveConnectionFactory hmsConnection = (HiveConnectionFactory)Mockito.mock(HiveConnectionFactory.class);
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        Mockito.when((Object)hmsConnection.connect()).thenReturn((Object)new HMSClient(hmsClient));
        try (HiveNotificationFetcher fetcher = new HiveNotificationFetcher(store, hmsConnection);){
            Mockito.when((Object)hmsClient.getNextNotification(0L, Integer.MAX_VALUE, null)).thenReturn(null);
            List events = fetcher.fetchNotifications(0L);
            Assert.assertTrue((boolean)events.isEmpty());
        }
    }

    @Test
    public void testGetEmptyNotificationsWhenHmsReturnsEmptyEvents() throws Exception {
        SentryStore store = (SentryStore)Mockito.mock(SentryStore.class);
        HiveConnectionFactory hmsConnection = (HiveConnectionFactory)Mockito.mock(HiveConnectionFactory.class);
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        Mockito.when((Object)hmsConnection.connect()).thenReturn((Object)new HMSClient(hmsClient));
        try (HiveNotificationFetcher fetcher = new HiveNotificationFetcher(store, hmsConnection);){
            Mockito.when((Object)hmsClient.getNextNotification(0L, Integer.MAX_VALUE, null)).thenReturn((Object)new NotificationEventResponse(Collections.emptyList()));
            List events = fetcher.fetchNotifications(0L);
            Assert.assertTrue((boolean)events.isEmpty());
        }
    }

    @Test
    public void testGetAllNotificationsReturnedByHms() throws Exception {
        SentryStore store = (SentryStore)Mockito.mock(SentryStore.class);
        HiveConnectionFactory hmsConnection = (HiveConnectionFactory)Mockito.mock(HiveConnectionFactory.class);
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        Mockito.when((Object)hmsConnection.connect()).thenReturn((Object)new HMSClient(hmsClient));
        try (HiveNotificationFetcher fetcher = new HiveNotificationFetcher(store, hmsConnection);){
            Mockito.when((Object)hmsClient.getNextNotification(0L, Integer.MAX_VALUE, null)).thenReturn((Object)new NotificationEventResponse(Arrays.asList(new NotificationEvent(1L, 0, "CREATE_DATABASE", ""), new NotificationEvent(2L, 0, "CREATE_TABLE", ""))));
            List events = fetcher.fetchNotifications(0L);
            Assert.assertEquals((long)2L, (long)events.size());
            Assert.assertEquals((long)1L, (long)((NotificationEvent)events.get(0)).getEventId());
            Assert.assertEquals((Object)"CREATE_DATABASE", (Object)((NotificationEvent)events.get(0)).getEventType());
            Assert.assertEquals((long)2L, (long)((NotificationEvent)events.get(1)).getEventId());
            Assert.assertEquals((Object)"CREATE_TABLE", (Object)((NotificationEvent)events.get(1)).getEventType());
        }
    }

    @Test
    public void testGetDuplicatedEventsAndFilterEventsAlreadySeen() throws Exception {
        final SentryStore store = (SentryStore)Mockito.mock(SentryStore.class);
        HiveConnectionFactory hmsConnection = (HiveConnectionFactory)Mockito.mock(HiveConnectionFactory.class);
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        Mockito.when((Object)hmsConnection.connect()).thenReturn((Object)new HMSClient(hmsClient));
        try (HiveNotificationFetcher fetcher = new HiveNotificationFetcher(store, hmsConnection);){
            Mockito.when((Object)hmsClient.getNextNotification(Mockito.eq((long)0L), Mockito.eq((int)Integer.MAX_VALUE), (IMetaStoreClient.NotificationFilter)Mockito.notNull())).thenAnswer((Answer)new Answer<NotificationEventResponse>(){

                public NotificationEventResponse answer(InvocationOnMock invocation) throws Throwable {
                    IMetaStoreClient.NotificationFilter filter = (IMetaStoreClient.NotificationFilter)invocation.getArguments()[2];
                    NotificationEventResponse response = new NotificationEventResponse();
                    List<NotificationEvent> events = Arrays.asList(new NotificationEvent(1L, 0, "CREATE_DATABASE", ""), new NotificationEvent(1L, 0, "CREATE_TABLE", ""), new NotificationEvent(2L, 0, "ALTER_TABLE", ""));
                    for (NotificationEvent event : events) {
                        String hash = UniquePathsUpdate.sha1((NotificationEvent)event);
                        if (event.getEventType().equals("CREATE_DATABASE")) {
                            Mockito.when((Object)store.isNotificationProcessed((String)Mockito.eq((Object)hash))).thenReturn((Object)true);
                        } else {
                            Mockito.when((Object)store.isNotificationProcessed((String)Mockito.eq((Object)hash))).thenReturn((Object)false);
                        }
                        if (!filter.accept(event)) continue;
                        response.addToEvents(event);
                    }
                    return response;
                }
            });
            List events = fetcher.fetchNotifications(1L);
            Assert.assertEquals((long)2L, (long)events.size());
            Assert.assertEquals((long)1L, (long)((NotificationEvent)events.get(0)).getEventId());
            Assert.assertEquals((Object)"CREATE_TABLE", (Object)((NotificationEvent)events.get(0)).getEventType());
            Assert.assertEquals((long)2L, (long)((NotificationEvent)events.get(1)).getEventId());
            Assert.assertEquals((Object)"ALTER_TABLE", (Object)((NotificationEvent)events.get(1)).getEventType());
        }
    }
}

