/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.login.LoginException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageFactory;
import org.apache.sentry.core.common.utils.PubSub;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.provider.db.service.persistent.PathsImage;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.service.thrift.HMSClient;
import org.apache.sentry.service.thrift.HMSFollower;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.sentry.service.thrift.HiveSimpleConnectionFactory;
import org.apache.sentry.service.thrift.NotificationProcessor;
import org.apache.sentry.service.thrift.SentryHMSClient;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHMSFollower {
    private static final String hiveInstance = "server2";
    private static final Configuration configuration = new Configuration();
    private final SentryJSONMessageFactory messageFactory = new SentryJSONMessageFactory();
    private final SentryStore sentryStore = (SentryStore)Mockito.mock(SentryStore.class);
    private static HiveSimpleConnectionFactory hiveConnectionFactory;
    private static final HiveConnectionFactory hmsConnectionMock;
    private static final HiveMetaStoreClient hmsClientMock;

    @BeforeClass
    public static void setup() throws IOException, LoginException {
        hiveConnectionFactory = new HiveSimpleConnectionFactory(configuration, new HiveConf());
        hiveConnectionFactory.init();
        configuration.set("sentry.hive.sync.create", "true");
        configuration.set("sentry.hdfs.sync.full-update-pubsub", "true");
        configuration.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        configuration.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
    }

    @Before
    public void setupMocks() throws Exception {
        Mockito.reset((Object[])new Object[]{hmsConnectionMock, hmsClientMock});
        Mockito.when((Object)hmsConnectionMock.connect()).thenReturn((Object)new HMSClient(hmsClientMock));
    }

    @Test
    public void testPersistAFullSnapshotWhenNoSnapshotAreProcessedYet() throws Exception {
        long SENTRY_PROCESSED_EVENT_ID = 0L;
        long HMS_PROCESSED_EVENT_ID = 1L;
        HashMap<String, HashSet> snapshotObjects = new HashMap<String, HashSet>();
        snapshotObjects.put("db", Sets.newHashSet((Object[])new String[]{"/db"}));
        snapshotObjects.put("db.table", Sets.newHashSet((Object[])new String[]{"/db/table"}));
        PathsImage fullSnapshot = new PathsImage(snapshotObjects, 1L, 1L);
        Mockito.when((Object)hmsClientMock.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(fullSnapshot.getId()));
        SentryHMSClient sentryHmsClient = (SentryHMSClient)Mockito.mock(SentryHMSClient.class);
        Mockito.when((Object)sentryHmsClient.getFullSnapshot()).thenReturn((Object)fullSnapshot);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, hmsConnectionMock, hiveInstance);
        hmsFollower.setSentryHmsClient(sentryHmsClient);
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)0L);
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.sentryStore.isHmsNotificationEmpty()).thenReturn((Object)true);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistFullPathsImage(fullSnapshot.getPathImage(), fullSnapshot.getId());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)fullSnapshot.getId());
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistFullPathsImage(Mockito.anyMap(), Mockito.anyLong());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testPersistAFullSnapshotWhenFullSnapshotTrigger() throws Exception {
        long SENTRY_PROCESSED_EVENT_ID = 0L;
        long HMS_PROCESSED_EVENT_ID = 1L;
        HashMap<String, HashSet> snapshotObjects = new HashMap<String, HashSet>();
        snapshotObjects.put("db", Sets.newHashSet((Object[])new String[]{"/db"}));
        snapshotObjects.put("db.table", Sets.newHashSet((Object[])new String[]{"/db/table"}));
        PathsImage fullSnapshot = new PathsImage(snapshotObjects, 1L, 1L);
        Mockito.when((Object)hmsClientMock.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(fullSnapshot.getId()));
        SentryHMSClient sentryHmsClient = (SentryHMSClient)Mockito.mock(SentryHMSClient.class);
        Mockito.when((Object)sentryHmsClient.getFullSnapshot()).thenReturn((Object)fullSnapshot);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, hmsConnectionMock, hiveInstance);
        hmsFollower.setSentryHmsClient(sentryHmsClient);
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)0L);
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.sentryStore.isHmsNotificationEmpty()).thenReturn((Object)true);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistFullPathsImage(fullSnapshot.getPathImage(), fullSnapshot.getId());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)fullSnapshot.getId());
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistFullPathsImage(Mockito.anyMap(), Mockito.anyLong());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        PubSub.getInstance().publish(PubSub.Topic.HDFS_SYNC_HMS, "message");
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)fullSnapshot.getId());
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistFullPathsImage(fullSnapshot.getPathImage(), fullSnapshot.getId());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)fullSnapshot.getId());
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistFullPathsImage(Mockito.anyMap(), Mockito.anyLong());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testPersistAFullSnapshotWhenAuthzsnapshotIsEmptyAndHDFSSyncIsEnabled() throws Exception {
        configuration.set("sentry.service.processor.factories", "");
        configuration.set("sentry.policy.store.plugins", "");
        long SENTRY_PROCESSED_EVENT_ID = 0L;
        long HMS_PROCESSED_EVENT_ID = 1L;
        HashMap<String, HashSet> snapshotObjects = new HashMap<String, HashSet>();
        snapshotObjects.put("db", Sets.newHashSet((Object[])new String[]{"/db"}));
        snapshotObjects.put("db.table", Sets.newHashSet((Object[])new String[]{"/db/table"}));
        PathsImage fullSnapshot = new PathsImage(snapshotObjects, 1L, 1L);
        SentryHMSClient sentryHmsClient = (SentryHMSClient)Mockito.mock(SentryHMSClient.class);
        Mockito.when((Object)sentryHmsClient.getFullSnapshot()).thenReturn((Object)fullSnapshot);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, hmsConnectionMock, hiveInstance);
        hmsFollower.setSentryHmsClient(sentryHmsClient);
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)0L);
        Mockito.when((Object)this.sentryStore.isHmsNotificationEmpty()).thenReturn((Object)true);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistFullPathsImage(fullSnapshot.getPathImage(), fullSnapshot.getId());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).setLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        configuration.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        configuration.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
        hmsFollower = new HMSFollower(configuration, this.sentryStore, null, hmsConnectionMock, hiveInstance);
        hmsFollower.setSentryHmsClient(sentryHmsClient);
        long LATEST_EVENT_ID = 1L;
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)1L);
        Mockito.when((Object)this.sentryStore.isHmsNotificationEmpty()).thenReturn((Object)false);
        Mockito.when((Object)hmsClientMock.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(1L));
        Mockito.when((Object)hmsClientMock.getNextNotification(Mockito.eq((long)0L), Mockito.eq((int)Integer.MAX_VALUE), (IMetaStoreClient.NotificationFilter)Mockito.notNull())).thenReturn((Object)new NotificationEventResponse(Arrays.asList(new NotificationEvent(1L, 0, "", ""))));
        Mockito.when((Object)this.sentryStore.isAuthzPathsSnapshotEmpty()).thenReturn((Object)true);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistFullPathsImage(fullSnapshot.getPathImage(), fullSnapshot.getId());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).setLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
    }

    @Test
    public void testPersistAFullSnapshotWhenLastHmsNotificationIsLowerThanLastProcessed() throws Exception {
        long SENTRY_PROCESSED_EVENT_ID = 5L;
        long HMS_PROCESSED_EVENT_ID = 1L;
        HashMap<String, HashSet> snapshotObjects = new HashMap<String, HashSet>();
        snapshotObjects.put("db", Sets.newHashSet((Object[])new String[]{"/db"}));
        snapshotObjects.put("db.table", Sets.newHashSet((Object[])new String[]{"/db/table"}));
        PathsImage fullSnapshot = new PathsImage(snapshotObjects, 1L, 1L);
        Mockito.when((Object)hmsClientMock.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(fullSnapshot.getId()));
        SentryHMSClient sentryHmsClient = (SentryHMSClient)Mockito.mock(SentryHMSClient.class);
        Mockito.when((Object)sentryHmsClient.getFullSnapshot()).thenReturn((Object)fullSnapshot);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, hmsConnectionMock, hiveInstance);
        hmsFollower.setSentryHmsClient(sentryHmsClient);
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)5L);
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistFullPathsImage(Mockito.anyMap(), Mockito.anyLong());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)1L);
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistFullPathsImage(Mockito.anyMap(), Mockito.anyLong());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testPersistAFullSnapshotWhenNextExpectedEventIsNotAvailable() throws Exception {
        long SENTRY_PROCESSED_EVENT_ID = 1L;
        long HMS_PROCESSED_EVENT_ID = 5L;
        HashMap<String, HashSet> snapshotObjects = new HashMap<String, HashSet>();
        snapshotObjects.put("db", Sets.newHashSet((Object[])new String[]{"/db"}));
        snapshotObjects.put("db.table", Sets.newHashSet((Object[])new String[]{"/db/table"}));
        PathsImage fullSnapshot = new PathsImage(snapshotObjects, 5L, 1L);
        Mockito.when((Object)hmsClientMock.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(fullSnapshot.getId()));
        SentryHMSClient sentryHmsClient = (SentryHMSClient)Mockito.mock(SentryHMSClient.class);
        Mockito.when((Object)sentryHmsClient.getFullSnapshot()).thenReturn((Object)fullSnapshot);
        Mockito.when((Object)hmsClientMock.getNextNotification(Mockito.eq((long)0L), Mockito.eq((int)Integer.MAX_VALUE), (IMetaStoreClient.NotificationFilter)Mockito.notNull())).thenReturn((Object)new NotificationEventResponse(Arrays.asList(new NotificationEvent(fullSnapshot.getId(), 0, "", ""))));
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, hmsConnectionMock, hiveInstance);
        hmsFollower.setSentryHmsClient(sentryHmsClient);
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)1L);
        Mockito.when((Object)this.sentryStore.isHmsNotificationEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistFullPathsImage(Mockito.anyMap(), Mockito.anyLong());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)5L);
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistFullPathsImage(Mockito.anyMap(), Mockito.anyLong());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testInputConfigurationGetInputAuthServerName() {
        Configuration sentryConfiguration = new Configuration();
        HMSFollower hmsFollower = new HMSFollower(sentryConfiguration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        String authServerName = hmsFollower.getAuthServerName();
        Assert.assertEquals((boolean)true, (boolean)authServerName.equals(hiveInstance));
    }

    @Test
    public void testNoConfigurationGetDefaultAuthServerName() {
        Configuration sentryConfiguration = new Configuration();
        HMSFollower hmsFollower = new HMSFollower(sentryConfiguration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, null);
        String authServerName = hmsFollower.getAuthServerName();
        Assert.assertEquals((boolean)true, (boolean)authServerName.equals(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME_DEPRECATED.getDefault()));
    }

    @Test
    public void testNewNameConfigurationGetAuthServerName() {
        String serverName = "newServer";
        Configuration sentryConfiguration = new Configuration();
        sentryConfiguration.set(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar(), serverName);
        HMSFollower hmsFollower = new HMSFollower(sentryConfiguration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, null);
        String authServerName = hmsFollower.getAuthServerName();
        Assert.assertEquals((boolean)true, (boolean)authServerName.equals(serverName));
    }

    @Test
    public void testOldNameConfigurationGetAuthServerName() {
        String serverName = "oldServer";
        Configuration sentryConfiguration = new Configuration();
        sentryConfiguration.set(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME_DEPRECATED.getVar(), serverName);
        HMSFollower hmsFollower = new HMSFollower(sentryConfiguration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, null);
        String authServerName = hmsFollower.getAuthServerName();
        Assert.assertEquals((boolean)true, (boolean)authServerName.equals(serverName));
    }

    @Test
    public void testCreateDatabase() throws Exception {
        String dbName = "db1";
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), this.messageFactory.buildCreateDatabaseMessage(new Database(dbName, null, "hdfs:///db1", null)).toString());
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        hmsFollower.processNotifications(events);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testDropDatabase() throws Exception {
        String dbName = "db1";
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.DROP_DATABASE.toString(), this.messageFactory.buildDropDatabaseMessage(new Database(dbName, null, "hdfs:///db1", null)).toString());
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        hmsFollower.processNotifications(events);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testCreateTable() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), Collections.emptyIterator()).toString());
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        hmsFollower.processNotifications(events);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        authorizable.setTable(tableName);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testDropTable() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.DROP_TABLE.toString(), this.messageFactory.buildDropTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        hmsFollower.processNotifications(events);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb("db1");
        authorizable.setTable(tableName);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).dropPrivilege(authorizable, NotificationProcessor.getPermUpdatableOnDrop((TSentryAuthorizable)authorizable));
    }

    @Test
    public void testRenameTable() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        String newDbName = "db1";
        String newTableName = "table2";
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.ALTER_TABLE.toString(), this.messageFactory.buildAlterTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), new Table(newTableName, newDbName, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        notificationEvent.setDbName(newDbName);
        notificationEvent.setTableName(newTableName);
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        hmsFollower.processNotifications(events);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb(dbName);
        authorizable.setTable(tableName);
        TSentryAuthorizable newAuthorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        newAuthorizable.setDb(newDbName);
        newAuthorizable.setTable(newTableName);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).renamePrivilege(authorizable, newAuthorizable, NotificationProcessor.getPermUpdatableOnRename((TSentryAuthorizable)authorizable, (TSentryAuthorizable)newAuthorizable));
    }

    @Ignore
    @Test
    public void testAlterPartitionWithInvalidEvent() throws Exception {
        String dbName = "db1";
        String tableName1 = "table1";
        String tableName2 = "table2";
        long inputEventId = 1L;
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        ((SentryStore)Mockito.doNothing().when((Object)this.sentryStore)).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        ((SentryStore)Mockito.doNothing().when((Object)this.sentryStore)).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        Configuration configuration = new Configuration();
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs://db1.db/table1");
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName1, dbName, null, 0, 0, 0, sd, partCols, null, null, null, null);
        NotificationEvent notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(table, Collections.emptyIterator()).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        events.add(notificationEvent);
        ++inputEventId;
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        events.clear();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        StorageDescriptor invalidSd = new StorageDescriptor();
        invalidSd.setLocation(null);
        Partition partition = new Partition(Collections.singletonList("today"), dbName, tableName1, 0, 0, sd, null);
        partitions.add(partition);
        notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.ADD_PARTITION.toString(), this.messageFactory.buildAddPartitionMessage(table, partitions.iterator(), Collections.emptyIterator()).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        events.add(notificationEvent);
        ++inputEventId;
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        events.clear();
        notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.ALTER_PARTITION.toString(), this.messageFactory.buildAlterPartitionMessage(table, partition, partition).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        events.add(notificationEvent);
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistLastProcessedNotificationID(Long.valueOf(++inputEventId - 1L));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        events.clear();
        sd = new StorageDescriptor();
        sd.setLocation("hdfs://user/hive/warehouse/db1.db/table1");
        Partition updatedPartition = new Partition(partition);
        updatedPartition.setSd(sd);
        notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.ALTER_PARTITION.toString(), this.messageFactory.buildAlterPartitionMessage(table, partition, updatedPartition).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        events.add(notificationEvent);
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).updateAuthzPathsMapping(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(++inputEventId - 1L));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        events.clear();
        sd = new StorageDescriptor();
        sd.setLocation("hdfs://db1.db/table2");
        partCols = new ArrayList();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table1 = new Table(tableName2, dbName, null, 0, 0, 0, sd, partCols, null, null, null, null);
        notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(table1, Collections.emptyIterator()).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName2);
        events.add(notificationEvent);
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testAlterTableWithInvalidEvent() throws Exception {
        String dbName = "db1";
        String tableName1 = "table1";
        String tableName2 = "table2";
        long inputEventId = 1L;
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        ((SentryStore)Mockito.doNothing().when((Object)this.sentryStore)).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        ((SentryStore)Mockito.doNothing().when((Object)this.sentryStore)).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        Configuration configuration = new Configuration();
        configuration.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        configuration.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs://db1.db/table1");
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName1, dbName, null, 0, 0, 0, sd, partCols, null, null, null, null);
        NotificationEvent notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(table, Collections.emptyIterator()).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        events.add(notificationEvent);
        ++inputEventId;
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        events.clear();
        notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.ALTER_TABLE.toString(), this.messageFactory.buildAlterTableMessage(new Table(tableName1, dbName, null, 0, 0, 0, sd, null, null, null, null, null), new Table(tableName1, dbName, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName1);
        events = new ArrayList();
        events.add(notificationEvent);
        ++inputEventId;
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).renameAuthzObj(Mockito.anyString(), Mockito.anyString(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).deleteAuthzPathsMapping(Mockito.anyString(), (Iterable)Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        Mockito.reset((Object[])new SentryStore[]{this.sentryStore});
        events.clear();
        sd = new StorageDescriptor();
        sd.setLocation("hdfs://db1.db/table2");
        partCols = new ArrayList();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table1 = new Table(tableName2, dbName, null, 0, 0, 0, sd, partCols, null, null, null, null);
        notificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(table1, Collections.emptyIterator()).toString());
        notificationEvent.setDbName(dbName);
        notificationEvent.setTableName(tableName2);
        events.add(notificationEvent);
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testCreateTableAfterInvalidEvent() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        long inputEventId = 1L;
        ((SentryStore)Mockito.doNothing().when((Object)this.sentryStore)).persistLastProcessedNotificationID(Long.valueOf(Mockito.anyLong()));
        ((SentryStore)Mockito.doNothing().when((Object)this.sentryStore)).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
        StorageDescriptor invalidSd = new StorageDescriptor();
        invalidSd.setLocation(null);
        NotificationEvent invalidNotificationEvent = new NotificationEvent(inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(new Table(tableName, dbName, null, 0, 0, 0, invalidSd, null, null, null, null, null), Collections.emptyIterator()).toString());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs://db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(++inputEventId, 0, EventMessage.EventType.CREATE_TABLE.toString(), this.messageFactory.buildCreateTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), Collections.emptyIterator()).toString());
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(invalidNotificationEvent);
        events.add(notificationEvent);
        Configuration configuration = new Configuration();
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        hmsFollower.processNotifications(events);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).persistLastProcessedNotificationID(Long.valueOf(inputEventId - 1L));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).addAuthzPathsMapping(Mockito.anyString(), Mockito.anyCollection(), (UniquePathsUpdate)Mockito.any(UniquePathsUpdate.class));
    }

    @Test
    public void testNoHdfsNoPersistAFullSnapshot() throws Exception {
        long SENTRY_PROCESSED_EVENT_ID = 0L;
        long HMS_PROCESSED_EVENT_ID = 1L;
        HashMap<String, HashSet> snapshotObjects = new HashMap<String, HashSet>();
        snapshotObjects.put("db", Sets.newHashSet((Object[])new String[]{"/db"}));
        snapshotObjects.put("db.table", Sets.newHashSet((Object[])new String[]{"/db/table"}));
        PathsImage fullSnapshot = new PathsImage(snapshotObjects, 1L, 1L);
        Mockito.when((Object)hmsClientMock.getCurrentNotificationEventId()).thenReturn((Object)new CurrentNotificationEventId(fullSnapshot.getId()));
        SentryHMSClient sentryHmsClient = (SentryHMSClient)Mockito.mock(SentryHMSClient.class);
        Mockito.when((Object)sentryHmsClient.getFullSnapshot()).thenReturn((Object)fullSnapshot);
        Configuration configuration = new Configuration();
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, hmsConnectionMock, hiveInstance);
        hmsFollower.setSentryHmsClient(sentryHmsClient);
        Mockito.when((Object)this.sentryStore.getLastProcessedNotificationID()).thenReturn((Object)0L);
        Mockito.when((Object)this.sentryStore.isAuthzPathsMappingEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.sentryStore.isHmsNotificationEmpty()).thenReturn((Object)true);
        hmsFollower.run();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).persistFullPathsImage(fullSnapshot.getPathImage(), fullSnapshot.getId());
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).setLastProcessedNotificationID(Long.valueOf(fullSnapshot.getId()));
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)1))).isHmsNotificationEmpty();
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).isAuthzPathsMappingEmpty();
    }

    @Test
    public void testNoHdfsSyncAlterTableNotPersisted() throws Exception {
        String dbName = "db1";
        String tableName = "table1";
        String newDbName = "db1";
        String newTableName = "table2";
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.ALTER_TABLE.toString(), this.messageFactory.buildAlterTableMessage(new Table(tableName, dbName, null, 0, 0, 0, sd, null, null, null, null, null), new Table(newTableName, newDbName, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        notificationEvent.setDbName(newDbName);
        notificationEvent.setTableName(newTableName);
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        Configuration configuration = new Configuration();
        HMSFollower hmsFollower = new HMSFollower(configuration, this.sentryStore, null, (HiveConnectionFactory)hiveConnectionFactory, hiveInstance);
        hmsFollower.processNotifications(events);
        TSentryAuthorizable authorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        authorizable.setDb(dbName);
        authorizable.setTable(tableName);
        TSentryAuthorizable newAuthorizable = new TSentryAuthorizable(hiveInstance);
        authorizable.setServer(hiveInstance);
        newAuthorizable.setDb(newDbName);
        newAuthorizable.setTable(newTableName);
        ((SentryStore)Mockito.verify((Object)this.sentryStore, (VerificationMode)Mockito.times((int)0))).renamePrivilege(authorizable, newAuthorizable, NotificationProcessor.getPermUpdatableOnRename((TSentryAuthorizable)authorizable, (TSentryAuthorizable)newAuthorizable));
    }

    static {
        hmsConnectionMock = (HiveConnectionFactory)Mockito.mock(HiveConnectionFactory.class);
        hmsClientMock = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
    }
}

