/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAddPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAlterPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAlterTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONCreateDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONCreateTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageDeserializer;
import org.apache.sentry.service.thrift.FullUpdateModifier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFullUpdateModifier {
    private static final String SERVER = "s";
    private static final String PRINCIPAL = "p";
    private static final String DB = "Db1";
    private static final String TABLE = "Tab1";
    private static final String AUTH = "Db1".toLowerCase() + "." + "Tab1".toLowerCase();
    private static final String PATH = "foo/bar";
    private static final String LOCATION = TestFullUpdateModifier.uri("foo/bar");
    private static final Table TABLE_OBJ = new Table("Tab1", "Db1", "", 0, 0, 0, TestFullUpdateModifier.buildStorageDescriptor(LOCATION), null, null, "", "", "");

    private static final String uri(String path) {
        return "hdfs:///" + path;
    }

    private static StorageDescriptor buildStorageDescriptor(String location) {
        return new StorageDescriptor(null, location, "", "", false, 0, null, null, null, null);
    }

    private static Table buildTable(String dbName, String tableName, String location) {
        return new Table(tableName, dbName, "", 0, 0, 0, TestFullUpdateModifier.buildStorageDescriptor(location), null, null, "", "", "");
    }

    @Test
    public void testCreateDatabase() throws Exception {
        HashMap update = new HashMap();
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONCreateDatabaseMessage message = new SentryJSONCreateDatabaseMessage(SERVER, PRINCIPAL, DB, Long.valueOf(0L), LOCATION);
        Mockito.when((Object)deserializer.getCreateDatabaseMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashMap<String, Set<String>> expected = new HashMap<String, Set<String>>();
        expected.put(DB.toLowerCase(), Collections.singleton(PATH));
        Assert.assertEquals(expected, update);
    }

    @Test
    public void testDropDatabase() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(DB.toLowerCase(), Collections.singleton(PATH));
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.DROP_DATABASE.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONDropDatabaseMessage message = new SentryJSONDropDatabaseMessage(SERVER, PRINCIPAL, DB, Long.valueOf(0L), LOCATION);
        Mockito.when((Object)deserializer.getDropDatabaseMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        Assert.assertTrue((boolean)update.isEmpty());
    }

    @Test
    public void testDropDatabaseWrongLocation() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(DB.toLowerCase(), Collections.singleton(PATH));
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.DROP_DATABASE.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONDropDatabaseMessage message = new SentryJSONDropDatabaseMessage(SERVER, PRINCIPAL, DB, Long.valueOf(0L), "hdfs:///bad/location");
        Mockito.when((Object)deserializer.getDropDatabaseMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashMap<String, Set<String>> expected = new HashMap<String, Set<String>>();
        expected.put(DB.toLowerCase(), Collections.singleton(PATH));
        Assert.assertEquals(expected, update);
    }

    @Test
    public void testDropDatabaseWithTables() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(DB.toLowerCase(), Collections.singleton(PATH));
        update.put(AUTH, Collections.singleton(PATH));
        update.put("unrelated", Collections.singleton(PATH));
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.DROP_DATABASE.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONDropDatabaseMessage message = new SentryJSONDropDatabaseMessage(SERVER, PRINCIPAL, DB, Long.valueOf(0L), LOCATION);
        Mockito.when((Object)deserializer.getDropDatabaseMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashMap<String, Set<String>> expected = new HashMap<String, Set<String>>();
        expected.put("unrelated", Collections.singleton(PATH));
        Assert.assertEquals(expected, update);
    }

    @Test
    public void testCreateTable() throws Exception {
        HashMap update = new HashMap();
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_TABLE.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONCreateTableMessage message = new SentryJSONCreateTableMessage(SERVER, PRINCIPAL, TABLE_OBJ, Collections.emptyIterator(), Long.valueOf(0L));
        Mockito.when((Object)deserializer.getCreateTableMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashMap<String, Set<String>> expected = new HashMap<String, Set<String>>();
        expected.put(AUTH, Collections.singleton(PATH));
        Assert.assertEquals(expected, update);
    }

    @Test
    public void testDropTable() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(AUTH, Collections.singleton(PATH));
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.DROP_TABLE.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONDropTableMessage message = new SentryJSONDropTableMessage(SERVER, PRINCIPAL, DB, TABLE, Long.valueOf(0L), LOCATION);
        Mockito.when((Object)deserializer.getDropTableMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        Assert.assertTrue((boolean)update.isEmpty());
    }

    @Test
    public void testDropTableWrongLocation() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(AUTH, Collections.singleton(PATH));
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.DROP_TABLE.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONDropTableMessage message = new SentryJSONDropTableMessage(SERVER, PRINCIPAL, DB, TABLE, Long.valueOf(0L), "hdfs:///bad/location");
        Mockito.when((Object)deserializer.getDropTableMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        Assert.assertEquals(Collections.singleton(PATH), update.get(AUTH));
        Assert.assertEquals((long)1L, (long)update.size());
    }

    @Test
    public void testAddPartition() throws Exception {
        HashMap update = new HashMap();
        HashSet<String> locations = new HashSet<String>();
        locations.add(PATH);
        update.put(AUTH, locations);
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.ADD_PARTITION.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        String partPath = "hello/world";
        String partLocation = TestFullUpdateModifier.uri(partPath);
        SentryJSONAddPartitionMessage message = new SentryJSONAddPartitionMessage(SERVER, PRINCIPAL, TABLE_OBJ, Collections.emptyIterator(), Collections.emptyIterator(), Long.valueOf(0L), Collections.singletonList(partLocation));
        Mockito.when((Object)deserializer.getAddPartitionMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashSet<String> expected = new HashSet<String>(2);
        expected.add(PATH);
        expected.add(partPath);
        Assert.assertEquals(expected, update.get(AUTH));
    }

    @Test
    public void testDropPartitions() throws Exception {
        String partPath = "hello/world";
        String partLocation = TestFullUpdateModifier.uri(partPath);
        HashMap update = new HashMap();
        HashSet<String> locations = new HashSet<String>();
        locations.add(PATH);
        locations.add(partPath);
        update.put(AUTH, locations);
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.DROP_PARTITION.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONDropPartitionMessage message = new SentryJSONDropPartitionMessage(SERVER, PRINCIPAL, TABLE_OBJ, Collections.emptyList(), 0L, Collections.singletonList(partLocation));
        Mockito.when((Object)deserializer.getDropPartitionMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        Assert.assertEquals(Collections.singleton(PATH), update.get(AUTH));
    }

    @Test
    public void testAlterPartition() throws Exception {
        String partPath = "hello/world";
        String partLocation = TestFullUpdateModifier.uri(partPath);
        String newPath = "better/world";
        String newLocation = TestFullUpdateModifier.uri(newPath);
        HashMap update = new HashMap();
        HashSet<String> locations = new HashSet<String>();
        locations.add(PATH);
        locations.add(partPath);
        update.put(AUTH, locations);
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.ALTER_PARTITION.toString(), "");
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        Partition partitionObjBefore = new Partition(null, DB, TABLE, 0, 0, TestFullUpdateModifier.buildStorageDescriptor(partLocation), null);
        Partition partitionObjAfter = new Partition(null, DB, TABLE, 0, 0, TestFullUpdateModifier.buildStorageDescriptor(newLocation), null);
        SentryJSONAlterPartitionMessage message = new SentryJSONAlterPartitionMessage(SERVER, PRINCIPAL, TABLE_OBJ, partitionObjBefore, partitionObjAfter, Long.valueOf(0L));
        Mockito.when((Object)deserializer.getAlterPartitionMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashSet<String> expected = new HashSet<String>(2);
        expected.add(PATH);
        expected.add(newPath);
        Assert.assertEquals(expected, update.get(AUTH));
    }

    @Test
    public void testAlterTableChangeDbNameNoTables() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(DB.toLowerCase(), Collections.singleton(PATH));
        String newDbName = "Db2";
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.ALTER_TABLE.toString(), "");
        event.setDbName(newDbName);
        event.setTableName(TABLE);
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONAlterTableMessage message = new SentryJSONAlterTableMessage(SERVER, PRINCIPAL, TABLE_OBJ, TABLE_OBJ, Long.valueOf(0L));
        Mockito.when((Object)deserializer.getAlterTableMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        Assert.assertEquals(Collections.singleton(PATH), update.get(newDbName.toLowerCase()));
        Assert.assertFalse((boolean)update.containsKey(DB.toLowerCase()));
    }

    @Test
    public void testAlterTableChangeDbNameWithTables() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(DB.toLowerCase(), Collections.singleton(PATH));
        HashSet<String> locations = new HashSet<String>(1);
        locations.add(PATH);
        update.put(AUTH, locations);
        String newDbName = "Db2";
        String newAuth = newDbName.toLowerCase() + "." + TABLE.toLowerCase();
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.ALTER_TABLE.toString(), "");
        event.setDbName(newDbName);
        event.setTableName(TABLE);
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONAlterTableMessage message = new SentryJSONAlterTableMessage(SERVER, PRINCIPAL, TABLE_OBJ, TABLE_OBJ, Long.valueOf(0L));
        Mockito.when((Object)deserializer.getAlterTableMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashMap<String, Set<String>> expected = new HashMap<String, Set<String>>(2);
        expected.put(newDbName.toLowerCase(), Collections.singleton(PATH));
        expected.put(newAuth, Collections.singleton(PATH));
        Assert.assertEquals(expected, update);
    }

    @Test
    public void testAlterTableChangeTableName() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(DB.toLowerCase(), Collections.singleton(PATH));
        HashSet<String> locations = new HashSet<String>(1);
        locations.add(PATH);
        update.put(AUTH, locations);
        String newTableName = "Table2";
        String newAuth = DB.toLowerCase() + "." + newTableName.toLowerCase();
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.ALTER_TABLE.toString(), "");
        event.setDbName(DB);
        event.setTableName(newTableName);
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        SentryJSONAlterTableMessage message = new SentryJSONAlterTableMessage(SERVER, PRINCIPAL, TABLE_OBJ, TABLE_OBJ, Long.valueOf(0L));
        Mockito.when((Object)deserializer.getAlterTableMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashMap<String, Set<String>> expected = new HashMap<String, Set<String>>(2);
        expected.put(DB.toLowerCase(), Collections.singleton(PATH));
        expected.put(newAuth, Collections.singleton(PATH));
        Assert.assertEquals(expected, update);
    }

    @Test
    public void testAlterTableChangeLocation() throws Exception {
        HashMap<String, Set<String>> update = new HashMap<String, Set<String>>();
        update.put(DB.toLowerCase(), Collections.singleton(PATH));
        HashSet<String> locations = new HashSet<String>(1);
        locations.add(PATH);
        update.put(AUTH, locations);
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.ALTER_TABLE.toString(), "");
        event.setDbName(DB);
        event.setTableName(TABLE);
        String newPath = "hello/world";
        String newLocation = TestFullUpdateModifier.uri(newPath);
        MessageDeserializer deserializer = (MessageDeserializer)Mockito.mock(SentryJSONMessageDeserializer.class);
        Table tableWithNewLocation = TestFullUpdateModifier.buildTable(DB, TABLE, newLocation);
        SentryJSONAlterTableMessage message = new SentryJSONAlterTableMessage(SERVER, PRINCIPAL, TABLE_OBJ, tableWithNewLocation, Long.valueOf(0L));
        Mockito.when((Object)deserializer.getAlterTableMessage("")).thenReturn((Object)message);
        FullUpdateModifier.applyEvent(update, (NotificationEvent)event, (MessageDeserializer)deserializer);
        HashMap<String, Set<String>> expected = new HashMap<String, Set<String>>(2);
        expected.put(DB.toLowerCase(), Collections.singleton(PATH));
        expected.put(AUTH.toLowerCase(), Collections.singleton(newPath));
        Assert.assertEquals(expected, update);
    }

    @Test
    public void testRenamePrefixKeys() throws Exception {
        String oldKey = "foo.";
        String newKey = "baz.";
        String postfix = "bar";
        HashMap update = new HashMap();
        update.put(oldKey + postfix, Collections.emptySet());
        FullUpdateModifier.renamePrefixKeys(update, (String)oldKey, (String)newKey);
        Assert.assertEquals((long)1L, (long)update.size());
        Assert.assertTrue((boolean)update.containsKey(newKey + postfix));
    }

    @Test
    public void testRenameKeysWithConflicts() throws Exception {
        HashMap update = new HashMap();
        update.put("foo.bar", Collections.emptySet());
        update.put("baz.bar", Collections.emptySet());
        HashMap expected = new HashMap(update);
        FullUpdateModifier.renamePrefixKeys(update, (String)"foo.", (String)"baz.");
        Assert.assertEquals(update, expected);
    }
}

