/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.sentry.service.thrift.FullUpdateInitializer;
import org.apache.sentry.service.thrift.HMSClient;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFullUpdateInitializer {
    private static Configuration conf = new Configuration();

    private static Database makeDb(String name) {
        Database db = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)db.getName()).thenReturn((Object)name);
        Mockito.when((Object)db.getLocationUri()).thenReturn((Object)("hdfs:///" + name));
        return db;
    }

    private static Table makeTable(String dbName, String tableName) {
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)table.getDbName()).thenReturn((Object)dbName);
        Mockito.when((Object)table.getTableName()).thenReturn((Object)tableName);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)sd.getLocation()).thenReturn((Object)String.format("hdfs:///%s/%s", dbName, tableName));
        Mockito.when((Object)table.getSd()).thenReturn((Object)sd);
        return table;
    }

    private static Partition makePartition(String dbName, String tableName, String partName) {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)sd.getLocation()).thenReturn((Object)String.format("hdfs:///%s/%s/%s", dbName, tableName, partName));
        Mockito.when((Object)partition.getSd()).thenReturn((Object)sd);
        return partition;
    }

    @Test
    public void testSimple() throws Exception {
        Map update;
        HiveTable tab21 = new HiveTable("tab21");
        HiveTable tab31 = new HiveTable("tab31").add("part311").add("part312");
        HiveDb db3 = new HiveDb("db3", Lists.newArrayList((Object[])new HiveTable[]{tab31}));
        HiveDb db2 = new HiveDb("db2", Lists.newArrayList((Object[])new HiveTable[]{tab21}));
        HiveDb db1 = new HiveDb("db1");
        HiveSnapshot snap = new HiveSnapshot().add(db1).add(db2).add(db3);
        MockClient c = new MockClient(snap);
        try (FullUpdateInitializer cacheInitializer = new FullUpdateInitializer((HiveConnectionFactory)new MockHMSClientFactory(c), conf);){
            update = cacheInitializer.getFullHMSSnapshot();
        }
        Assert.assertEquals((long)5L, (long)update.size());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db1"}), update.get("db1"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db2"}), update.get("db2"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db3"}), update.get("db3"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db2/tab21"}), update.get("db2.tab21"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db3/tab31", "db3/tab31/part311", "db3/tab31/part312"}), update.get("db3.tab31"));
    }

    @Test
    public void testInvalidPaths() throws Exception {
        Map update;
        Database db1 = TestFullUpdateInitializer.makeDb("db1");
        Table tab1 = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)tab1.getDbName()).thenReturn((Object)"db2");
        Mockito.when((Object)tab1.getTableName()).thenReturn((Object)"tab1");
        HiveMetaStoreClient client = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        Mockito.when((Object)client.getAllDatabases()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"db1"}));
        Mockito.when((Object)client.getDatabase("db1")).thenReturn((Object)db1);
        Table tab12 = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)tab12.getDbName()).thenReturn((Object)"db1");
        Mockito.when((Object)tab12.getTableName()).thenReturn((Object)"tab21");
        StorageDescriptor sd21 = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)sd21.getLocation()).thenReturn((Object)"hdfs:///db1/tab21");
        Mockito.when((Object)tab12.getSd()).thenReturn((Object)sd21);
        Mockito.when((Object)client.getTableObjectsByName("db1", (List)Lists.newArrayList((Object[])new String[]{"tab1"}))).thenReturn((Object)Lists.newArrayList((Object[])new Table[]{tab1}));
        Mockito.when((Object)client.getTableObjectsByName("db1", (List)Lists.newArrayList((Object[])new String[]{"tab12"}))).thenReturn((Object)Lists.newArrayList((Object[])new Table[]{tab12}));
        Mockito.when((Object)client.getAllTables("db1")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"tab1", "tab12"}));
        try (FullUpdateInitializer cacheInitializer = new FullUpdateInitializer((HiveConnectionFactory)new MockHMSClientFactory(client), conf);){
            update = cacheInitializer.getFullHMSSnapshot();
        }
        Assert.assertEquals((long)2L, (long)update.size());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db1"}), update.get("db1"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"db1/tab21"}), update.get("db1.tab21"));
    }

    @Test
    public void testBig() throws Exception {
        Map update;
        Object table;
        int ndbs = 3;
        int ntables = 51;
        int nparts = 131;
        HiveSnapshot snap = new HiveSnapshot();
        for (int i = 0; i < ndbs; ++i) {
            HiveDb db = new HiveDb("db" + i);
            for (int j = 0; j < ntables; ++j) {
                table = new HiveTable("table" + i + j);
                for (int k = 0; k < nparts; ++k) {
                    ((HiveTable)table).add("part" + i + j + k);
                }
                db.add((HiveTable)table);
            }
            snap.add(db);
        }
        MockClient c = new MockClient(snap);
        FullUpdateInitializer cacheInitializer = new FullUpdateInitializer((HiveConnectionFactory)new MockHMSClientFactory(c), conf);
        table = null;
        try {
            update = cacheInitializer.getFullHMSSnapshot();
        }
        catch (Throwable k) {
            table = k;
            throw k;
        }
        finally {
            if (cacheInitializer != null) {
                if (table != null) {
                    try {
                        cacheInitializer.close();
                    }
                    catch (Throwable k) {
                        ((Throwable)table).addSuppressed(k);
                    }
                } else {
                    cacheInitializer.close();
                }
            }
        }
        Assert.assertEquals((long)(ntables * ndbs + ndbs), (long)update.size());
        for (int i = 0; i < ndbs; ++i) {
            String dbName = "db" + i;
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{dbName}), update.get(dbName));
            for (int j = 0; j < ntables; ++j) {
                String tableName = "table" + i + j;
                HashSet<String> values = new HashSet<String>();
                values.add(String.format("%s/%s", dbName, tableName));
                for (int k = 0; k < nparts; ++k) {
                    String partName = "part" + i + j + k;
                    values.add(String.format("%s/%s/%s", dbName, tableName, partName));
                }
                String authz = dbName + "." + tableName;
                Assert.assertEquals(values, update.get(authz));
            }
        }
    }

    static {
        conf.setInt("sentry.hdfs.sync.metastore.cache.max-partitions-per-rpc", 1);
        conf.setInt("sentry.hdfs.sync.metastore.cache.max-tables-per-rpc", 1);
        conf.setInt("sentry.hdfs.sync.metastore.cache.init.threads", 8);
    }

    private static class MockHMSClientFactory
    implements HiveConnectionFactory {
        private final HiveMetaStoreClient mClient;

        private MockHMSClientFactory(MockClient mClient) {
            this.mClient = mClient.client;
        }

        private MockHMSClientFactory(HiveMetaStoreClient client) {
            this.mClient = client;
        }

        public HMSClient connect() throws IOException, InterruptedException, MetaException {
            return new HMSClient(this.mClient);
        }

        public void close() throws Exception {
        }
    }

    private static class MockClient {
        HiveMetaStoreClient client = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);

        MockClient(HiveSnapshot snapshot) throws TException {
            ArrayList<String> dbNames = new ArrayList<String>(snapshot.databases.size());
            for (HiveDb mdb : snapshot.databases) {
                String dbName = mdb.name;
                dbNames.add(dbName);
                Database db = TestFullUpdateInitializer.makeDb(dbName);
                Mockito.when((Object)this.client.getDatabase(dbName)).thenReturn((Object)db);
                ArrayList<String> tableNames = new ArrayList<String>(mdb.tables.size());
                for (HiveTable table : mdb.tables) {
                    String tableName = table.name;
                    tableNames.add(tableName);
                    Table mockTable = TestFullUpdateInitializer.makeTable(dbName, tableName);
                    Mockito.when((Object)this.client.getTableObjectsByName(dbName, (List)Lists.newArrayList((Object[])new String[]{tableName}))).thenReturn((Object)Lists.newArrayList((Object[])new Table[]{mockTable}));
                    Mockito.when((Object)this.client.listPartitionNames(dbName, tableName, (short)-1)).thenReturn(table.partitions);
                    for (String partName : table.partitions) {
                        Partition p = TestFullUpdateInitializer.makePartition(dbName, tableName, partName);
                        Mockito.when((Object)this.client.getPartitionsByNames(dbName, tableName, (List)Lists.newArrayList((Object[])new String[]{partName}))).thenReturn((Object)Lists.newArrayList((Object[])new Partition[]{p}));
                    }
                }
                Mockito.when((Object)this.client.getAllTables(dbName)).thenReturn(tableNames);
            }
            Mockito.when((Object)this.client.getAllDatabases()).thenReturn(dbNames);
        }
    }

    private static class HiveSnapshot {
        List<HiveDb> databases = new ArrayList<HiveDb>();

        HiveSnapshot() {
        }

        HiveSnapshot(Collection<HiveDb> dblist) {
            if (dblist != null) {
                this.databases.addAll(dblist);
            }
        }

        HiveSnapshot add(HiveDb db) {
            this.databases.add(db);
            return this;
        }
    }

    private static class HiveDb {
        String name;
        Collection<HiveTable> tables;

        HiveDb(String name) {
            this.name = name;
            this.tables = new ArrayList<HiveTable>();
        }

        HiveDb(String name, Collection<HiveTable> tables) {
            this.name = name;
            this.tables = tables;
            if (this.tables == null) {
                this.tables = new ArrayList<HiveTable>();
            }
        }

        void add(HiveTable table) {
            this.tables.add(table);
        }
    }

    private static class HiveTable {
        String name;
        List<String> partitions;

        HiveTable(String name) {
            this.name = name;
            this.partitions = new ArrayList<String>();
        }

        HiveTable(String name, List<String> partitions) {
            this.name = name;
            this.partitions = partitions;
            if (this.partitions == null) {
                this.partitions = new ArrayList<String>();
            }
        }

        HiveTable add(String partition) {
            this.partitions.add(partition);
            return this;
        }
    }
}

