/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sentry.service.thrift.CounterWait;
import org.junit.Assert;
import org.junit.Test;

public class TestCounterWait {
    private final BlockingDeque<Long> outSyncQueue = new LinkedBlockingDeque<Long>();

    @Test
    public void testWaitFor() throws Exception {
        int i;
        int nthreads = 20;
        ExecutorService executor = Executors.newFixedThreadPool(nthreads);
        final CounterWait waiter = new CounterWait();
        Assert.assertEquals((long)0L, (long)waiter.waitFor(0L));
        for (i = 0; i < nthreads; ++i) {
            int finalI = i + 2;
            final int val = finalI / 2;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    long r = 0L;
                    try {
                        r = waiter.waitFor((long)val);
                    }
                    catch (InterruptedException | TimeoutException e) {
                        e.printStackTrace();
                    }
                    TestCounterWait.this.outSyncQueue.add(r);
                }
            });
        }
        while (waiter.waitersCount() < nthreads) {
            this.sleep(20L);
        }
        Assert.assertTrue((boolean)this.outSyncQueue.isEmpty());
        for (i = 0; i < nthreads / 2; ++i) {
            waiter.update((long)(i + 1));
            long r = this.outSyncQueue.takeFirst();
            Assert.assertEquals((long)r, (long)(i + 1));
            r = this.outSyncQueue.takeFirst();
            Assert.assertEquals((long)r, (long)(i + 1));
            Assert.assertTrue((boolean)this.outSyncQueue.isEmpty());
        }
        executor.shutdown();
    }

    @Test(expected=TimeoutException.class)
    public void testWaitForWithTimeout() throws Exception {
        CounterWait waiter = new CounterWait(1L, TimeUnit.MILLISECONDS);
        waiter.waitFor(1L);
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

