/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.io.IOException;
import org.apache.sentry.service.thrift.SentryService;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class SentryWebMetricParser {
    private JsonNode root;
    private final String sentryService = SentryService.class.getName();
    private ObjectMapper mapper = new ObjectMapper();

    public SentryWebMetricParser(String response) throws IOException {
        this.root = this.mapper.readTree(response);
    }

    public void refreshRoot(String response) throws IOException {
        this.root = this.mapper.readTree(response);
    }

    public JsonNode getRoot() {
        return this.root;
    }

    public JsonNode getGauges(JsonNode root) {
        JsonNode gauges = root.findPath("gauges");
        return gauges;
    }

    public JsonNode getCounters(JsonNode root) {
        JsonNode counters = root.findPath("counters");
        return counters;
    }

    public JsonNode getHistograms(JsonNode root) {
        JsonNode histograms = root.findPath("histograms");
        return histograms;
    }

    public JsonNode getMeters(JsonNode root) {
        JsonNode meters = root.findPath("meters");
        return meters;
    }

    public JsonNode getTimers(JsonNode root) {
        JsonNode timers = root.findPath("timers");
        return timers;
    }

    public JsonNode getValue(JsonNode node) {
        return node.findPath("value");
    }

    public boolean isHA() {
        JsonNode gauges = this.getGauges(this.root);
        JsonNode obj = this.getValue(gauges.findPath(this.sentryService + ".is_ha"));
        return obj.getValueAsBoolean();
    }

    public boolean isActive() {
        JsonNode gauges = this.getGauges(this.root);
        JsonNode obj = this.getValue(gauges.findPath(this.sentryService + ".is_active"));
        return obj.getBooleanValue();
    }
}

