/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.provider.db.service.thrift.SentryMiniKdcTestcase;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.provider.file.PolicyFile;
import org.apache.sentry.service.thrift.SentryService;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.apache.sentry.service.thrift.SentryServiceFactory;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SentryServiceIntegrationBase
extends SentryMiniKdcTestcase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryServiceIntegrationBase.class);
    protected static final String SERVER_HOST = NetUtils.createSocketAddr((String)"localhost:80").getAddress().getCanonicalHostName();
    protected static final String REALM = "EXAMPLE.COM";
    protected static final String SERVER_PRINCIPAL = "sentry/" + SERVER_HOST;
    protected static String SERVER_KERBEROS_NAME = "sentry/" + SERVER_HOST + "@" + "EXAMPLE.COM";
    protected static final String HTTP_PRINCIPAL = "HTTP/" + SERVER_HOST;
    protected static final String CLIENT_PRINCIPAL = "hive/" + SERVER_HOST;
    protected static final String CLIENT_KERBEROS_SHORT_NAME = "hive";
    protected static final String ADMIN_USER = "admin_user";
    protected static final String ADMIN_GROUP = "admin_group";
    protected static SentryService server;
    protected SentryPolicyServiceClient client;
    protected static MiniKdc kdc;
    protected static File kdcWorkDir;
    protected static File dbDir;
    protected static File serverKeytab;
    protected static File httpKeytab;
    protected static File clientKeytab;
    protected static UserGroupInformation clientUgi;
    protected static boolean kerberos;
    protected static final Configuration conf;
    protected PolicyFile policyFile;
    protected File policyFilePath;
    protected static Properties kdcConfOverlay;
    protected static boolean webServerEnabled;
    protected static int webServerPort;
    protected static boolean webSecurity;
    protected static boolean pooled;
    protected static boolean useSSL;
    protected static String allowedUsers;

    @BeforeClass
    public static void setup() throws Exception {
        kerberos = true;
        pooled = true;
        SentryServiceIntegrationBase.beforeSetup();
        SentryServiceIntegrationBase.setupConf();
        SentryServiceIntegrationBase.startSentryService();
        SentryServiceIntegrationBase.afterSetup();
    }

    private static void setupKdc() throws Exception {
        SentryServiceIntegrationBase.startMiniKdc(kdcConfOverlay);
    }

    public static void startSentryService() throws Exception {
        server.start();
        long start = System.currentTimeMillis();
        while (!server.isRunning()) {
            Thread.sleep(1000L);
            if (System.currentTimeMillis() - start <= 60000L) continue;
            throw new TimeoutException("Server did not start after 60 seconds");
        }
    }

    public void stopSentryService() throws Exception {
        server.stop();
        Thread.sleep(30000L);
    }

    public static void setupConf() throws Exception {
        if (kerberos) {
            SentryServiceIntegrationBase.setupKdc();
            kdc = SentryServiceIntegrationBase.getKdc();
            kdcWorkDir = SentryServiceIntegrationBase.getWorkDir();
            serverKeytab = new File(kdcWorkDir, "server.keytab");
            clientKeytab = new File(kdcWorkDir, "client.keytab");
            kdc.createPrincipal(serverKeytab, new String[]{SERVER_PRINCIPAL});
            kdc.createPrincipal(clientKeytab, new String[]{CLIENT_PRINCIPAL});
            conf.set("sentry.service.server.principal", SentryServiceIntegrationBase.getServerKerberosName());
            conf.set("sentry.service.server.keytab", serverKeytab.getPath());
            conf.set("sentry.service.allow.connect", CLIENT_KERBEROS_SHORT_NAME);
            conf.set("sentry.zookeeper.client.principal", SentryServiceIntegrationBase.getServerKerberosName());
            conf.set("sentry.zookeeper.client.keytab", serverKeytab.getPath());
            conf.set("sentry.service.security.use.ugi", "true");
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)CLIENT_PRINCIPAL, (String)clientKeytab.getPath());
            clientUgi = UserGroupInformation.getLoginUser();
        } else {
            LOGGER.info("Stopped KDC");
            conf.set("sentry.service.security.mode", "none");
        }
        if (webServerEnabled) {
            conf.set("sentry.service.web.enable", "true");
            conf.set("sentry.service.web.port", String.valueOf(webServerPort));
            conf.set("sentry.web.pubsub.servlet.enabled", "true");
            if (webSecurity) {
                httpKeytab = new File(kdcWorkDir, "http.keytab");
                kdc.createPrincipal(httpKeytab, new String[]{HTTP_PRINCIPAL});
                conf.set("sentry.service.web.authentication.type", "KERBEROS");
                conf.set("sentry.service.web.authentication.kerberos.principal", HTTP_PRINCIPAL);
                conf.set("sentry.service.web.authentication.kerberos.keytab", httpKeytab.getPath());
                conf.set("sentry.service.web.authentication.allow.connect.users", allowedUsers);
            } else {
                conf.set("sentry.service.web.authentication.type", "NONE");
            }
        } else {
            conf.set("sentry.service.web.enable", "false");
        }
        if (pooled) {
            conf.set("sentry.service.client.connection.pool.enabled", "true");
        }
        if (useSSL) {
            String keystorePath = Resources.getResource((String)"keystore.jks").getPath();
            conf.set("sentry.web.use.ssl", "true");
            conf.set("sentry.web.ssl.keystore.path", keystorePath);
            conf.set("sentry.web.ssl.keystore.password", "password");
            LOGGER.debug("{} is at {}", (Object)"sentry.web.ssl.keystore.path", (Object)keystorePath);
        }
        conf.set("sentry.verify.schema.version", "false");
        conf.set("sentry.service.admin.group", ADMIN_GROUP);
        conf.set("sentry.service.server.rpc-address", SERVER_HOST);
        conf.set("sentry.service.server.rpc-port", String.valueOf(0));
        dbDir = new File(Files.createTempDir(), "sentry_policy_db");
        conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dbDir.getPath() + ";create=true");
        conf.set("sentry.store.jdbc.password", "dummy");
        server = SentryServiceFactory.create((Configuration)conf);
        conf.set("sentry.service.client.server.rpc-addresses", server.getAddress().getHostName());
        conf.set("sentry.service.client.server.rpc-port", String.valueOf(server.getAddress().getPort()));
        conf.set("sentry.store.group.mapping", "org.apache.sentry.provider.file.LocalGroupMappingService");
    }

    @Before
    public void before() throws Exception {
        this.policyFilePath = new File(dbDir, "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", this.policyFilePath.getPath());
        this.policyFile = new PolicyFile();
        this.connectToSentryService();
    }

    @After
    public void after() {
        try {
            this.runTestAsSubject(new TestOperation(){

                @Override
                public void runTestAsSubject() throws Exception {
                    if (SentryServiceIntegrationBase.this.client != null) {
                        Set tRoles = SentryServiceIntegrationBase.this.client.listAllRoles(SentryServiceIntegrationBase.ADMIN_USER);
                        if (tRoles != null) {
                            for (TSentryRole tRole : tRoles) {
                                SentryServiceIntegrationBase.this.client.dropRole(SentryServiceIntegrationBase.ADMIN_USER, tRole.getRoleName());
                            }
                        }
                        SentryServiceIntegrationBase.this.client.close();
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.policyFilePath.delete();
        }
    }

    public void connectToSentryService() throws Exception {
        this.client = kerberos ? (SentryPolicyServiceClient)clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SentryPolicyServiceClient>(){

            @Override
            public SentryPolicyServiceClient run() throws Exception {
                return SentryServiceClientFactory.create((Configuration)conf);
            }
        }) : SentryServiceClientFactory.create((Configuration)conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        SentryServiceIntegrationBase.beforeTeardown();
        if (server != null) {
            server.stop();
        }
        if (dbDir != null) {
            FileUtils.deleteQuietly((File)dbDir);
        }
        SentryServiceIntegrationBase.stopMiniKdc();
        SentryServiceIntegrationBase.afterTeardown();
    }

    public static String getServerKerberosName() {
        return SERVER_KERBEROS_NAME;
    }

    public static void beforeSetup() throws Exception {
    }

    public static void afterSetup() throws Exception {
    }

    public static void beforeTeardown() throws Exception {
    }

    public static void afterTeardown() throws Exception {
    }

    protected static void assertOK(TSentryResponseStatus resp) {
        SentryServiceIntegrationBase.assertStatus(Status.OK, resp);
    }

    protected static void assertStatus(Status status, TSentryResponseStatus resp) {
        if (resp.getValue() != status.getCode()) {
            String message = "Expected: " + status + ", Response: " + Status.fromCode((int)resp.getValue()) + ", Code: " + resp.getValue() + ", Message: " + resp.getMessage();
            String stackTrace = Strings.nullToEmpty((String)resp.getStack()).trim();
            if (!stackTrace.isEmpty()) {
                message = message + ", StackTrace: " + stackTrace;
            }
            Assert.fail((String)message);
        }
    }

    protected void setLocalGroupMapping(String user, Set<String> groupSet) {
        for (String group : groupSet) {
            this.policyFile.addGroupsToUser(user, new String[]{group});
        }
    }

    protected void writePolicyFile() throws Exception {
        this.policyFile.write(this.policyFilePath);
    }

    protected void runTestAsSubject(TestOperation test) throws Exception {
        test.runTestAsSubject();
    }

    static {
        conf = new Configuration(false);
        kdcConfOverlay = new Properties();
        webServerEnabled = false;
        webServerPort = 29000;
        webSecurity = false;
        pooled = false;
        useSSL = false;
        allowedUsers = "hive,USER1";
    }

    protected static interface TestOperation {
        public void runTestAsSubject() throws Exception;
    }
}

