/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.tools;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.tools.SentryShellHive;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSentryShellHive
extends SentryServiceIntegrationBase {
    private File confDir;
    private File confPath;
    private static String TEST_ROLE_NAME_1 = "testRole1";
    private static String TEST_ROLE_NAME_2 = "testRole2";
    private String requestorName = "";

    @Before
    public void prepareForTest() throws Exception {
        this.confDir = Files.createTempDir();
        this.confPath = new File(this.confDir, "sentry-site.xml");
        if (this.confPath.createNewFile()) {
            FileOutputStream to = new FileOutputStream(this.confPath);
            conf.writeXml((OutputStream)to);
            to.close();
        }
        this.requestorName = clientUgi.getShortUserName();
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(this.requestorName, requestorUserGroupNames);
        this.setLocalGroupMapping("admin_user", requestorUserGroupNames);
        this.writePolicyFile();
    }

    @After
    public void clearTestData() throws Exception {
        FileUtils.deleteQuietly((File)this.confDir);
    }

    @Test
    public void testCreateDropRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--create_role", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-lr", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive sentryShell = new SentryShellHive();
                Set roleNames = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellHive.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"--list_role", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                roleNames = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellHive.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"-dr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--drop_role", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                Set roles = TestSentryShellHive.this.client.listAllRoles(TestSentryShellHive.this.requestorName);
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
            }
        });
    }

    @Test
    public void testAddDeleteRoleForGroup() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_2);
                String[] args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", "testGroup2,testGroup3", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--add_role_group", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-lr", "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive sentryShell = new SentryShellHive();
                Set roleNames = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellHive.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"--list_role", "-g", "testGroup2", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                roleNames = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellHive.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"--list_role", "-g", "testGroup3", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                roleNames = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellHive.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"--list_group", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                Set groups = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                Assert.assertEquals((long)3L, (long)groups.size());
                Assert.assertTrue((boolean)groups.contains("testGroup3 = testrole1"));
                Assert.assertTrue((boolean)groups.contains("testGroup2 = testrole1"));
                Assert.assertTrue((boolean)groups.contains("testGroup1 = testrole2, testrole1"));
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_1, "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_1, "-g", "testGroup2,testGroup3", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--delete_role_group", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                Set roles = TestSentryShellHive.this.client.listRolesByGroupName(TestSentryShellHive.this.requestorName, "testGroup1");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                roles = TestSentryShellHive.this.client.listRolesByGroupName(TestSentryShellHive.this.requestorName, "testGroup2");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                roles = TestSentryShellHive.this.client.listRolesByGroupName(TestSentryShellHive.this.requestorName, "testGroup3");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_2);
            }
        });
    }

    @Test
    public void testGrantRevokePrivilegeWithShortOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_2);
                String[] args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->action=select", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col2->action=insert->grantoption=true", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->uri=hdfs://path/testuri->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"-lp", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive sentryShell = new SentryShellHive();
                Set privilegeStrs = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)6L, (long)privilegeStrs.size());
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->action=*"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->action=select"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->table=tbl1->action=insert"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->table=tbl1->column=col1->action=insert"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->table=tbl1->column=col2->action=insert->grantoption=true"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->uri=hdfs://path/testuri->action=*"));
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                Set privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)5L, (long)privileges.size());
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col2->action=insert->grantoption=true", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)4L, (long)privileges.size());
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->uri=hdfs://path/testuri->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)3L, (long)privileges.size());
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)2L, (long)privileges.size());
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->action=select", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)1L, (long)privileges.size());
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)0L, (long)privileges.size());
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_2);
            }
        });
    }

    @Test
    public void testGrantRevokePrivilegeWithLongOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_2);
                String[] args = new String[]{"--grant_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--grant_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->action=select", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--grant_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--grant_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--grant_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col2->action=insert->grantoption=true", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--grant_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->uri=hdfs://path/testuri->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                args = new String[]{"--list_privilege", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive sentryShell = new SentryShellHive();
                Set privilegeStrs = TestSentryShellHive.this.getShellResultWithOSRedirect(sentryShell, args, true);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)6L, (long)privilegeStrs.size());
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->action=*"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->action=select"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->table=tbl1->action=insert"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->table=tbl1->column=col1->action=insert"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->db=db1->table=tbl1->column=col2->action=insert->grantoption=true"));
                Assert.assertTrue((boolean)privilegeStrs.contains("server=server1->uri=hdfs://path/testuri->action=*"));
                args = new String[]{"--revoke_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                Set privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)5L, (long)privileges.size());
                args = new String[]{"--revoke_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->column=col2->action=insert->grantoption=true", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)4L, (long)privileges.size());
                args = new String[]{"--revoke_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->uri=hdfs://path/testuri->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)3L, (long)privileges.size());
                args = new String[]{"--revoke_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->table=tbl1->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)2L, (long)privileges.size());
                args = new String[]{"--revoke_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->db=db1->action=select", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)1L, (long)privileges.size());
                args = new String[]{"--revoke_privilege_role", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive.main((String[])args);
                privileges = TestSentryShellHive.this.client.listAllPrivilegesByRoleName(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)0L, (long)privileges.size());
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_2);
            }
        });
    }

    @Test
    public void testNegativeCaseWithInvalidArgument() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                SentryShellHive sentryShell = new SentryShellHive();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for creating duplicate role");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-dr", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for dropping non-exist role");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for granting non-exist role to group");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for drop group from non-exist role");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "serverserver1->action=*", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for the error privilege format, invalid key value.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->table=tbl1->column=col2->action=insert", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for the error privilege format, invalid key value.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
            }
        });
    }

    @Test
    public void testNegativeCaseWithoutRequiredArgument() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String strOptionConf = "conf";
                TestSentryShellHive.this.client.createRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1};
                SentryShellHive sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: " + strOptionConf);
                args = new String[]{"-cr", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-dr", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-arg", "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Group name");
                args = new String[]{"-drg", "-g", "testGroup1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Group name");
                args = new String[]{"-gpr", "-p", "server=server1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Privilege string");
                args = new String[]{"-rpr", "-p", "server=server1", "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Privilege string");
                args = new String[]{"-conf", TestSentryShellHive.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellHive();
                TestSentryShellHive.this.validateMissingParameterMsgsContains(sentryShell, args, new String[]{"Missing required option: [", "-arg Add role to group", "-cr Create role", "-rpr Revoke privilege from role", "-drg Delete role from group", "-lr List role", "-lp List privilege", "-gpr Grant privilege to role", "-dr Drop role"});
                TestSentryShellHive.this.client.dropRole(TestSentryShellHive.this.requestorName, TEST_ROLE_NAME_1);
            }
        });
    }

    private Set<String> getShellResultWithOSRedirect(SentryShellHive sentryShell, String[] args, boolean exceptedExecuteResult) throws Exception {
        PrintStream oldOut = System.out;
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Assert.assertEquals((Object)exceptedExecuteResult, (Object)sentryShell.executeShell(args));
        HashSet resultSet = Sets.newHashSet((Object[])outContent.toString().split("\n"));
        System.setOut(oldOut);
        return resultSet;
    }

    private void validateRoleNames(Set<String> roleNames, String ... expectedRoleNames) {
        if (expectedRoleNames != null && expectedRoleNames.length > 0) {
            Assert.assertEquals((String)("Found: " + roleNames.size() + " roles, expected: " + expectedRoleNames.length), (long)expectedRoleNames.length, (long)roleNames.size());
            HashSet<String> lowerCaseRoles = new HashSet<String>();
            for (String role : roleNames) {
                lowerCaseRoles.add(role.toLowerCase());
            }
            for (String expectedRole : expectedRoleNames) {
                Assert.assertTrue((String)("Expected role: " + expectedRole), (boolean)lowerCaseRoles.contains(expectedRole.toLowerCase()));
            }
        }
    }

    private void validateMissingParameterMsg(SentryShellHive sentryShell, String[] args, String exceptedErrorMsg) throws Exception {
        Set<String> errorMsgs = this.getShellResultWithOSRedirect(sentryShell, args, false);
        Assert.assertTrue((boolean)errorMsgs.contains(exceptedErrorMsg));
    }

    private void validateMissingParameterMsgsContains(SentryShellHive sentryShell, String[] args, String ... expectedErrorMsgsContains) throws Exception {
        Set<String> errorMsgs = this.getShellResultWithOSRedirect(sentryShell, args, false);
        boolean foundAllMessages = false;
        for (String errorMessage : errorMsgs) {
            boolean missingExpected = false;
            for (String expectedContains : expectedErrorMsgsContains) {
                if (errorMessage.contains(expectedContains)) continue;
                missingExpected = true;
                break;
            }
            if (missingExpected) continue;
            foundAllMessages = true;
            break;
        }
        Assert.assertTrue((boolean)foundAllMessages);
    }
}

