/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.tools;

import com.google.common.io.Files;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.tools.SentrySchemaTool;
import org.junit.Before;
import org.junit.Test;

public class TestSentrySchemaTool {
    private Configuration sentryConf;
    private SentrySchemaTool schemaTool;
    private static final String OLDEST_INIT_VERSION = "1.4.0";

    @Before
    public void defaultSetup() throws Exception {
        this.sentryConf = new Configuration();
        File dbDir = new File(Files.createTempDir(), "sentry_policy_db");
        this.sentryConf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dbDir.getPath() + ";create=true");
        this.sentryConf.set("sentry.store.jdbc.password", "dummy");
        this.schemaTool = new SentrySchemaTool("./src/main/resources", this.sentryConf, "derby");
    }

    private void nonDefaultsetup() throws Exception {
        this.sentryConf = new Configuration();
        File dbDir = new File(Files.createTempDir(), "sentry_policy_db");
        this.sentryConf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dbDir.getPath() + ";create=true");
        this.sentryConf.set("sentry.store.jdbc.password", "dummy");
        this.schemaTool = new SentrySchemaTool("./src/main/resources", this.sentryConf, "derby");
    }

    @Test
    public void testInitNonDefault() throws Exception {
        this.nonDefaultsetup();
        this.schemaTool.doInit();
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testInit() throws Exception {
        this.schemaTool.doInit();
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testInitTo() throws Exception {
        this.schemaTool.doInit(SentryStoreSchemaInfo.getSentryVersion());
        this.schemaTool.verifySchemaVersion();
    }

    @Test(expected=SentryUserException.class)
    public void testDryRun() throws Exception {
        this.schemaTool.setDryRun(true);
        this.schemaTool.doInit();
        this.schemaTool.setDryRun(false);
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testUpgrade() throws Exception {
        this.schemaTool.doInit(OLDEST_INIT_VERSION);
        this.schemaTool.doUpgrade();
        this.schemaTool.verifySchemaVersion();
    }
}

