/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryWebServerWithoutSecurity
extends SentryServiceIntegrationBase {
    @BeforeClass
    public static void setup() throws Exception {
        webServerEnabled = true;
        webSecurity = false;
        SentryServiceIntegrationBase.setup();
    }

    @Override
    @Before
    public void before() throws Exception {
    }

    @Override
    @After
    public void after() {
    }

    @Test
    public void testPing() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/ping");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        String response = IOUtils.toString((InputStream)conn.getInputStream());
        Assert.assertEquals((Object)"pong\n", (Object)response);
    }

    @Test
    public void testConf() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/conf?" + "format" + "=badformat");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)400L, (long)conn.getResponseCode());
        URL url1 = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/conf?" + "format" + "=" + "json");
        conn = (HttpURLConnection)url1.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        URL url2 = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/conf?" + "format" + "=" + "xml");
        conn = (HttpURLConnection)url2.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        String xmlResponse = IOUtils.toString((InputStream)conn.getInputStream());
        URL url3 = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/conf");
        conn = (HttpURLConnection)url3.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        String defaultResponse = IOUtils.toString((InputStream)conn.getInputStream());
        Assert.assertEquals((Object)xmlResponse, (Object)defaultResponse);
    }

    @Test
    public void testTraceIsDisabled() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("TRACE");
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

