/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryWebServerWithSSL
extends SentryServiceIntegrationBase {
    @BeforeClass
    public static void setup() throws Exception {
        webServerEnabled = true;
        webSecurity = false;
        useSSL = true;
        SentryServiceIntegrationBase.setup();
    }

    @Test
    public void testPing() throws Exception {
        URL url = new URL("https://" + SERVER_HOST + ":" + webServerPort + "/ping");
        Properties systemProps = System.getProperties();
        systemProps.put("javax.net.ssl.trustStore", Resources.getResource((String)"cacerts.jks").getPath());
        System.setProperties(systemProps);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        String response = IOUtils.toString((InputStream)conn.getInputStream());
        Assert.assertEquals((Object)"pong\n", (Object)response);
    }

    @Test
    public void testTraceIsDisabled() throws Exception {
        URL url = new URL("https://" + SERVER_HOST + ":" + webServerPort);
        Properties systemProps = System.getProperties();
        systemProps.put("javax.net.ssl.trustStore", Resources.getResource((String)"cacerts.jks").getPath());
        System.setProperties(systemProps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("TRACE");
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

