/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.sentry.service.thrift.KerberosConfiguration;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSentryWebServerWithKerberos
extends SentryServiceIntegrationBase {
    private static Logger LOG = LoggerFactory.getLogger(TestSentryWebServerWithKerberos.class);

    @BeforeClass
    public static void setup() throws Exception {
        webServerEnabled = true;
        webSecurity = true;
        SentryServiceIntegrationBase.setup();
    }

    @Override
    @Before
    public void before() throws Exception {
    }

    @Override
    @After
    public void after() {
    }

    @Test
    public void testPing() throws Exception {
        clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/ping");
                HttpURLConnection conn = new AuthenticatedURL((Authenticator)new KerberosAuthenticator()).openConnection(url, new AuthenticatedURL.Token());
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                String response = IOUtils.toString((InputStream)conn.getInputStream());
                Assert.assertEquals((Object)"pong\n", (Object)response);
                return null;
            }
        });
    }

    @Test
    public void testPingWithoutSubject() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/ping");
        try {
            new AuthenticatedURL((Authenticator)new KerberosAuthenticator()).openConnection(url, new AuthenticatedURL.Token());
            Assert.fail((String)"Here should fail.");
        }
        catch (Exception e) {
            boolean isExpectError = e.getMessage().contains("No valid credentials provided");
            Assert.assertTrue((String)("Here should fail by 'No valid credentials provided', but the exception is:" + e), (boolean)isExpectError);
        }
    }

    @Test
    public void testPingUsingHttpURLConnection() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/ping");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
        String errorMessage = IOUtils.toString((InputStream)conn.getErrorStream());
        Assert.assertTrue((boolean)errorMessage.contains("Authentication required"));
    }

    @Test
    public void testPingWithUnauthorizedUser() throws Exception {
        String userPrinciple = "user/" + SERVER_HOST;
        String userKerberosName = userPrinciple + "@" + "EXAMPLE.COM";
        Subject userSubject = new Subject(false, Sets.newHashSet((Object[])new KerberosPrincipal[]{new KerberosPrincipal(userKerberosName)}), new HashSet(), new HashSet());
        File userKeytab = new File(kdcWorkDir, "user.keytab");
        kdc.createPrincipal(userKeytab, new String[]{userPrinciple});
        LoginContext userLoginContext = new LoginContext("", userSubject, null, KerberosConfiguration.createClientConfig((String)userKerberosName, (File)userKeytab));
        userLoginContext.login();
        Subject.doAs(userLoginContext.getSubject(), new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                block2: {
                    URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/ping");
                    try {
                        new AuthenticatedURL((Authenticator)new KerberosAuthenticator()).openConnection(url, new AuthenticatedURL.Token());
                        Assert.fail((String)"Here should fail.");
                    }
                    catch (AuthenticationException e) {
                        String expectedError = "status code: 403";
                        if (e.getMessage().contains(expectedError)) break block2;
                        LOG.error("UnexpectedError: " + e.getMessage(), (Throwable)e);
                        Assert.fail((String)("UnexpectedError: " + e.getMessage()));
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testPingWithCaseSensitiveUser() throws Exception {
        String userPrinciple = "user1/" + SERVER_HOST;
        String userKerberosName = userPrinciple + "@" + "EXAMPLE.COM";
        Subject userSubject = new Subject(false, Sets.newHashSet((Object[])new KerberosPrincipal[]{new KerberosPrincipal(userKerberosName)}), new HashSet(), new HashSet());
        File userKeytab = new File(kdcWorkDir, "user1.keytab");
        kdc.createPrincipal(userKeytab, new String[]{userPrinciple});
        LoginContext userLoginContext = new LoginContext("", userSubject, null, KerberosConfiguration.createClientConfig((String)userKerberosName, (File)userKeytab));
        userLoginContext.login();
        Subject.doAs(userLoginContext.getSubject(), new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                block2: {
                    URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/ping");
                    try {
                        new AuthenticatedURL((Authenticator)new KerberosAuthenticator()).openConnection(url, new AuthenticatedURL.Token());
                        Assert.fail((String)"Login with user1 should fail");
                    }
                    catch (AuthenticationException e) {
                        String expectedError = "status code: 403";
                        if (e.getMessage().contains(expectedError)) break block2;
                        LOG.error("UnexpectedError: " + e.getMessage(), (Throwable)e);
                        Assert.fail((String)("UnexpectedError: " + e.getMessage()));
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testTraceIsDisabled() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("TRACE");
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

