/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.apache.sentry.service.thrift.SentryServiceFactory;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Assert;
import org.junit.Test;

public class TestSentryServiceWithInvalidMsgSize
extends SentryServiceIntegrationBase {
    private final Set<String> REQUESTER_USER_GROUP_NAMES = Sets.newHashSet((Object[])new String[]{"admin_group"});
    private final String ROLE_NAME = "admin_r";

    @Test
    public void testClientWithSmallMaxMsgSize() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runTestAsSubject() throws Exception {
                SentryServiceClientFactory oldFactory = SentryServiceClientFactory.factoryReset(null);
                Configuration confWithSmallMaxMsgSize = new Configuration(conf);
                confWithSmallMaxMsgSize.setLong("sentry.policy.client.thrift.max.message.size", 20L);
                SentryPolicyServiceClient clientWithSmallMaxMsgSize = SentryServiceClientFactory.create((Configuration)confWithSmallMaxMsgSize);
                TestSentryServiceWithInvalidMsgSize.this.setLocalGroupMapping("admin_user", TestSentryServiceWithInvalidMsgSize.this.REQUESTER_USER_GROUP_NAMES);
                TestSentryServiceWithInvalidMsgSize.this.writePolicyFile();
                boolean exceptionThrown = false;
                try {
                    clientWithSmallMaxMsgSize.listAllRoles("admin_user");
                }
                catch (SentryUserException e) {
                    exceptionThrown = true;
                    Assert.assertTrue((boolean)e.getMessage().contains("Thrift exception occurred"));
                    Assert.assertTrue((boolean)e.getCause().getMessage().contains("Length exceeded max allowed"));
                }
                finally {
                    Assert.assertEquals((Object)true, (Object)exceptionThrown);
                    clientWithSmallMaxMsgSize.close();
                    SentryServiceClientFactory.factoryReset((SentryServiceClientFactory)oldFactory);
                }
                TestSentryServiceWithInvalidMsgSize.this.client.dropRoleIfExists("admin_user", "admin_r");
                TestSentryServiceWithInvalidMsgSize.this.client.listAllRoles("admin_user");
                TestSentryServiceWithInvalidMsgSize.this.client.createRole("admin_user", "admin_r");
                TestSentryServiceWithInvalidMsgSize.this.client.listAllRoles("admin_user");
            }
        });
    }

    @Test
    public void testServerWithSmallMaxMsgSize() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runTestAsSubject() throws Exception {
                Configuration confWithSmallMaxMsgSize = new Configuration(conf);
                confWithSmallMaxMsgSize.setLong("sentry.policy.server.thrift.max.message.size", 50L);
                TestSentryServiceWithInvalidMsgSize.this.stopSentryService();
                server = SentryServiceFactory.create((Configuration)confWithSmallMaxMsgSize);
                SentryServiceIntegrationBase.startSentryService();
                TestSentryServiceWithInvalidMsgSize.this.setLocalGroupMapping("admin_user", TestSentryServiceWithInvalidMsgSize.this.REQUESTER_USER_GROUP_NAMES);
                TestSentryServiceWithInvalidMsgSize.this.writePolicyFile();
                TestSentryServiceWithInvalidMsgSize.this.client.listAllRoles("admin_user");
                TestSentryServiceWithInvalidMsgSize.this.client.createRole("admin_user", "admin_r");
                boolean exceptionThrown = false;
                try {
                    TestSentryServiceWithInvalidMsgSize.this.client.grantServerPrivilege("admin_user", "admin_r", "server", Boolean.valueOf(false));
                }
                catch (SentryUserException e) {
                    exceptionThrown = true;
                    Assert.assertTrue((boolean)e.getCause().getMessage().contains("org.apache.thrift.transport.TTransportException"));
                }
                finally {
                    Assert.assertEquals((Object)true, (Object)exceptionThrown);
                }
                Set roles = TestSentryServiceWithInvalidMsgSize.this.client.listAllRoles("admin_user");
                Assert.assertTrue((roles.size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"admin_r", (Object)((TSentryRole)roles.iterator().next()).getRoleName());
            }
        });
    }
}

