/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.apache.sentry.service.thrift.SentryWebMetricParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryServiceMetrics
extends SentryServiceIntegrationBase {
    @BeforeClass
    public static void setup() throws Exception {
        kerberos = true;
        webServerEnabled = true;
        webSecurity = true;
        TestSentryServiceMetrics.setupConf();
        TestSentryServiceMetrics.startSentryService();
    }

    @Override
    @Before
    public void before() throws Exception {
    }

    @Test
    public void testSentryServiceGauges() throws Throwable {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)server.getIsActiveGauge().getValue());
    }

    @Test
    public void testMetricsWeb() throws Exception {
        clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/metrics");
                HttpURLConnection conn = new AuthenticatedURL((Authenticator)new KerberosAuthenticator()).openConnection(url, new AuthenticatedURL.Token());
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                String response = IOUtils.toString((InputStream)conn.getInputStream());
                SentryWebMetricParser mp = new SentryWebMetricParser(response);
                Assert.assertEquals((Object)Boolean.FALSE, (Object)mp.isHA());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)mp.isActive());
                return null;
            }
        });
    }

    @Override
    @After
    public void after() {
    }
}

