/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClientDefaultImpl;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Assert;
import org.junit.Test;

public class TestSentryServiceIntegration
extends SentryServiceIntegrationBase {
    @Test
    public void testCreateDropShowRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listAllRoles(requestorUserName);
                Assert.assertEquals((String)"Incorrect number of roles", (long)1L, (long)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                }
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeOnTableForRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db2", "table4", "ALL");
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db2", "table4", "ALL");
                Set listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertEquals((String)"Privilege not assigned to role1 !!", (long)4L, (long)listPrivilegesByRoleName.size());
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertEquals((String)"Privilege not assigned to role2 !!", (long)4L, (long)listPrivilegesByRoleName.size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db1", "table1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 3 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 4 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db1", "table1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 3 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 3 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db2", "table4", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db2", "table4", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testAddDeleteRolesForUser() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                String roleName1 = "r1";
                String roleName2 = "r2";
                String roleName3 = "r3";
                String user1 = "u1";
                String user2 = "u2";
                String user3 = "u3";
                String user4 = "u4";
                String group1 = "g1";
                String group2 = "g2";
                String group3 = "g3";
                HashMap userToGroups = Maps.newHashMap();
                userToGroups.put(user1, Sets.newHashSet((Object[])new String[]{group1}));
                userToGroups.put(user2, Sets.newHashSet((Object[])new String[]{group1}));
                userToGroups.put(user3, Sets.newHashSet((Object[])new String[]{group1, group2}));
                userToGroups.put(user4, Sets.newHashSet((Object[])new String[]{group2, group3}));
                TestSentryServiceIntegration.this.setLocalGroupMapping(user1, Sets.newHashSet((Object[])new String[]{group1}));
                TestSentryServiceIntegration.this.setLocalGroupMapping(user2, Sets.newHashSet((Object[])new String[]{group1}));
                TestSentryServiceIntegration.this.setLocalGroupMapping(user3, Sets.newHashSet((Object[])new String[]{group1, group2}));
                TestSentryServiceIntegration.this.setLocalGroupMapping(user4, Sets.newHashSet((Object[])new String[]{group2, group3}));
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName3);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName3);
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group1, roleName1);
                TestSentryServiceIntegration.this.client.grantRoleToUser(requestorUserName, user2, roleName2);
                TestSentryServiceIntegration.this.client.grantRoleToUser(requestorUserName, user3, roleName2);
                TestSentryServiceIntegration.this.client.grantRoleToUser(requestorUserName, user2, roleName3);
                TestSentryServiceIntegration.this.client.grantRoleToUsers(requestorUserName, roleName3, (Set)Sets.newHashSet((Object[])new String[]{user4}));
                Set roles = TestSentryServiceIntegration.this.client.listRolesByUserName(requestorUserName, user1);
                Assert.assertEquals((long)0L, (long)roles.size());
                roles = TestSentryServiceIntegration.this.client.listRolesByUserName(requestorUserName, user2);
                Assert.assertEquals((long)2L, (long)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((roleName2.equals(role.getRoleName()) || roleName3.equals(role.getRoleName()) ? 1 : 0) != 0);
                }
                roles = TestSentryServiceIntegration.this.client.listRolesByUserName(requestorUserName, user3);
                Assert.assertEquals((long)1L, (long)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((boolean)roleName2.equals(role.getRoleName()));
                }
                roles = TestSentryServiceIntegration.this.client.listRolesByUserName(requestorUserName, user4);
                Assert.assertEquals((long)1L, (long)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((boolean)roleName3.equals(role.getRoleName()));
                }
                roles = TestSentryServiceIntegration.this.client.listRolesByUserName(user3, user3);
                Assert.assertEquals((long)1L, (long)roles.size());
                try {
                    TestSentryServiceIntegration.this.client.listRolesByUserName(user3, user2);
                    Assert.fail((String)"SentryAccessDeniedException should be caught.");
                }
                catch (SentryAccessDeniedException sentryAccessDeniedException) {
                    // empty catch block
                }
                try {
                    TestSentryServiceIntegration.this.client.listRolesByUserName(user3, "");
                    Assert.fail((String)"SentryAccessDeniedException should be caught.");
                }
                catch (SentryAccessDeniedException sentryAccessDeniedException) {
                    // empty catch block
                }
                TestSentryServiceIntegration.this.client.revokeRoleFromUser(requestorUserName, user2, roleName3);
                TestSentryServiceIntegration.this.client.revokeRoleFromUsers(requestorUserName, roleName3, (Set)Sets.newHashSet((Object[])new String[]{user4}));
                roles = TestSentryServiceIntegration.this.client.listRolesByUserName(requestorUserName, user2);
                Assert.assertEquals((long)1L, (long)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((boolean)roleName2.equals(role.getRoleName()));
                }
                roles = TestSentryServiceIntegration.this.client.listRolesByUserName(requestorUserName, user4);
                Assert.assertEquals((long)0L, (long)roles.size());
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeForRoleWithUG() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                String roleName1 = "r1";
                String roleName2 = "r2";
                String roleName3 = "r3";
                String roleName4 = "r4";
                String user1_1 = "u1_1";
                String user1_2 = "u1_2";
                String user2_1 = "u2_1";
                String user2_2 = "u2_2";
                String group1 = "g1";
                String group2 = "g2";
                HashMap userToGroup = Maps.newHashMap();
                userToGroup.put(user1_1, group1);
                userToGroup.put(user1_2, group1);
                userToGroup.put(user2_1, group2);
                userToGroup.put(user2_2, user2_1);
                HashSet groupSet = Sets.newHashSet((Object[])new String[]{group1});
                TestSentryServiceIntegration.this.setLocalGroupMapping(user1_1, groupSet);
                TestSentryServiceIntegration.this.setLocalGroupMapping(user1_2, groupSet);
                groupSet = Sets.newHashSet((Object[])new String[]{group2});
                TestSentryServiceIntegration.this.setLocalGroupMapping(user2_1, groupSet);
                TestSentryServiceIntegration.this.setLocalGroupMapping(user2_2, groupSet);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName3);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName4);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName3);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName4);
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group1, roleName1);
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group2, roleName2);
                TestSentryServiceIntegration.this.client.grantRoleToUser(requestorUserName, user1_1, roleName3);
                TestSentryServiceIntegration.this.client.grantRoleToUsers(requestorUserName, roleName4, (Set)Sets.newHashSet((Object[])new String[]{user2_1}));
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table1_1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table1_2", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table2_1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table2_2", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName3, "server", "db1", "table3_1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName3, "server", "db1", "table3_2", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName4, "server", "db1", "table4_1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName4, "server", "db1", "table4_2", "ALL");
                Set listPrivilegesForProvider = TestSentryServiceIntegration.this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{group1}), (Set)Sets.newHashSet((Object[])new String[]{""}), ActiveRoleSet.ALL, (Authorizable[])null);
                Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=server->db=db1->table=table1_1->action=all", "server=server->db=db1->table=table1_2->action=all"}), (Object)listPrivilegesForProvider);
                listPrivilegesForProvider = TestSentryServiceIntegration.this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{(String)userToGroup.get(user1_2)}), (Set)Sets.newHashSet((Object[])new String[]{user1_2}), ActiveRoleSet.ALL, (Authorizable[])null);
                Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=server->db=db1->table=table1_1->action=all", "server=server->db=db1->table=table1_2->action=all"}), (Object)listPrivilegesForProvider);
                listPrivilegesForProvider = TestSentryServiceIntegration.this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{(String)userToGroup.get(user1_1)}), (Set)Sets.newHashSet((Object[])new String[]{user1_1}), ActiveRoleSet.ALL, (Authorizable[])null);
                Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=server->db=db1->table=table1_1->action=all", "server=server->db=db1->table=table1_2->action=all", "server=server->db=db1->table=table3_1->action=all", "server=server->db=db1->table=table3_2->action=all"}), (Object)listPrivilegesForProvider);
                listPrivilegesForProvider = TestSentryServiceIntegration.this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{group1}), (Set)Sets.newHashSet((Object[])new String[]{user1_1, user1_2}), ActiveRoleSet.ALL, (Authorizable[])null);
                Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=server->db=db1->table=table1_1->action=all", "server=server->db=db1->table=table1_2->action=all", "server=server->db=db1->table=table3_1->action=all", "server=server->db=db1->table=table3_2->action=all"}), (Object)listPrivilegesForProvider);
                listPrivilegesForProvider = TestSentryServiceIntegration.this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{group1, group2}), (Set)Sets.newHashSet((Object[])new String[]{user1_1, user1_2, user2_1, user2_2}), ActiveRoleSet.ALL, (Authorizable[])null);
                Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=server->db=db1->table=table1_1->action=all", "server=server->db=db1->table=table1_2->action=all", "server=server->db=db1->table=table2_1->action=all", "server=server->db=db1->table=table2_2->action=all", "server=server->db=db1->table=table3_1->action=all", "server=server->db=db1->table=table3_2->action=all", "server=server->db=db1->table=table4_1->action=all", "server=server->db=db1->table=table4_2->action=all"}), (Object)listPrivilegesForProvider);
                TestSentryServiceIntegration.this.client.revokeRoleFromUser(requestorUserName, user1_1, roleName3);
                TestSentryServiceIntegration.this.client.revokeRoleFromUsers(requestorUserName, roleName4, (Set)Sets.newHashSet((Object[])new String[]{user2_1}));
            }
        });
    }

    @Test
    public void testMultipleRolesSamePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db", "table", "ALL");
                Set listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not assigned to role1 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db", "table", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not assigned to role2 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testShowRoleGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_testdb";
                String groupName = "group1";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listAllRoles(requestorUserName);
                Assert.assertEquals((String)"Incorrect number of roles", (long)1L, (long)roles.size());
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, groupName, roleName);
                Set groupRoles = TestSentryServiceIntegration.this.client.listRolesByGroupName(requestorUserName, groupName);
                Assert.assertTrue((groupRoles.size() == 1 ? 1 : 0) != 0);
                for (TSentryRole role : groupRoles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                    Assert.assertTrue((role.getGroups().size() == 1 ? 1 : 0) != 0);
                    for (TSentryGroup group : role.getGroups()) {
                        Assert.assertTrue((String)group.getGroupName(), (boolean)group.getGroupName().equalsIgnoreCase(groupName));
                    }
                }
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testShowGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_testdb";
                String server = "server1";
                String db = "testDB";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listAllRoles(requestorUserName);
                Assert.assertEquals((String)"Incorrect number of roles", (long)1L, (long)roles.size());
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName, server, db, "*");
                Set privileges = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName);
                Assert.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeDatabasePrivilege(requestorUserName, roleName, server, db, "*");
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testUriWithEquals() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_testdb";
                String server = "server1";
                String uri = "file://u/w/h/t/partition=value/";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listAllRoles(requestorUserName);
                Assert.assertEquals((String)"Incorrect number of roles", (long)1L, (long)roles.size());
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName, server, uri);
                Set privileges = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName);
                Assert.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeURIPrivilege(requestorUserName, roleName, server, uri);
                privileges = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName);
                Assert.assertTrue((privileges.size() == 0 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testSameGrantTwice() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL");
                Assert.assertEquals((long)1L, (long)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
            }
        });
    }

    @Test
    public void testGrantRevokeWithGrantOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                boolean grantOption = true;
                boolean withoutGrantOption = false;
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(grantOption));
                Assert.assertEquals((long)1L, (long)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(withoutGrantOption));
                Assert.assertEquals((long)1L, (long)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(grantOption));
                Assert.assertEquals((long)0L, (long)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
            }
        });
    }

    @Test
    public void testGrantTwoPrivilegeDiffInGrantOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                boolean grantOption = true;
                boolean withoutGrantOption = false;
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(grantOption));
                Assert.assertEquals((long)1L, (long)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(withoutGrantOption));
                Assert.assertEquals((long)2L, (long)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", null);
                Assert.assertEquals((long)0L, (long)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeOnColumnForRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table1", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table2", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table1", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table2", "col1", "ALL");
                Set listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertEquals((String)"Privilege not assigned to role1 !!", (long)6L, (long)listPrivilegesByRoleName.size());
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertEquals((String)"Privilege not assigned to role2 !!", (long)6L, (long)listPrivilegesByRoleName.size());
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table1", "col1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 5 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 6 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db1", "table1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 4 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 5 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeDatabasePrivilege(requestorUserName, roleName1, "server", "db1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 2 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table2", "col1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col2", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table2", "col1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testListByAuthDB() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName1 = "role1";
                String roleName2 = "role2";
                HashSet testRoleSet = Sets.newHashSet((Object[])new String[]{roleName1, roleName2});
                String group1 = "group1";
                String group2 = "group2";
                HashSet testGroupSet = Sets.newHashSet((Object[])new String[]{group1, group2});
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                String group1user = "group1user";
                TestSentryServiceIntegration.this.setLocalGroupMapping(group1user, Sets.newHashSet((Object[])new String[]{group1}));
                String group2user = "group2user";
                TestSentryServiceIntegration.this.setLocalGroupMapping(group2user, Sets.newHashSet((Object[])new String[]{group2}));
                TestSentryServiceIntegration.this.setLocalGroupMapping("random", Sets.newHashSet((Object[])new String[]{"foo"}));
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TSentryPrivilege role1db1 = TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, "hdfs:///fooUri");
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group1, roleName1);
                TSentryPrivilege role2db1 = TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group2, roleName2);
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1db1}));
                db1RoleToPrivMap.getPrivilegeMap().put(roleName2, Sets.newHashSet((Object[])new TSentryPrivilege[]{role2db1}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList db1Authrizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new Database(db)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db1Authrizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(db1Authrizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, null);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, new ActiveRoleSet((Set)testRoleSet));
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, ActiveRoleSet.ALL);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, (Set)testGroupSet, null);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, (Set)testGroupSet, new ActiveRoleSet((Set)testRoleSet));
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, (Set)testGroupSet, ActiveRoleSet.ALL);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable("random", (Set)authorizableSet, new HashSet(), ActiveRoleSet.ALL);
                expectedResults.clear();
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db1Authrizable), new TSentryPrivilegeMap(new HashMap()));
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
            }
        });
    }

    @Test
    public void testListByAuthTab() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName1 = "role1";
                String roleName2 = "role2";
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TSentryPrivilege role1db2tab = TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TSentryPrivilege role2db2tab = TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, "hdfs:///fooUri");
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1db2tab}));
                db1RoleToPrivMap.getPrivilegeMap().put(roleName2, Sets.newHashSet((Object[])new TSentryPrivilege[]{role2db2tab}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList db2TabAuthrizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new Database(db2), new Table(tab)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db2TabAuthrizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(db2TabAuthrizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, null);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
            }
        });
    }

    @Test
    public void testListByAuthUri() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName1 = "role1";
                String roleName2 = "role2";
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                String uri1 = "hdfs:///fooUri";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TSentryPrivilege role1uri1 = TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, uri1);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TSentryPrivilege role2uri2 = TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName2, server, uri1);
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1uri1}));
                db1RoleToPrivMap.getPrivilegeMap().put(roleName2, Sets.newHashSet((Object[])new TSentryPrivilege[]{role2uri2}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList uri1Authrizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new AccessURI(uri1)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)uri1Authrizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(uri1Authrizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, null);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
            }
        });
    }

    @Test
    public void testListByAuthTabForNonAdmin() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                String user1 = "user1";
                String group1 = "group1";
                String group2 = "group2";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                HashSet userGroupNames1 = Sets.newHashSet((Object[])new String[]{group1});
                HashSet userGroupNames2 = Sets.newHashSet((Object[])new String[]{group2});
                String roleName1 = "role1";
                String roleName2 = "role2";
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.setLocalGroupMapping(user1, userGroupNames1);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TSentryPrivilege role1db2tab = TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group1, roleName1);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, "hdfs:///fooUri");
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1db2tab}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList db2TabAuthorizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new Database(db2), new Table(tab)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db2TabAuthorizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(db2TabAuthorizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, null);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, new HashSet(), null);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, new ActiveRoleSet(true));
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, (Set)userGroupNames1, null);
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, (Set)userGroupNames1, new ActiveRoleSet(true));
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, new ActiveRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleName1.toUpperCase()})));
                Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                try {
                    TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, (Set)userGroupNames2, null);
                    Assert.fail((String)("listPrivilegsbyAuthorizable() should fail for user1 accessing " + group2));
                }
                catch (SentryAccessDeniedException sentryAccessDeniedException) {
                    // empty catch block
                }
                ActiveRoleSet roleSet2 = new ActiveRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleName2}));
                try {
                    TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, roleSet2);
                    Assert.fail((String)("listPrivilegsbyAuthorizable() should fail for user1 accessing " + roleName2));
                }
                catch (SentryAccessDeniedException sentryAccessDeniedException) {
                    // empty catch block
                }
            }
        });
    }

    private void checkBannedConfigVal(final String configVal, final String defaultVal) throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                try {
                    TestSentryServiceIntegration.this.client.getConfigValue(configVal, defaultVal);
                    Assert.fail((String)("Attempt to access " + configVal + " succeeded"));
                }
                catch (SentryAccessDeniedException e) {
                    Assert.assertTrue((boolean)e.toString().contains("was denied"));
                    Assert.assertTrue((boolean)e.toString().contains(configVal));
                }
            }
        });
    }

    @Test
    public void testGetConfigVal() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.service.admin.group", "xxx");
                Assert.assertEquals((Object)val, (Object)"admin_group");
                val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.this.is.not.defined", "hello");
                Assert.assertEquals((Object)val, (Object)"hello");
                val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.this.is.not.defined", null);
                Assert.assertEquals((Object)val, null);
                val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.service.admin.group", null);
                Assert.assertEquals((Object)val, (Object)"admin_group");
                TestSentryServiceIntegration.this.checkBannedConfigVal("notsentry", "xxx");
                TestSentryServiceIntegration.this.checkBannedConfigVal("notsentry", null);
                TestSentryServiceIntegration.this.checkBannedConfigVal("sentry.xxx.jdbc.xxx", null);
                TestSentryServiceIntegration.this.checkBannedConfigVal("sentry.xxx.password", null);
                TestSentryServiceIntegration.this.checkBannedConfigVal("sentry.service.server.keytab", null);
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeOnServerForRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.grantServerPrivilege(requestorUserName, roleName1, "server", Boolean.valueOf(false));
                Set listPrivs = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege should be all:", (boolean)((TSentryPrivilege)listPrivs.iterator().next()).getAction().equals("*"));
                TestSentryServiceIntegration.this.client.revokeServerPrivilege(requestorUserName, roleName1, "server", false);
                listPrivs = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivs.size() == 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeWithoutAction() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                String roleName1 = "admin_r1";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.grantServerPrivilege(requestorUserName, roleName1, "server1", Boolean.valueOf(false));
                Set listPrivs = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege should be all:", (boolean)((TSentryPrivilege)listPrivs.iterator().next()).getAction().equals("*"));
                TestSentryServiceIntegration.this.client.revokeServerPrivilege(requestorUserName, roleName1, "server1", "ALL", Boolean.valueOf(false));
                listPrivs = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivs.size() == 0 ? 1 : 0) != 0);
            }
        });
    }
}

