/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryServiceImportExport
extends SentryServiceIntegrationBase {
    public static String PRIVILIEGE1 = "server=server1";
    public static String PRIVILIEGE2 = "server=server1->action=select->grantoption=false";
    public static String PRIVILIEGE3 = "server=server1->db=db2->action=insert->grantoption=true";
    public static String PRIVILIEGE4 = "server=server1->db=db1->table=tbl1->action=insert";
    public static String PRIVILIEGE5 = "server=server1->db=db1->table=tbl2->column=col1->action=insert";
    public static String PRIVILIEGE6 = "server=server1->db=db1->table=tbl3->column=col1->action=*->grantoption=true";
    public static String PRIVILIEGE7 = "server=server1->db=db1->table=tbl4->column=col1->action=all->grantoption=true";
    public static String PRIVILIEGE8 = "server=server1->uri=hdfs://testserver:9999/path2->action=insert";
    public static String PRIVILIEGE9 = "server=server1->db=db2->table=tbl1->action=insert";

    @BeforeClass
    public static void setup() throws Exception {
        kerberos = false;
        TestSentryServiceImportExport.setupConf();
        TestSentryServiceImportExport.startSentryService();
    }

    @Before
    public void preparePolicyFile() throws Exception {
        super.before();
        String requestorUserName = "admin_user";
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
        this.writePolicyFile();
    }

    @Test
    public void testImportExportPolicy1() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData = Maps.newHashMap();
                HashMap groupRolesMap = Maps.newHashMap();
                HashSet roles = Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"});
                groupRolesMap.put("group1", roles);
                groupRolesMap.put("group2", roles);
                groupRolesMap.put("group3", roles);
                HashMap rolePrivilegesMap = Maps.newHashMap();
                for (String roleName : roles) {
                    rolePrivilegesMap.put(roleName, Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                }
                policyFileMappingData.put("groups", groupRolesMap);
                policyFileMappingData.put("roles", rolePrivilegesMap);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData, "admin_user", false);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, policyFileMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy2() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData1 = Maps.newHashMap();
                HashMap groupRolesMap1 = Maps.newHashMap();
                groupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                rolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4}));
                policyFileMappingData1.put("groups", groupRolesMap1);
                policyFileMappingData1.put("roles", rolePrivilegesMap1);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData1, "admin_user", false);
                HashMap policyFileMappingData2 = Maps.newHashMap();
                HashMap groupRolesMap2 = Maps.newHashMap();
                groupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                groupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                HashMap rolePrivilegesMap2 = Maps.newHashMap();
                rolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                rolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                policyFileMappingData2.put("groups", groupRolesMap2);
                policyFileMappingData2.put("roles", rolePrivilegesMap2);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData2, "admin_user", false);
                HashMap exceptedMappingData = Maps.newHashMap();
                exceptedMappingData.put("groups", policyFileMappingData1.get("groups"));
                ((Map)exceptedMappingData.get("groups")).putAll((Map)policyFileMappingData2.get("groups"));
                exceptedMappingData.put("roles", policyFileMappingData1.get("roles"));
                ((Map)exceptedMappingData.get("roles")).putAll((Map)policyFileMappingData2.get("roles"));
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, exceptedMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy3() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData1 = Maps.newHashMap();
                HashMap groupRolesMap1 = Maps.newHashMap();
                groupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                groupRolesMap1.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                groupRolesMap1.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                rolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5}));
                rolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5}));
                policyFileMappingData1.put("groups", groupRolesMap1);
                policyFileMappingData1.put("roles", rolePrivilegesMap1);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData1, "admin_user", false);
                HashMap policyFileMappingData2 = Maps.newHashMap();
                HashMap groupRolesMap2 = Maps.newHashMap();
                groupRolesMap2.put("group1", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                groupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                groupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                HashMap rolePrivilegesMap2 = Maps.newHashMap();
                rolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                rolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                policyFileMappingData2.put("groups", groupRolesMap2);
                policyFileMappingData2.put("roles", rolePrivilegesMap2);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData2, "admin_user", false);
                HashMap exceptedMappingData = Maps.newHashMap();
                HashMap exceptedRolesMap = Maps.newHashMap();
                exceptedRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                exceptedRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                exceptedRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                HashMap exceptedPrivilegesMap = Maps.newHashMap();
                exceptedPrivilegesMap.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5}));
                exceptedPrivilegesMap.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                exceptedPrivilegesMap.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                exceptedMappingData.put("groups", exceptedRolesMap);
                exceptedMappingData.put("roles", exceptedPrivilegesMap);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, exceptedMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy4() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData = Maps.newHashMap();
                HashMap groupRolesMap = Maps.newHashMap();
                HashSet roles = Sets.newHashSet((Object[])new String[]{"role1", "role2"});
                groupRolesMap.put("group1", roles);
                HashMap rolePrivilegesMap = Maps.newHashMap();
                policyFileMappingData.put("groups", groupRolesMap);
                policyFileMappingData.put("roles", rolePrivilegesMap);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData, "admin_user", false);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, policyFileMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy5() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData1 = Maps.newHashMap();
                HashMap groupRolesMap1 = Maps.newHashMap();
                groupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                rolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1}));
                policyFileMappingData1.put("groups", groupRolesMap1);
                policyFileMappingData1.put("roles", rolePrivilegesMap1);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData1, "admin_user", true);
                HashMap policyFileMappingData2 = Maps.newHashMap();
                HashMap groupRolesMap2 = Maps.newHashMap();
                groupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                groupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                HashMap rolePrivilegesMap2 = Maps.newHashMap();
                rolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE2}));
                rolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE2}));
                policyFileMappingData2.put("groups", groupRolesMap2);
                policyFileMappingData2.put("roles", rolePrivilegesMap2);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData2, "admin_user", true);
                HashMap exceptedMappingData = Maps.newHashMap();
                HashMap exceptedRolesMap = Maps.newHashMap();
                exceptedRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                exceptedRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                exceptedRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                HashMap exceptedPrivilegesMap = Maps.newHashMap();
                exceptedPrivilegesMap.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1}));
                exceptedPrivilegesMap.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE2}));
                exceptedPrivilegesMap.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE2}));
                exceptedMappingData.put("groups", exceptedRolesMap);
                exceptedMappingData.put("roles", exceptedPrivilegesMap);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, exceptedMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy6() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData1 = Maps.newHashMap();
                HashMap groupRolesMap1 = Maps.newHashMap();
                groupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                groupRolesMap1.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                groupRolesMap1.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                rolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5}));
                rolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5}));
                policyFileMappingData1.put("groups", groupRolesMap1);
                policyFileMappingData1.put("roles", rolePrivilegesMap1);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData1, "admin_user", true);
                HashMap policyFileMappingData2 = Maps.newHashMap();
                HashMap groupRolesMap2 = Maps.newHashMap();
                groupRolesMap2.put("group1", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                groupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                groupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                HashMap rolePrivilegesMap2 = Maps.newHashMap();
                rolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                rolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                policyFileMappingData2.put("groups", groupRolesMap2);
                policyFileMappingData2.put("roles", rolePrivilegesMap2);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData2, "admin_user", true);
                HashMap exceptedMappingData = Maps.newHashMap();
                HashMap exceptedRolesMap = Maps.newHashMap();
                exceptedRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                exceptedRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                exceptedRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                HashMap exceptedPrivilegesMap = Maps.newHashMap();
                exceptedPrivilegesMap.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5}));
                exceptedPrivilegesMap.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                exceptedPrivilegesMap.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                exceptedMappingData.put("groups", exceptedRolesMap);
                exceptedMappingData.put("roles", exceptedPrivilegesMap);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, exceptedMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy7() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String testPrivilege1 = "server=server1->db=db1->table=tbl1->action=select->grantoption=true";
                String testPrivilege2 = "server=server1->db=db1->table=tbl1->action=insert->grantoption=false";
                String testPrivilege3 = "server=server1->db=db1->table=tbl1->action=all->grantoption=true";
                String testPrivilege4 = "server=server1->db=db1->table=tbl1->action=insert->grantoption=true";
                String testPrivilege5 = "server=server1->db=db1->table=tbl2->action=select->grantoption=true";
                String testPrivilege6 = "server=server1->db=db1->table=tbl2->action=insert->grantoption=false";
                String testPrivilege7 = "server=server1->db=db1->table=tbl2->action=*->grantoption=true";
                String testPrivilege8 = "server=server1->db=db1->table=tbl2->action=insert->grantoption=true";
                HashMap policyFileMappingData1 = Maps.newHashMap();
                HashMap groupRolesMap1 = Maps.newHashMap();
                groupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                rolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new String[]{testPrivilege1, testPrivilege2, testPrivilege3, testPrivilege4}));
                rolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new String[]{testPrivilege5, testPrivilege6, testPrivilege7, testPrivilege8}));
                policyFileMappingData1.put("groups", groupRolesMap1);
                policyFileMappingData1.put("roles", rolePrivilegesMap1);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData1, "admin_user", true);
                HashMap exceptedMappingData = Maps.newHashMap();
                HashMap exceptedRolesMap = Maps.newHashMap();
                exceptedRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                HashMap exceptedPrivilegesMap = Maps.newHashMap();
                exceptedPrivilegesMap.put("role1", Sets.newHashSet((Object[])new String[]{testPrivilege2, testPrivilege3}));
                exceptedPrivilegesMap.put("role2", Sets.newHashSet((Object[])new String[]{testPrivilege6, testPrivilege7}));
                exceptedMappingData.put("groups", exceptedRolesMap);
                exceptedMappingData.put("roles", exceptedPrivilegesMap);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, exceptedMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy8() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String testPrivilege1 = "server=server1->db=db1->table=tbl1->action=select->grantoption=true";
                String testPrivilege2 = "server=server1->db=db1->table=tbl1->action=insert->grantoption=true";
                String testPrivilege3 = "server=server1->db=db1->table=tbl1->action=all->grantoption=true";
                String testPrivilege4 = "server=server1->db=db1->table=tbl2->action=select->grantoption=true";
                String testPrivilege5 = "server=server1->db=db1->table=tbl2->action=insert->grantoption=true";
                String testPrivilege6 = "server=server1->db=db1->table=tbl2->action=*->grantoption=true";
                HashMap policyFileMappingData1 = Maps.newHashMap();
                HashMap groupRolesMap1 = Maps.newHashMap();
                groupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                rolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new String[]{testPrivilege1, testPrivilege2}));
                rolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new String[]{testPrivilege4, testPrivilege5}));
                policyFileMappingData1.put("groups", groupRolesMap1);
                policyFileMappingData1.put("roles", rolePrivilegesMap1);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData1, "admin_user", false);
                HashMap policyFileMappingData2 = Maps.newHashMap();
                HashMap groupRolesMap2 = Maps.newHashMap();
                groupRolesMap2.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                HashMap rolePrivilegesMap2 = Maps.newHashMap();
                rolePrivilegesMap2.put("role1", Sets.newHashSet((Object[])new String[]{testPrivilege3}));
                rolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new String[]{testPrivilege6}));
                policyFileMappingData2.put("groups", groupRolesMap2);
                policyFileMappingData2.put("roles", rolePrivilegesMap2);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData2, "admin_user", false);
                HashMap exceptedMappingData = policyFileMappingData2;
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, exceptedMappingData);
            }
        });
    }

    @Test
    public void testImportExportPolicy9() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData1 = Maps.newHashMap();
                HashMap groupRolesMap1 = Maps.newHashMap();
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                policyFileMappingData1.put("groups", groupRolesMap1);
                policyFileMappingData1.put("roles", rolePrivilegesMap1);
                try {
                    TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData1, "no-admin-user", false);
                    Assert.fail((String)"non-admin can't do the import.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    TestSentryServiceImportExport.this.client.exportPolicy("no-admin-user", null);
                    Assert.fail((String)"non-admin can't do the export.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testExportPolicyWithSpecificObject() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData = Maps.newHashMap();
                HashMap groupRolesMap = Maps.newHashMap();
                groupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                groupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                groupRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                groupRolesMap.put("group4", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                HashMap rolePrivilegesMap1 = Maps.newHashMap();
                rolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE9}));
                rolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7}));
                rolePrivilegesMap1.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                policyFileMappingData.put("groups", groupRolesMap);
                policyFileMappingData.put("roles", rolePrivilegesMap1);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData, "admin_user", true);
                HashMap expectedMappingData = Maps.newHashMap();
                HashMap expectedGroupRoles = Maps.newHashMap();
                expectedGroupRoles.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                expectedGroupRoles.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                expectedGroupRoles.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                expectedGroupRoles.put("group4", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                HashMap expectedRolePrivileges = Maps.newHashMap();
                expectedRolePrivileges.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE9}));
                expectedRolePrivileges.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7}));
                expectedRolePrivileges.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                expectedMappingData.put("groups", expectedGroupRoles);
                expectedMappingData.put("roles", expectedRolePrivileges);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, expectedMappingData);
                expectedMappingData = Maps.newHashMap();
                expectedGroupRoles = Maps.newHashMap();
                expectedGroupRoles.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                expectedGroupRoles.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                expectedGroupRoles.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                expectedGroupRoles.put("group4", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                expectedRolePrivileges = Maps.newHashMap();
                expectedRolePrivileges.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE9}));
                expectedRolePrivileges.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3, PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7}));
                expectedRolePrivileges.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7, PRIVILIEGE8}));
                expectedMappingData.put("groups", expectedGroupRoles);
                expectedMappingData.put("roles", expectedRolePrivileges);
                sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", "");
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, expectedMappingData);
                expectedMappingData = Maps.newHashMap();
                expectedGroupRoles = Maps.newHashMap();
                expectedGroupRoles.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                expectedGroupRoles.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                expectedGroupRoles.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                expectedGroupRoles.put("group4", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                expectedRolePrivileges = Maps.newHashMap();
                expectedRolePrivileges.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4}));
                expectedRolePrivileges.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7}));
                expectedRolePrivileges.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE5, PRIVILIEGE6, PRIVILIEGE7}));
                expectedMappingData.put("groups", expectedGroupRoles);
                expectedMappingData.put("roles", expectedRolePrivileges);
                sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", "db=db1");
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, expectedMappingData);
                expectedMappingData = Maps.newHashMap();
                expectedGroupRoles = Maps.newHashMap();
                expectedGroupRoles.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                expectedGroupRoles.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                expectedGroupRoles.put("group3", Sets.newHashSet((Object[])new String[]{"role2"}));
                expectedGroupRoles.put("group4", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                expectedRolePrivileges = Maps.newHashMap();
                expectedRolePrivileges.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3, PRIVILIEGE9}));
                expectedRolePrivileges.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE3}));
                expectedMappingData.put("groups", expectedGroupRoles);
                expectedMappingData.put("roles", expectedRolePrivileges);
                sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", "db=db2");
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, expectedMappingData);
                expectedMappingData = Maps.newHashMap();
                expectedGroupRoles = Maps.newHashMap();
                expectedGroupRoles.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                expectedGroupRoles.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                expectedGroupRoles.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                expectedGroupRoles.put("group4", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                expectedRolePrivileges = Maps.newHashMap();
                expectedRolePrivileges.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4}));
                expectedRolePrivileges.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4}));
                expectedRolePrivileges.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4}));
                expectedMappingData.put("groups", expectedGroupRoles);
                expectedMappingData.put("roles", expectedRolePrivileges);
                sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", "db=db1->table=tbl1");
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, expectedMappingData);
                expectedMappingData = Maps.newHashMap();
                expectedGroupRoles = Maps.newHashMap();
                expectedGroupRoles.put("group2", Sets.newHashSet((Object[])new String[]{"role2"}));
                expectedGroupRoles.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                expectedGroupRoles.put("group4", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                expectedRolePrivileges = Maps.newHashMap();
                expectedRolePrivileges.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE5}));
                expectedRolePrivileges.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE5}));
                expectedMappingData.put("groups", expectedGroupRoles);
                expectedMappingData.put("roles", expectedRolePrivileges);
                sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", "db=db1->table=tbl2");
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, expectedMappingData);
                expectedMappingData = Maps.newHashMap();
                expectedGroupRoles = Maps.newHashMap();
                expectedGroupRoles.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
                expectedGroupRoles.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
                expectedGroupRoles.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
                expectedGroupRoles.put("group4", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
                expectedRolePrivileges = Maps.newHashMap();
                expectedRolePrivileges.put("role1", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4, PRIVILIEGE9}));
                expectedRolePrivileges.put("role2", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4}));
                expectedRolePrivileges.put("role3", Sets.newHashSet((Object[])new String[]{PRIVILIEGE4}));
                expectedMappingData.put("groups", expectedGroupRoles);
                expectedMappingData.put("roles", expectedRolePrivileges);
                sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", "table=tbl1");
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, expectedMappingData);
                try {
                    TestSentryServiceImportExport.this.client.exportPolicy("admin_user", "invalidString");
                    Assert.fail((String)"RuntimeException should be thrown.");
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testImportExportPolicyWithUser() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                HashMap policyFileMappingData = Maps.newHashMap();
                HashMap groupRolesMap = Maps.newHashMap();
                HashMap userRolesMap = Maps.newHashMap();
                HashSet roles = Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"});
                groupRolesMap.put("group1", roles);
                groupRolesMap.put("group2", roles);
                userRolesMap.put("user1", roles);
                userRolesMap.put("user2", roles);
                HashMap rolePrivilegesMap = Maps.newHashMap();
                for (String roleName : roles) {
                    rolePrivilegesMap.put(roleName, Sets.newHashSet((Object[])new String[]{PRIVILIEGE1, PRIVILIEGE2, PRIVILIEGE3, PRIVILIEGE4}));
                }
                policyFileMappingData.put("userroles", userRolesMap);
                policyFileMappingData.put("groups", groupRolesMap);
                policyFileMappingData.put("roles", rolePrivilegesMap);
                TestSentryServiceImportExport.this.client.importPolicy((Map)policyFileMappingData, "admin_user", false);
                Map sentryMappingData = TestSentryServiceImportExport.this.client.exportPolicy("admin_user", null);
                TestSentryServiceImportExport.this.validateRolesMap((Map)sentryMappingData.get("userroles"), (Map)policyFileMappingData.get("userroles"));
                TestSentryServiceImportExport.this.validateSentryMappingData(sentryMappingData, policyFileMappingData);
            }
        });
    }

    public void validateSentryMappingData(Map<String, Map<String, Set<String>>> actualMappingData, Map<String, Map<String, Set<String>>> expectedMappingData) {
        this.validateRolesMap(actualMappingData.get("groups"), expectedMappingData.get("groups"));
        this.validateRolePrivilegesMap(actualMappingData.get("roles"), expectedMappingData.get("roles"));
    }

    private void validateRolesMap(Map<String, Set<String>> actualMap, Map<String, Set<String>> expectedMap) {
        Assert.assertEquals((long)expectedMap.keySet().size(), (long)actualMap.keySet().size());
        for (String name : actualMap.keySet()) {
            Set<String> actualRoles = actualMap.get(name);
            Set<String> expectedRoles = expectedMap.get(name);
            Assert.assertEquals((long)actualRoles.size(), (long)expectedRoles.size());
            Assert.assertTrue((boolean)actualRoles.equals(expectedRoles));
        }
    }

    private void validateRolePrivilegesMap(Map<String, Set<String>> actualMap, Map<String, Set<String>> expectedMap) {
        Assert.assertEquals((long)expectedMap.keySet().size(), (long)actualMap.keySet().size());
        for (String roleName : actualMap.keySet()) {
            Set<String> actualPrivileges = actualMap.get(roleName);
            Set<String> exceptedPrivileges = expectedMap.get(roleName);
            Assert.assertEquals((long)exceptedPrivileges.size(), (long)actualPrivileges.size());
            for (String actualPrivilege : actualPrivileges) {
                boolean isFound = exceptedPrivileges.contains(actualPrivilege);
                if (!isFound) {
                    String withOptionPrivilege = SentryConstants.AUTHORIZABLE_JOINER.join((Object)actualPrivilege, (Object)SentryConstants.KV_JOINER.join((Object)"grantoption", (Object)"false", new Object[0]), new Object[0]);
                    isFound = exceptedPrivileges.contains(withOptionPrivilege);
                }
                Assert.assertTrue((boolean)isFound);
            }
        }
    }
}

