/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.base.Strings;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSentryServiceFailureCase
extends SentryServiceIntegrationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSentryServiceFailureCase.class);
    private static final String PEER_CALLBACK_FAILURE = "Peer indicated failure: Problem with callback handler";

    @BeforeClass
    public static void setup() throws Exception {
        kerberos = true;
        TestSentryServiceFailureCase.beforeSetup();
        TestSentryServiceFailureCase.setupConf();
        conf.set("sentry.service.allow.connect", "");
        TestSentryServiceFailureCase.startSentryService();
        TestSentryServiceFailureCase.afterSetup();
    }

    @Override
    @Before
    public void before() throws Exception {
    }

    @Override
    @After
    public void after() {
    }

    @Test
    public void testClientServerConnectionFailure() throws Exception {
        try {
            this.connectToSentryService();
            String requestorUserName = "admin_user";
            this.client.listAllRoles(requestorUserName);
            Assert.fail((String)"Failed to receive Exception");
        }
        catch (Exception e) {
            LOGGER.info("Excepted exception", (Throwable)e);
            Throwable cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            String msg = "Exception message: " + cause.getMessage();
            Assert.assertTrue((String)msg, (boolean)Strings.nullToEmpty((String)cause.getMessage()).contains(PEER_CALLBACK_FAILURE));
        }
    }
}

