/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Sets;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.service.thrift.SentryServiceFactory;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Assert;
import org.junit.Test;

public class TestSentryServiceClientPool
extends SentryServiceIntegrationBase {
    @Test
    public void testConnectionWhenReconnect() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryServiceClientPool.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceClientPool.this.writePolicyFile();
                TestSentryServiceClientPool.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceClientPool.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceClientPool.this.client.listAllRoles(requestorUserName);
                TestSentryServiceClientPool.this.stopSentryService();
                server = SentryServiceFactory.create((Configuration)conf);
                SentryServiceIntegrationBase.startSentryService();
                TestSentryServiceClientPool.this.client.listAllRoles(requestorUserName);
                TestSentryServiceClientPool.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testConnectionWithMultipleRetries() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                ArrayList<FutureTask<Boolean>> tasks = new ArrayList<FutureTask<Boolean>>();
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryServiceClientPool.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceClientPool.this.writePolicyFile();
                TestSentryServiceClientPool.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceClientPool.this.client.createRole(requestorUserName, roleName);
                ExecutorService executorService = Executors.newFixedThreadPool(20);
                Callable<Boolean> func = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return (Boolean)clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                            @Override
                            public Boolean run() throws Exception {
                                try {
                                    TestSentryServiceClientPool.this.client.listAllRoles("admin_user");
                                    return true;
                                }
                                catch (SentryUserException sue) {
                                    return false;
                                }
                            }
                        });
                    }
                };
                for (int i = 0; i < 30; ++i) {
                    FutureTask<Boolean> futureTask = new FutureTask<Boolean>(func);
                    tasks.add(futureTask);
                    executorService.submit(futureTask);
                }
                for (Future future : tasks) {
                    Boolean result = (Boolean)future.get();
                    Assert.assertTrue((String)"Some tasks are failed.", (boolean)result);
                }
            }
        });
    }
}

