/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.sentry.core.common.utils.PubSub;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryServerPubSub
extends SentryServiceIntegrationBase {
    private static final PubSub.Topic[] topics = PubSub.Topic.values();
    private static final String[] messages = new String[]{"message1", "message2", "message3", ""};
    private static volatile String REQUEST_URL;
    private final TestSubscriber testSubscriber = new TestSubscriber();

    @BeforeClass
    public static void setup() throws Exception {
        webServerEnabled = true;
        webSecurity = false;
        SentryServiceIntegrationBase.setup();
        REQUEST_URL = "http://" + SERVER_HOST + ":" + webServerPort + "/admin/publishMessage?topic=%s&message=%s";
    }

    @Override
    @Before
    public void before() throws Exception {
        this.testSubscriber.count = 0;
        for (PubSub.Topic topic : topics) {
            PubSub.getInstance().subscribe(topic, (PubSub.Subscriber)this.testSubscriber);
        }
        Assert.assertEquals((String)"Unexpected number of registered topics", (long)topics.length, (long)PubSub.getInstance().getTopics().size());
    }

    @Override
    @After
    public void after() {
        for (PubSub.Topic topic : topics) {
            PubSub.getInstance().unsubscribe(topic, (PubSub.Subscriber)this.testSubscriber);
        }
        this.testSubscriber.count = 0;
        Assert.assertTrue((String)"Topics should have been removed after unsubscribe()", (boolean)PubSub.getInstance().getTopics().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubSub() throws Exception {
        int count = 0;
        for (PubSub.Topic topic : topics) {
            for (String message : messages) {
                URL url = new URL(String.format(REQUEST_URL, topic.getName(), message));
                HttpURLConnection conn = null;
                try {
                    conn = (HttpURLConnection)url.openConnection();
                    Assert.assertEquals((String)"Unexpected response code", (long)200L, (long)conn.getResponseCode());
                }
                finally {
                    TestSentryServerPubSub.safeClose(conn);
                }
                Assert.assertEquals((String)"Unexpected topic", (Object)topic, (Object)this.testSubscriber.topic);
                if (message.isEmpty()) {
                    Assert.assertEquals((String)"Unexpected message", null, (Object)this.testSubscriber.message);
                } else {
                    Assert.assertEquals((String)"Unexpected message", (Object)message, (Object)this.testSubscriber.message);
                }
                Assert.assertEquals((String)"Unexpected number of PubSub.onMessage() callbacks", (long)(++count), (long)this.testSubscriber.count);
            }
        }
    }

    @Test
    public void testPubSubEmptyTopic() throws Exception {
        URL url = new URL(String.format(REQUEST_URL, "", "message"));
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            Assert.assertEquals((String)"Unexpected response code", (long)200L, (long)conn.getResponseCode());
        }
        finally {
            TestSentryServerPubSub.safeClose(conn);
        }
        Assert.assertEquals((String)"Unexpected number of PubSub.onMessage() callbacks", (long)0L, (long)this.testSubscriber.count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubSubInvalidTopic() throws Exception {
        String[] invalid_topics;
        for (String topic : invalid_topics = new String[]{"invalid_topic_1", "invalid_topic_2", "invalid_topic_3"}) {
            URL url = new URL(String.format(REQUEST_URL, topic, "message"));
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                Assert.assertEquals((String)"Unexpected response code", (long)400L, (long)conn.getResponseCode());
            }
            finally {
                TestSentryServerPubSub.safeClose(conn);
            }
            Assert.assertEquals((String)"Unexpected number of PubSub.onMessage() callbacks", (long)0L, (long)this.testSubscriber.count);
        }
    }

    @Test
    public void testPubSubNonSubscribedTopic() throws Exception {
        PubSub.getInstance().unsubscribe(PubSub.Topic.HDFS_SYNC_HMS, (PubSub.Subscriber)this.testSubscriber);
        Assert.assertEquals((String)"Unexpected number of registered topics", (long)(topics.length - 1), (long)PubSub.getInstance().getTopics().size());
        URL url = new URL(String.format(REQUEST_URL, PubSub.Topic.HDFS_SYNC_HMS.getName(), "message"));
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            Assert.assertEquals((String)"Unexpected response code", (long)400L, (long)conn.getResponseCode());
        }
        finally {
            TestSentryServerPubSub.safeClose(conn);
        }
        PubSub.getInstance().subscribe(PubSub.Topic.HDFS_SYNC_HMS, (PubSub.Subscriber)this.testSubscriber);
    }

    private static void safeClose(HttpURLConnection conn) {
        if (conn != null) {
            try {
                conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class TestSubscriber
    implements PubSub.Subscriber {
        private volatile PubSub.Topic topic;
        private volatile String message;
        private volatile int count;

        private TestSubscriber() {
        }

        public void onMessage(PubSub.Topic topic, String message) {
            this.topic = topic;
            this.message = message;
            ++this.count;
        }
    }
}

