/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryServerLogLevel
extends SentryServiceIntegrationBase {
    private final String CLASS_NAME = "org.eclipse.jetty.server.handler.ContextHandler";

    @BeforeClass
    public static void setup() throws Exception {
        webServerEnabled = true;
        webSecurity = false;
        SentryServiceIntegrationBase.setup();
    }

    @Override
    @Before
    public void before() throws Exception {
    }

    @Override
    @After
    public void after() {
    }

    private String getLogLevel(String className) {
        Logger logInstance = LogManager.getLogger((String)className);
        return logInstance.getEffectiveLevel().toString();
    }

    @Test
    public void testSetLogLevel() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/admin/logLevel?log=" + "org.eclipse.jetty.server.handler.ContextHandler" + "&level=INFO");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        String response = IOUtils.toString((InputStream)conn.getInputStream());
        Assert.assertTrue((boolean)response.contains("INFO"));
        Assert.assertEquals((Object)"INFO", (Object)this.getLogLevel("org.eclipse.jetty.server.handler.ContextHandler"));
    }

    @Test
    public void testGetLogLevel() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/admin/logLevel?log=" + "org.eclipse.jetty.server.handler.ContextHandler");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        String response = IOUtils.toString((InputStream)conn.getInputStream());
        Assert.assertTrue((boolean)response.contains("INFO"));
        Assert.assertEquals((Object)"INFO", (Object)this.getLogLevel("org.eclipse.jetty.server.handler.ContextHandler"));
    }

    @Test
    public void testInvalidLogLevel() throws Exception {
        URL url = new URL("http://" + SERVER_HOST + ":" + webServerPort + "/admin/logLevel?log=" + "org.eclipse.jetty.server.handler.ContextHandler" + "&level=ABCD");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)400L, (long)conn.getResponseCode());
    }
}

