/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.service.thrift.SentryServiceFactory;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryPolicyServiceClient
extends SentryServiceIntegrationBase {
    @BeforeClass
    public static void setup() throws Exception {
        TestSentryPolicyServiceClient.beforeSetup();
        TestSentryPolicyServiceClient.setupConf();
        TestSentryPolicyServiceClient.startSentryService();
        TestSentryPolicyServiceClient.afterSetup();
        kerberos = false;
    }

    @Test
    public void testConnectionWhenReconnect() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryPolicyServiceClient.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryPolicyServiceClient.this.writePolicyFile();
                TestSentryPolicyServiceClient.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryPolicyServiceClient.this.client.createRole(requestorUserName, roleName);
                TestSentryPolicyServiceClient.this.client.listAllRoles(requestorUserName);
                TestSentryPolicyServiceClient.this.stopSentryService();
                server = SentryServiceFactory.create((Configuration)conf);
                SentryServiceIntegrationBase.startSentryService();
                TestSentryPolicyServiceClient.this.client.listAllRoles(requestorUserName);
                TestSentryPolicyServiceClient.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }
}

