/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.thrift.NotificationHandler;
import org.apache.sentry.provider.db.service.thrift.NotificationHandlerInvoker;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNotificationHandlerInvoker {
    private Configuration conf;
    private NotificationHandler handler;
    private NotificationHandlerInvoker invoker;

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration(false);
        this.handler = (NotificationHandler)Mockito.spy((Object)new NotificationHandler(this.conf){});
        this.invoker = new NotificationHandlerInvoker(this.conf, (List)Lists.newArrayList((Object[])new NotificationHandler[]{new ThrowingNotificationHandler(this.conf), this.handler}));
    }

    @Test
    public void testCreateSentryRole() throws Exception {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        TCreateSentryRoleResponse response = new TCreateSentryRoleResponse();
        this.invoker.create_sentry_role(request, response);
        ((NotificationHandler)Mockito.verify((Object)this.handler)).create_sentry_role(request, response);
    }

    @Test
    public void testDropSentryRole() throws Exception {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        TDropSentryRoleResponse response = new TDropSentryRoleResponse();
        this.invoker.drop_sentry_role(request, response);
        ((NotificationHandler)Mockito.verify((Object)this.handler)).drop_sentry_role(request, response);
    }

    @Test
    public void testAlterSentryRoleAddGroups() throws Exception {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest();
        TAlterSentryRoleAddGroupsResponse response = new TAlterSentryRoleAddGroupsResponse();
        this.invoker.alter_sentry_role_add_groups(request, response);
        ((NotificationHandler)Mockito.verify((Object)this.handler)).alter_sentry_role_add_groups(request, response);
    }

    @Test
    public void testAlterSentryRoleDeleteGroups() throws Exception {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest();
        TAlterSentryRoleDeleteGroupsResponse response = new TAlterSentryRoleDeleteGroupsResponse();
        this.invoker.alter_sentry_role_delete_groups(request, response);
        ((NotificationHandler)Mockito.verify((Object)this.handler)).alter_sentry_role_delete_groups(request, response);
    }

    public static class ThrowingNotificationHandler
    extends NotificationHandler {
        public ThrowingNotificationHandler(Configuration config) throws Exception {
            super(config);
        }

        public void create_sentry_role(TCreateSentryRoleRequest request, TCreateSentryRoleResponse response) {
            throw new RuntimeException();
        }

        public void drop_sentry_role(TDropSentryRoleRequest request, TDropSentryRoleResponse response) {
            throw new RuntimeException();
        }

        public void alter_sentry_role_add_groups(TAlterSentryRoleAddGroupsRequest request, TAlterSentryRoleAddGroupsResponse response) {
            throw new RuntimeException();
        }

        public void alter_sentry_role_delete_groups(TAlterSentryRoleDeleteGroupsRequest request, TAlterSentryRoleDeleteGroupsResponse response) {
            throw new RuntimeException();
        }
    }
}

