/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sentry.provider.db.log.appender.AuditLoggerTestAppender;
import org.apache.sentry.provider.db.log.util.CommandUtil;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.codehaus.jettison.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAuthorizingDDLAuditLogWithKerberos
extends SentryServiceIntegrationBase {
    @BeforeClass
    public static void setupLog4j() throws Exception {
        Logger logger = Logger.getLogger((String)"sentry.hive.authorization.ddl.logger");
        AuditLoggerTestAppender testAppender = new AuditLoggerTestAppender();
        logger.addAppender((Appender)testAppender);
        logger.setLevel(Level.INFO);
    }

    @Test
    public void testBasic() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestAuthorizingDDLAuditLogWithKerberos.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestAuthorizingDDLAuditLogWithKerberos.this.writePolicyFile();
                String roleName = "testRole";
                String errorRoleName = "errorRole";
                String serverName = "server1";
                String groupName = "testGroup";
                String dbName = "dbTest";
                String tableName = "tableTest";
                HashMap<String, String> fieldValueMap = new HashMap<String, String>();
                TestAuthorizingDDLAuditLogWithKerberos.this.client.createRole(requestorUserName, roleName);
                fieldValueMap.put("operation", "CREATE_ROLE");
                fieldValueMap.put("operationText", "CREATE ROLE " + roleName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                TestAuthorizingDDLAuditLogWithKerberos.this.client.grantRoleToGroup(requestorUserName, groupName, roleName);
                fieldValueMap.clear();
                fieldValueMap.put("operation", "ADD_ROLE_TO_GROUP");
                fieldValueMap.put("operationText", "GRANT ROLE " + roleName + " TO GROUP " + groupName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                TestAuthorizingDDLAuditLogWithKerberos.this.client.grantDatabasePrivilege(requestorUserName, roleName, serverName, dbName, "ALL");
                fieldValueMap.clear();
                fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                fieldValueMap.put("operationText", "GRANT ALL ON DATABASE " + dbName + " TO ROLE " + roleName);
                fieldValueMap.put("databaseName", dbName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                TestAuthorizingDDLAuditLogWithKerberos.this.client.grantTablePrivilege(requestorUserName, roleName, serverName, dbName, tableName, "SELECT", Boolean.valueOf(true));
                fieldValueMap.clear();
                fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                fieldValueMap.put("operationText", "GRANT SELECT ON TABLE " + tableName + " TO ROLE " + roleName + " WITH GRANT OPTION");
                fieldValueMap.put("tableName", tableName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.createRole(requestorUserName, roleName);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "CREATE_ROLE");
                    fieldValueMap.put("operationText", "CREATE ROLE " + roleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.grantRoleToGroup(requestorUserName, groupName, errorRoleName);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "ADD_ROLE_TO_GROUP");
                    fieldValueMap.put("operationText", "GRANT ROLE " + errorRoleName + " TO GROUP " + groupName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.grantDatabasePrivilege(requestorUserName, errorRoleName, serverName, dbName, "ALL");
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                    fieldValueMap.put("operationText", "GRANT ALL ON DATABASE " + dbName + " TO ROLE " + errorRoleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.grantDatabasePrivilege(requestorUserName, errorRoleName, serverName, dbName, "INSERT");
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                    fieldValueMap.put("operationText", "GRANT INSERT ON DATABASE " + dbName + " TO ROLE " + errorRoleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.grantDatabasePrivilege(requestorUserName, errorRoleName, serverName, dbName, "SELECT");
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                    fieldValueMap.put("operationText", "GRANT SELECT ON DATABASE " + dbName + " TO ROLE " + errorRoleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.grantTablePrivilege(requestorUserName, errorRoleName, serverName, dbName, tableName, "SELECT");
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                    fieldValueMap.put("operationText", "GRANT SELECT ON TABLE " + tableName + " TO ROLE " + errorRoleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                TestAuthorizingDDLAuditLogWithKerberos.this.client.revokeTablePrivilege(requestorUserName, roleName, serverName, dbName, tableName, "SELECT");
                fieldValueMap.clear();
                fieldValueMap.put("operation", "REVOKE_PRIVILEGE");
                fieldValueMap.put("operationText", "REVOKE SELECT ON TABLE " + tableName + " FROM ROLE " + roleName);
                fieldValueMap.put("tableName", tableName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                TestAuthorizingDDLAuditLogWithKerberos.this.client.revokeDatabasePrivilege(requestorUserName, roleName, serverName, dbName, "ALL");
                fieldValueMap.clear();
                fieldValueMap.put("operation", "REVOKE_PRIVILEGE");
                fieldValueMap.put("operationText", "REVOKE ALL ON DATABASE " + dbName + " FROM ROLE " + roleName);
                fieldValueMap.put("databaseName", dbName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                TestAuthorizingDDLAuditLogWithKerberos.this.client.revokeRoleFromGroup(requestorUserName, groupName, roleName);
                fieldValueMap.clear();
                fieldValueMap.put("operation", "DELETE_ROLE_FROM_GROUP");
                fieldValueMap.put("operationText", "REVOKE ROLE " + roleName + " FROM GROUP " + groupName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                TestAuthorizingDDLAuditLogWithKerberos.this.client.dropRole(requestorUserName, roleName);
                fieldValueMap.clear();
                fieldValueMap.put("operation", "DROP_ROLE");
                fieldValueMap.put("operationText", "DROP ROLE " + roleName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.revokeTablePrivilege(requestorUserName, errorRoleName, serverName, dbName, tableName, "SELECT");
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "REVOKE_PRIVILEGE");
                    fieldValueMap.put("operationText", "REVOKE SELECT ON TABLE " + tableName + " FROM ROLE " + errorRoleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.revokeDatabasePrivilege(requestorUserName, errorRoleName, serverName, dbName, "ALL");
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "REVOKE_PRIVILEGE");
                    fieldValueMap.put("operationText", "REVOKE ALL ON DATABASE " + dbName + " FROM ROLE " + errorRoleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.revokeRoleFromGroup(requestorUserName, groupName, errorRoleName);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "DELETE_ROLE_FROM_GROUP");
                    fieldValueMap.put("operationText", "REVOKE ROLE " + errorRoleName + " FROM GROUP " + groupName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
                try {
                    TestAuthorizingDDLAuditLogWithKerberos.this.client.dropRole(requestorUserName, errorRoleName);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "DROP_ROLE");
                    fieldValueMap.put("operationText", "DROP ROLE " + errorRoleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuthorizingDDLAuditLogWithKerberos.this.assertAuditLog(fieldValueMap);
                }
            }
        });
    }

    private void assertAuditLog(Map<String, String> fieldValueMap) throws Exception {
        Assert.assertThat((Object)AuditLoggerTestAppender.getLastLogLevel(), (Matcher)Is.is((Object)Level.INFO));
        JSONObject jsonObject = new JSONObject(AuditLoggerTestAppender.getLastLogEvent());
        if (fieldValueMap != null) {
            for (Map.Entry<String, String> entry : fieldValueMap.entrySet()) {
                String entryKey = entry.getKey();
                if ("ipAddress".equals(entryKey)) {
                    Assert.assertTrue((boolean)CommandUtil.assertIPInAuditLog((String)jsonObject.get(entryKey).toString()));
                    continue;
                }
                Assert.assertTrue((boolean)entry.getValue().equalsIgnoreCase(jsonObject.get(entryKey).toString()));
            }
        }
    }
}

