/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.io.Files;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.service.thrift.SentryServiceUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSentryVersion {
    private File dataDir;
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        this.conf = new Configuration(false);
        this.conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + this.dataDir.getPath() + ";create=true");
        this.conf.set("sentry.store.jdbc.password", "dummy");
    }

    @Test
    public void testVerifySentryVersionCheck() throws Exception {
        this.conf.set("sentry.verify.schema.version", "false");
        boolean hdfsSyncEnabled = SentryServiceUtil.isHDFSSyncEnabled((Configuration)this.conf);
        SentryStore sentryStore = new SentryStore(this.conf);
        sentryStore.setPersistUpdateDeltas(hdfsSyncEnabled);
        sentryStore.stop();
        this.conf.set("sentry.verify.schema.version", "true");
        sentryStore = new SentryStore(this.conf);
        sentryStore.setPersistUpdateDeltas(hdfsSyncEnabled);
    }

    @Test(expected=SentryNoSuchObjectException.class)
    public void testNegSentrySchemaDefault() throws Exception {
        new SentryStore(this.conf);
    }

    @Test
    public void testSentryImplicitVersion() throws Exception {
        this.conf.set("sentry.verify.schema.version", "false");
        boolean hdfsSyncEnabled = SentryServiceUtil.isHDFSSyncEnabled((Configuration)this.conf);
        SentryStore sentryStore = new SentryStore(this.conf);
        sentryStore.setPersistUpdateDeltas(hdfsSyncEnabled);
        Assert.assertEquals((Object)SentryStoreSchemaInfo.getSentryVersion(), (Object)sentryStore.getSentryVersion());
    }
}

