/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jdo.JDODataStoreException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryGrantDeniedException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPathEntry;
import org.apache.sentry.hdfs.service.thrift.TPathsDump;
import org.apache.sentry.hdfs.service.thrift.TPathsUpdate;
import org.apache.sentry.hdfs.service.thrift.TPrivilegeChanges;
import org.apache.sentry.hdfs.service.thrift.TRoleChanges;
import org.apache.sentry.provider.db.service.model.MSentryPathChange;
import org.apache.sentry.provider.db.service.model.MSentryPermChange;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.DeltaTransactionBlock;
import org.apache.sentry.provider.db.service.persistent.PathsImage;
import org.apache.sentry.provider.db.service.persistent.PermissionsImage;
import org.apache.sentry.provider.db.service.persistent.QueryParamBuilder;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.service.persistent.TransactionManager;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.provider.file.PolicyFile;
import org.apache.sentry.service.thrift.SentryServiceUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSentryStore
extends Assert {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSentryStore.class);
    private static File dataDir;
    private static SentryStore sentryStore;
    private static String[] adminGroups;
    private static PolicyFile policyFile;
    private static File policyFilePath;
    final long NUM_PRIVS = 5L;
    private static Configuration conf;
    private static char[] passwd;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration(false);
        String ourUrl = "user:///";
        conf.set("hadoop.security.credential.provider.path", "user:///");
        conf.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        conf.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        if (provider.getCredentialEntry("sentry.store.jdbc.password") == null) {
            provider.createCredentialEntry("sentry.store.jdbc.password", passwd);
            provider.flush();
        }
        dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        conf.set("sentry.verify.schema.version", "false");
        conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dataDir.getPath() + ";create=true");
        conf.set("sentry.store.jdbc.password", "dummy");
        conf.setStrings("sentry.service.admin.group", adminGroups);
        conf.set("sentry.store.group.mapping", "org.apache.sentry.provider.file.LocalGroupMappingService");
        policyFilePath = new File(dataDir, "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", policyFilePath.getPath());
        conf.setInt("sentry.store.transaction.retry", 1);
        sentryStore = new SentryStore(conf);
        boolean hdfsSyncEnabled = SentryServiceUtil.isHDFSSyncEnabled((Configuration)conf);
        sentryStore.setPersistUpdateDeltas(hdfsSyncEnabled);
    }

    @Before
    public void before() throws Exception {
        policyFile = new PolicyFile();
        String adminUser = "g1";
        TestSentryStore.addGroupsToUser(adminUser, adminGroups);
        TestSentryStore.writePolicyFile();
    }

    @After
    public void after() {
        sentryStore.clearAllTables();
    }

    @AfterClass
    public static void teardown() {
        if (dataDir != null) {
            FileUtils.deleteQuietly((File)dataDir);
        }
        sentryStore.stop();
    }

    private void checkRoleDoesNotExist(String roleName) throws Exception {
        try {
            sentryStore.getMSentryRoleByName(roleName);
            TestSentryStore.fail((String)("Role " + roleName + "already exists"));
        }
        catch (SentryNoSuchObjectException sentryNoSuchObjectException) {
            // empty catch block
        }
    }

    private void checkRoleExists(String roleName) throws Exception {
        TestSentryStore.assertEquals((Object)roleName.toLowerCase(), (Object)sentryStore.getMSentryRoleByName(roleName).getRoleName());
    }

    private void createRole(String roleName) throws Exception {
        this.checkRoleDoesNotExist(roleName);
        sentryStore.createSentryRole(roleName);
        this.checkRoleExists(roleName);
    }

    @Test
    public void testCredentialProvider() throws Exception {
        TestSentryStore.assertArrayEquals((char[])passwd, (char[])conf.getPassword("sentry.store.jdbc.password"));
    }

    @Test
    public void testCaseInsensitiveRole() throws Exception {
        String roleName = "newRole";
        String grantor = "g1";
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName("test-groups-g1");
        groups.add(group);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName("server1");
        privilege.setDbName("default");
        privilege.setTableName("table1");
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        HashSet users = Sets.newHashSet((Object[])new String[]{"user1"});
        this.createRole(roleName);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, (Set)groups);
        sentryStore.alterSentryRoleDeleteGroups(roleName, (Set)groups);
        sentryStore.alterSentryRoleAddUsers(roleName, (Set)users);
        sentryStore.alterSentryRoleDeleteUsers(roleName, (Set)users);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
    }

    @Test
    public void testURI() throws Exception {
        String roleName = "test-dup-role";
        String grantor = "g1";
        String uri = "file:///var/folders/dt/9zm44z9s6bjfxbrm4v36lzdc0000gp/T/1401860678102-0/data/kv1.dat";
        this.createRole(roleName);
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege("URI", "server1", "ALL");
        tSentryPrivilege.setURI(uri);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, tSentryPrivilege);
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        tSentryAuthorizable.setUri(uri);
        tSentryAuthorizable.setServer("server1");
        Set privileges = sentryStore.getTSentryPrivileges(new HashSet<String>(Arrays.asList(roleName)), tSentryAuthorizable);
        TestSentryStore.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
        HashSet<TSentryGroup> tSentryGroups = new HashSet<TSentryGroup>();
        tSentryGroups.add(new TSentryGroup("group1"));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, tSentryGroups);
        sentryStore.alterSentryRoleAddUsers(roleName, (Set)Sets.newHashSet((Object[])new String[]{"user1"}));
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(true, new HashSet<String>(Arrays.asList(roleName)));
        Set privs = sentryStore.listSentryPrivilegesForProvider(new HashSet<String>(Arrays.asList("group1")), (Set)Sets.newHashSet((Object[])new String[]{""}), thriftRoleSet, tSentryAuthorizable);
        TestSentryStore.assertTrue((privs.size() == 1 ? 1 : 0) != 0);
        TestSentryStore.assertTrue((boolean)privs.contains("server=server1->uri=" + uri + "->action=all"));
        privs = sentryStore.listSentryPrivilegesForProvider(new HashSet<String>(Arrays.asList("")), (Set)Sets.newHashSet((Object[])new String[]{"user1"}), thriftRoleSet, tSentryAuthorizable);
        TestSentryStore.assertTrue((privs.size() == 1 ? 1 : 0) != 0);
        TestSentryStore.assertTrue((boolean)privs.contains("server=server1->uri=" + uri + "->action=all"));
        privs = sentryStore.listSentryPrivilegesForProvider(new HashSet<String>(Arrays.asList("group1")), (Set)Sets.newHashSet((Object[])new String[]{"user1"}), thriftRoleSet, tSentryAuthorizable);
        TestSentryStore.assertTrue((privs.size() == 1 ? 1 : 0) != 0);
        TestSentryStore.assertTrue((boolean)privs.contains("server=server1->uri=" + uri + "->action=all"));
    }

    @Test
    public void testCreateDuplicateRole() throws Exception {
        String roleName = "test-dup-role";
        this.createRole(roleName);
        try {
            sentryStore.createSentryRole(roleName);
            TestSentryStore.fail((String)"Expected SentryAlreadyExistsException");
        }
        catch (SentryAlreadyExistsException sentryAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCaseSensitiveScope() throws Exception {
        String roleName = "role1";
        String grantor = "g1";
        this.createRole(roleName);
        TSentryPrivilege sentryPrivilege = new TSentryPrivilege("Database", "server1", "all");
        sentryPrivilege.setDbName("db1");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, sentryPrivilege);
    }

    @Test
    public void testCreateDropRole() throws Exception {
        String roleName = "test-drop-role";
        this.createRole(roleName);
        sentryStore.dropSentryRole(roleName);
        this.checkRoleDoesNotExist(roleName);
    }

    @Test
    public void testAddDeleteGroupsNonExistantRole() throws Exception {
        String roleName = "non-existant-role";
        String grantor = "g1";
        HashSet groups = Sets.newHashSet();
        HashSet users = Sets.newHashSet((Object[])new String[]{grantor});
        try {
            sentryStore.alterSentryRoleAddGroups(grantor, roleName, (Set)groups);
            TestSentryStore.fail((String)"Expected SentryNoSuchObjectException exception");
        }
        catch (SentryNoSuchObjectException sentryNoSuchObjectException) {
            // empty catch block
        }
        try {
            sentryStore.alterSentryRoleAddUsers(roleName, (Set)users);
            TestSentryStore.fail((String)"Expected SentryNoSuchObjectException exception");
        }
        catch (SentryNoSuchObjectException sentryNoSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testAddDeleteGroups() throws Exception {
        String roleName = "test-groups";
        String grantor = "g1";
        this.createRole(roleName);
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName("test-groups-g1");
        groups.add(group);
        group = new TSentryGroup();
        group.setGroupName("test-groups-g2");
        groups.add(group);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, (Set)groups);
        sentryStore.alterSentryRoleDeleteGroups(roleName, (Set)groups);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        TestSentryStore.assertEquals(Collections.emptySet(), (Object)role.getGroups());
    }

    @Test
    public void testAddDeleteUsers() throws Exception {
        String roleName = "test-users";
        this.createRole(roleName);
        HashSet users = Sets.newHashSet((Object[])new String[]{"test-user-u1", "test-user-u2"});
        sentryStore.alterSentryRoleAddUsers(roleName, (Set)users);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        role.getUsers().size();
        sentryStore.alterSentryRoleDeleteUsers(roleName, (Set)users);
        role = sentryStore.getMSentryRoleByName(roleName);
        TestSentryStore.assertEquals((long)0L, (long)role.getUsers().size());
    }

    @Test
    public void testGetTSentryRolesForUser() throws Exception {
        String roleName1 = "r1";
        String roleName2 = "r2";
        String roleName3 = "r3";
        String user1 = "u1";
        String user2 = "u2";
        String user3 = "u3";
        String user4 = "u4";
        String group1 = "group1";
        String group2 = "group2";
        String group3 = "group3";
        HashMap userToGroups = Maps.newHashMap();
        userToGroups.put(user1, Sets.newHashSet((Object[])new String[]{group1}));
        userToGroups.put(user2, Sets.newHashSet((Object[])new String[]{group1}));
        userToGroups.put(user3, Sets.newHashSet((Object[])new String[]{group1, group2}));
        userToGroups.put(user4, Sets.newHashSet((Object[])new String[]{group2, group3}));
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        sentryStore.createSentryRole(roleName3);
        sentryStore.alterSentryRoleAddUsers(roleName1, (Set)Sets.newHashSet((Object[])new String[]{user1}));
        sentryStore.alterSentryRoleAddUsers(roleName2, (Set)Sets.newHashSet((Object[])new String[]{user2}));
        sentryStore.alterSentryRoleAddUsers(roleName2, (Set)Sets.newHashSet((Object[])new String[]{user3}));
        sentryStore.alterSentryRoleAddUsers(roleName3, (Set)Sets.newHashSet((Object[])new String[]{user2, user4}));
        Set roles = sentryStore.getTSentryRolesByUserNames((Set)Sets.newHashSet((Object[])new String[]{user1}));
        TestSentryStore.assertEquals((long)1L, (long)roles.size());
        for (TSentryRole role : roles) {
            TestSentryStore.assertTrue((boolean)roleName1.equals(role.getRoleName()));
        }
        roles = sentryStore.getTSentryRolesByUserNames((Set)Sets.newHashSet((Object[])new String[]{user2}));
        TestSentryStore.assertEquals((long)2L, (long)roles.size());
        for (TSentryRole role : roles) {
            TestSentryStore.assertTrue((roleName2.equals(role.getRoleName()) || roleName3.equals(role.getRoleName()) ? 1 : 0) != 0);
        }
        roles = sentryStore.getTSentryRolesByUserNames((Set)Sets.newHashSet((Object[])new String[]{user3}));
        TestSentryStore.assertEquals((long)1L, (long)roles.size());
        for (TSentryRole role : roles) {
            TestSentryStore.assertTrue((boolean)roleName2.equals(role.getRoleName()));
        }
        roles = sentryStore.getTSentryRolesByUserNames((Set)Sets.newHashSet((Object[])new String[]{user4}));
        TestSentryStore.assertEquals((long)1L, (long)roles.size());
        for (TSentryRole role : roles) {
            TestSentryStore.assertTrue((boolean)roleName3.equals(role.getRoleName()));
        }
    }

    @Test
    public void testGetTSentryRolesForUsers() throws Exception {
        String roleName1 = "r1";
        String roleName2 = "r2";
        String roleName3 = "r3";
        String user1 = "u1";
        String user2 = "u2";
        String user3 = "u3";
        String user4 = "u4";
        this.createRole(roleName1);
        this.createRole(roleName2);
        this.createRole(roleName3);
        sentryStore.alterSentryRoleAddUsers(roleName1, (Set)Sets.newHashSet((Object[])new String[]{user1}));
        sentryStore.alterSentryRoleAddUsers(roleName2, (Set)Sets.newHashSet((Object[])new String[]{user3}));
        sentryStore.alterSentryRoleAddUsers(roleName2, (Set)Sets.newHashSet((Object[])new String[]{user4}));
        sentryStore.alterSentryRoleAddUsers(roleName3, (Set)Sets.newHashSet((Object[])new String[]{user2, user4}));
        HashSet userSet1 = Sets.newHashSet((Object[])new String[]{user1, user2, user3});
        HashSet roleSet1 = Sets.newHashSet((Object[])new String[]{roleName1, roleName2, roleName3});
        HashSet userSet2 = Sets.newHashSet((Object[])new String[]{user4});
        HashSet roleSet2 = Sets.newHashSet((Object[])new String[]{roleName2, roleName3});
        HashSet userSet3 = Sets.newHashSet((Object[])new String[]{"foo"});
        HashSet roleSet3 = Sets.newHashSet();
        Set<String> roles = this.convertToRoleNameSet(sentryStore.getTSentryRolesByUserNames((Set)userSet1));
        TestSentryStore.assertEquals((String)"Returned roles should match the expected roles", (long)0L, (long)Sets.symmetricDifference(roles, (Set)roleSet1).size());
        roles = this.convertToRoleNameSet(sentryStore.getTSentryRolesByUserNames((Set)userSet2));
        TestSentryStore.assertEquals((String)"Returned roles should match the expected roles", (long)0L, (long)Sets.symmetricDifference(roles, (Set)roleSet2).size());
        roles = this.convertToRoleNameSet(sentryStore.getTSentryRolesByUserNames((Set)userSet3));
        TestSentryStore.assertEquals((String)"Returned roles should match the expected roles", (long)0L, (long)Sets.symmetricDifference(roles, (Set)roleSet3).size());
    }

    private Set<String> convertToRoleNameSet(Set<TSentryRole> tSentryRoles) {
        HashSet roleNameSet = Sets.newHashSet();
        for (TSentryRole role : tSentryRoles) {
            roleNameSet.add(role.getRoleName());
        }
        return roleNameSet;
    }

    @Test
    public void testGetTSentryRolesForGroups() throws Exception {
        String grantor = "g1";
        String roleName1 = "r1";
        String roleName2 = "r2";
        String roleName3 = "r3";
        String group1 = "group1";
        String group2 = "group2";
        String group3 = "group3";
        this.createRole(roleName1);
        this.createRole(roleName2);
        this.createRole(roleName3);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group1)}));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName2, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group2), new TSentryGroup(group3)}));
        HashSet groupSet1 = Sets.newHashSet((Object[])new String[]{group1, group2, group3});
        HashSet roleSet1 = Sets.newHashSet((Object[])new String[]{roleName1, roleName2});
        HashSet groupSet2 = Sets.newHashSet((Object[])new String[]{group1});
        HashSet roleSet2 = Sets.newHashSet((Object[])new String[]{roleName1});
        HashSet groupSet3 = Sets.newHashSet((Object[])new String[]{"foo"});
        HashSet roleSet3 = Sets.newHashSet();
        Set roles = sentryStore.getRoleNamesForGroups((Set)groupSet1);
        TestSentryStore.assertEquals((String)"Returned roles should match the expected roles", (long)0L, (long)Sets.symmetricDifference((Set)roles, (Set)roleSet1).size());
        roles = sentryStore.getRoleNamesForGroups((Set)groupSet2);
        TestSentryStore.assertEquals((String)"Returned roles should match the expected roles", (long)0L, (long)Sets.symmetricDifference((Set)roles, (Set)roleSet2).size());
        roles = sentryStore.getRoleNamesForGroups((Set)groupSet3);
        TestSentryStore.assertEquals((String)"Returned roles should match the expected roles", (long)0L, (long)Sets.symmetricDifference((Set)roles, (Set)roleSet3).size());
    }

    @Test
    public void testGrantRevokePrivilege() throws Exception {
        String roleName = "test-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        this.createRole(roleName);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        privilege.setAction("select");
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        TestSentryStore.assertEquals((Object)server, (Object)mPrivilege.getServerName());
        TestSentryStore.assertEquals((Object)db, (Object)mPrivilege.getDbName());
        TestSentryStore.assertEquals((Object)table, (Object)mPrivilege.getTableName());
        TestSentryStore.assertEquals((Object)"insert", (Object)mPrivilege.getAction());
        TestSentryStore.assertFalse((boolean)mPrivilege.getGrantOption());
        long numDBPrivs = sentryStore.countMSentryPrivileges();
        TestSentryStore.assertEquals((String)"Privilege count", (long)numDBPrivs, (long)1L);
    }

    private void verifyOrphanCleanup() throws Exception {
        TestSentryStore.assertFalse((String)"Failed to cleanup orphaned privileges", (boolean)sentryStore.findOrphanedPrivileges());
    }

    @Test
    public void testPrivilegeCleanup() throws Exception {
        String roleName = "test-priv-cleanup";
        String grantor = "g1";
        String server = "server";
        String dBase = "db";
        String table = "table-";
        this.createRole("test-priv-cleanup");
        int i = 0;
        while ((long)i < 5L) {
            TSentryPrivilege priv = new TSentryPrivilege();
            priv.setPrivilegeScope("TABLE");
            priv.setServerName("server");
            priv.setAction("*");
            priv.setCreateTime(System.currentTimeMillis());
            priv.setTableName("table-" + i);
            priv.setDbName("db");
            sentryStore.alterSentryRoleGrantPrivilege("g1", "test-priv-cleanup", priv);
            ++i;
        }
        TestSentryStore.assertEquals((long)sentryStore.countMSentryPrivileges(), (long)5L);
        sentryStore.dropSentryRole("test-priv-cleanup");
        this.verifyOrphanCleanup();
        List list = sentryStore.getAllMSentryPrivileges();
        TestSentryStore.assertEquals((long)list.size(), (long)0L);
    }

    @Test
    public void testPrivilegeCleanup2() throws Exception {
        String roleName = "test-priv-cleanup";
        String grantor = "g1";
        String server = "server";
        String dBase = "db";
        String table = "table-";
        this.createRole("test-priv-cleanup");
        int i = 0;
        while ((long)i < 5L) {
            TSentryPrivilege priv = new TSentryPrivilege();
            priv.setPrivilegeScope("DATABASE");
            priv.setServerName("server");
            priv.setAction("*");
            priv.setCreateTime(System.currentTimeMillis());
            priv.setTableName("table-" + i);
            priv.setDbName("db");
            priv.setGrantOption(TSentryGrantOption.TRUE);
            sentryStore.alterSentryRoleGrantPrivilege("g1", "test-priv-cleanup", priv);
            priv.setAction("select");
            priv.setGrantOption(TSentryGrantOption.UNSET);
            sentryStore.alterSentryRoleRevokePrivilege("g1", "test-priv-cleanup", priv);
            MSentryRole role = sentryStore.getMSentryRoleByName("test-priv-cleanup");
            Set privileges = role.getPrivileges();
            TestSentryStore.assertEquals((String)privileges.toString(), (long)(i + 1), (long)privileges.size());
            MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
            TestSentryStore.assertEquals((Object)"insert", (Object)mPrivilege.getAction());
            ++i;
        }
        sentryStore.dropSentryRole("test-priv-cleanup");
        this.verifyOrphanCleanup();
        List list = sentryStore.getAllMSentryPrivileges();
        TestSentryStore.assertEquals((long)list.size(), (long)0L);
    }

    @Test
    public void testPrivilegeCleanup3() throws Exception {
        String roleName = "test-priv-cleanup";
        String grantor = "g1";
        String server = "server";
        String dBase = "db";
        String table = "table-";
        this.createRole("test-priv-cleanup");
        int i = 0;
        while ((long)i < 5L) {
            TSentryPrivilege priv = new TSentryPrivilege();
            priv.setPrivilegeScope("DATABASE");
            priv.setServerName("server");
            priv.setAction("*");
            priv.setCreateTime(System.currentTimeMillis());
            priv.setTableName("table-" + i);
            priv.setDbName("db");
            priv.setGrantOption(TSentryGrantOption.TRUE);
            sentryStore.alterSentryRoleGrantPrivilege("g1", "test-priv-cleanup", priv);
            priv.setAction("select");
            priv.setGrantOption(TSentryGrantOption.UNSET);
            sentryStore.alterSentryRoleRevokePrivilege("g1", "test-priv-cleanup", priv);
            sentryStore.findOrphanedPrivileges();
            priv.setAction("insert");
            sentryStore.alterSentryRoleRevokePrivilege("g1", "test-priv-cleanup", priv);
            MSentryRole role = sentryStore.getMSentryRoleByName("test-priv-cleanup");
            TestSentryStore.assertEquals((String)"Privilege Count", (long)0L, (long)role.getPrivileges().size());
            ++i;
        }
        this.verifyOrphanCleanup();
        List list = sentryStore.getAllMSentryPrivileges();
        TestSentryStore.assertEquals((long)list.size(), (long)0L);
    }

    @Test
    public void testPrivilegeCleanup4() throws Exception {
        String roleName = "test-priv-cleanup";
        String grantor = "g1";
        String server = "server";
        String dBase = "db";
        String table = "table-";
        this.createRole("test-priv-cleanup");
        int i = 0;
        while ((long)i < 5L) {
            TSentryPrivilege priv = new TSentryPrivilege();
            priv.setPrivilegeScope("TABLE");
            priv.setServerName("server");
            priv.setAction("*");
            priv.setCreateTime(System.currentTimeMillis());
            priv.setTableName("table-" + i);
            priv.setDbName("db");
            sentryStore.alterSentryRoleGrantPrivilege("g1", "test-priv-cleanup", priv);
            ++i;
        }
        TestSentryStore.assertEquals((long)sentryStore.countMSentryPrivileges(), (long)5L);
        TSentryPrivilege priv = new TSentryPrivilege();
        priv.setPrivilegeScope("TABLE");
        priv.setServerName("server");
        priv.setAction("insert");
        priv.setCreateTime(System.currentTimeMillis());
        priv.setTableName("table-0");
        priv.setDbName("db");
        sentryStore.alterSentryRoleRevokePrivilege("g1", "test-priv-cleanup", priv);
        priv = new TSentryPrivilege();
        priv.setPrivilegeScope("TABLE");
        priv.setServerName("server");
        priv.setAction("select");
        priv.setCreateTime(System.currentTimeMillis());
        priv.setTableName("table-0");
        priv.setDbName("db");
        MSentryPrivilege mPriv = sentryStore.findMSentryPrivilegeFromTSentryPrivilege(priv);
        TestSentryStore.assertNotNull((Object)mPriv);
        MSentryRole role = sentryStore.getMSentryRoleByName("test-priv-cleanup");
        TestSentryStore.assertEquals((String)"Privilege Count", (long)5L, (long)role.getPrivileges().size());
        sentryStore.alterSentryRoleRevokePrivilege("g1", "test-priv-cleanup", priv);
        role = sentryStore.getMSentryRoleByName("test-priv-cleanup");
        TestSentryStore.assertEquals((String)"Privilege Count", (long)4L, (long)role.getPrivileges().size());
    }

    @Test
    public void testPrivilegeCleanup5() throws Exception {
        String roleName = "test-priv-cleanup";
        String grantor = "g1";
        String server = "server";
        String dBase = "db";
        String table = "table-";
        this.createRole("test-priv-cleanup");
        int i = 0;
        while ((long)i < 5L) {
            TSentryPrivilege priv = new TSentryPrivilege();
            priv.setPrivilegeScope("DATABASE");
            priv.setServerName("server");
            priv.setAction("alter");
            priv.setCreateTime(System.currentTimeMillis());
            priv.setTableName("table-" + i);
            priv.setDbName("db");
            priv.setGrantOption(TSentryGrantOption.TRUE);
            sentryStore.alterSentryRoleGrantPrivilege("g1", "test-priv-cleanup", priv);
            priv.setAction("alter");
            sentryStore.alterSentryRoleRevokePrivilege("g1", "test-priv-cleanup", priv);
            MSentryRole role = sentryStore.getMSentryRoleByName("test-priv-cleanup");
            TestSentryStore.assertEquals((String)"Privilege Count", (long)0L, (long)role.getPrivileges().size());
            ++i;
        }
        List list = sentryStore.getAllMSentryPrivileges();
        TestSentryStore.assertEquals((long)list.size(), (long)0L);
    }

    @Test
    public void testGrantRevokeMultiPrivileges() throws Exception {
        String roleName = "test-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String[] columns = new String[]{"c1", "c2", "c3", "c4"};
        this.createRole(roleName);
        HashSet tPrivileges = Sets.newHashSet();
        for (String column : columns) {
            TSentryPrivilege privilege = new TSentryPrivilege();
            privilege.setPrivilegeScope("Column");
            privilege.setServerName(server);
            privilege.setDbName(db);
            privilege.setTableName(table);
            privilege.setColumnName(column);
            privilege.setAction("select");
            privilege.setCreateTime(System.currentTimeMillis());
            tPrivileges.add(privilege);
        }
        sentryStore.alterSentryRoleGrantPrivileges(grantor, roleName, (Set)tPrivileges);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)4L, (long)privileges.size());
        tPrivileges = Sets.newHashSet();
        for (int i = 0; i < 2; ++i) {
            TSentryPrivilege privilege = new TSentryPrivilege();
            privilege.setPrivilegeScope("Column");
            privilege.setServerName(server);
            privilege.setDbName(db);
            privilege.setTableName(table);
            privilege.setColumnName(columns[i]);
            privilege.setAction("select");
            privilege.setCreateTime(System.currentTimeMillis());
            tPrivileges.add(privilege);
        }
        sentryStore.alterSentryRoleRevokePrivileges(grantor, roleName, (Set)tPrivileges);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("Table");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("select");
        privilege.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)0L, (long)privileges.size());
    }

    @Test
    public void testGrantRevokePrivilegeWithColumn() throws Exception {
        String roleName = "test-col-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String column1 = "c1";
        String column2 = "c2";
        this.createRole(roleName);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("COLUMN");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setColumnName(column1);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        privilege.setColumnName(column2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        privilege.setAction("select");
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        for (MSentryPrivilege mPrivilege : privileges) {
            TestSentryStore.assertEquals((Object)server, (Object)mPrivilege.getServerName());
            TestSentryStore.assertEquals((Object)db, (Object)mPrivilege.getDbName());
            TestSentryStore.assertEquals((Object)table, (Object)mPrivilege.getTableName());
            TestSentryStore.assertFalse((boolean)mPrivilege.getGrantOption());
            if (mPrivilege.getColumnName().equals(column1)) {
                TestSentryStore.assertEquals((Object)"*", (Object)mPrivilege.getAction());
                continue;
            }
            if (mPrivilege.getColumnName().equals(column2)) {
                TestSentryStore.assertEquals((Object)"insert", (Object)mPrivilege.getAction());
                continue;
            }
            TestSentryStore.fail((String)("Unexpected column name: " + mPrivilege.getColumnName()));
        }
        privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("insert");
        privilege.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        TestSentryStore.assertEquals((Object)column1, (Object)((MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0)).getColumnName());
        TestSentryStore.assertEquals((Object)"select", (Object)((MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0)).getAction());
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)0L, (long)privileges.size());
    }

    @Test
    public void testGrantRevokeTablePrivilegeDowngradeByDb() throws Exception {
        String roleName = "test-table-db-downgrade-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        this.createRole(roleName);
        TSentryPrivilege privilegeTable1 = new TSentryPrivilege();
        privilegeTable1.setPrivilegeScope("TABLE");
        privilegeTable1.setServerName(server);
        privilegeTable1.setDbName(db);
        privilegeTable1.setTableName(table1);
        privilegeTable1.setAction("*");
        privilegeTable1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilegeTable2 = privilegeTable1.deepCopy();
        privilegeTable2.setTableName(table2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeTable1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeTable2);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        privilegeTable2.setAction("select");
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeTable2);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        for (MSentryPrivilege mPrivilege : privileges) {
            TestSentryStore.assertEquals((Object)server, (Object)mPrivilege.getServerName());
            TestSentryStore.assertEquals((Object)db, (Object)mPrivilege.getDbName());
            TestSentryStore.assertFalse((boolean)mPrivilege.getGrantOption());
            if (mPrivilege.getTableName().equals(table1)) {
                TestSentryStore.assertEquals((Object)"*", (Object)mPrivilege.getAction());
                continue;
            }
            if (mPrivilege.getTableName().equals(table2)) {
                TestSentryStore.assertEquals((Object)"insert", (Object)mPrivilege.getAction());
                continue;
            }
            TestSentryStore.fail((String)("Unexpected table name: " + mPrivilege.getTableName()));
        }
        privilegeTable2.setAction("insert");
        privilegeTable2.setPrivilegeScope("DATABASE");
        privilegeTable2.unsetTableName();
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeTable2);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        TestSentryStore.assertEquals((Object)server, (Object)mPrivilege.getServerName());
        TestSentryStore.assertEquals((Object)db, (Object)mPrivilege.getDbName());
        TestSentryStore.assertEquals((Object)table1, (Object)mPrivilege.getTableName());
        TestSentryStore.assertEquals((Object)"select", (Object)mPrivilege.getAction());
        TestSentryStore.assertFalse((boolean)mPrivilege.getGrantOption());
    }

    @Test
    public void testGrantRevokeColumnPrivilegeDowngradeByDb() throws Exception {
        String roleName = "test-column-db-downgrade-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String column1 = "c1";
        String column2 = "c2";
        this.createRole(roleName);
        TSentryPrivilege privilegeCol1 = new TSentryPrivilege();
        privilegeCol1.setPrivilegeScope("COLUMN");
        privilegeCol1.setServerName(server);
        privilegeCol1.setDbName(db);
        privilegeCol1.setTableName(table);
        privilegeCol1.setColumnName(column1);
        privilegeCol1.setAction("*");
        privilegeCol1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilegeCol2 = privilegeCol1.deepCopy();
        privilegeCol2.setColumnName(column2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeCol1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeCol2);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        privilegeCol2.setAction("select");
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeCol2);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)2L, (long)privileges.size());
        for (MSentryPrivilege mPrivilege : privileges) {
            TestSentryStore.assertEquals((Object)server, (Object)mPrivilege.getServerName());
            TestSentryStore.assertEquals((Object)db, (Object)mPrivilege.getDbName());
            TestSentryStore.assertEquals((Object)table, (Object)mPrivilege.getTableName());
            TestSentryStore.assertFalse((boolean)mPrivilege.getGrantOption());
            if (mPrivilege.getColumnName().equals(column1)) {
                TestSentryStore.assertEquals((Object)"*", (Object)mPrivilege.getAction());
                continue;
            }
            if (mPrivilege.getColumnName().equals(column2)) {
                TestSentryStore.assertEquals((Object)"insert", (Object)mPrivilege.getAction());
                continue;
            }
            TestSentryStore.fail((String)("Unexpected column name: " + mPrivilege.getColumnName()));
        }
        privilegeCol2.setAction("insert");
        privilegeCol2.setPrivilegeScope("DATABASE");
        privilegeCol2.unsetTableName();
        privilegeCol2.unsetColumnName();
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeCol2);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        TestSentryStore.assertEquals((Object)server, (Object)mPrivilege.getServerName());
        TestSentryStore.assertEquals((Object)db, (Object)mPrivilege.getDbName());
        TestSentryStore.assertEquals((Object)table, (Object)mPrivilege.getTableName());
        TestSentryStore.assertEquals((Object)column1, (Object)mPrivilege.getColumnName());
        TestSentryStore.assertEquals((Object)"select", (Object)mPrivilege.getAction());
        TestSentryStore.assertFalse((boolean)mPrivilege.getGrantOption());
    }

    @Test
    public void testGrantRevokePrivilegeWithGrantOption() throws Exception {
        String roleName = "test-grantOption-table";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        TSentryGrantOption grantOption = TSentryGrantOption.TRUE;
        this.createRole(roleName);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(grantOption);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        TestSentryStore.assertEquals((Object)Boolean.valueOf(privilege.getGrantOption().toString()), (Object)((MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0)).getGrantOption());
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((long)0L, (long)privileges.size());
        roleName = "test-grantOption-db";
        this.createRole(roleName);
        privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("DATABASE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setAction("*");
        privilege.setGrantOption(TSentryGrantOption.TRUE);
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(grantOption);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        privilege.setAction("select");
        privilege.setGrantOption(TSentryGrantOption.UNSET);
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        TestSentryStore.assertEquals((Object)server, (Object)mPrivilege.getServerName());
        TestSentryStore.assertEquals((Object)db, (Object)mPrivilege.getDbName());
        TestSentryStore.assertEquals((Object)"insert", (Object)mPrivilege.getAction());
    }

    @Test
    public void testGrantCheckWithGroupAndUser() throws Exception {
        String grantor = "g1";
        String[][] users = new String[][]{{"user0_0", "user0_1"}, {"user1_0", "user1_1"}};
        String[] groups = new String[]{"group0", "group1"};
        String[] rolesForGroup = new String[]{"roleG0", "roleG1"};
        String[] rolesForUser = new String[]{"roleU0", "roleU1", "roleU2", "roleU3"};
        for (int i = 0; i < groups.length; ++i) {
            for (int j = 0; j < users[i].length; ++j) {
                TestSentryStore.addGroupsToUser(users[i][j], groups[i]);
                sentryStore.createSentryRole(rolesForUser[i * 2 + j]);
                sentryStore.alterSentryRoleAddUsers(rolesForUser[i * 2 + j], (Set)Sets.newHashSet((Object[])new String[]{users[i][j]}));
            }
            sentryStore.createSentryRole(rolesForGroup[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, rolesForGroup[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        grantor = "g1";
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("DATABASE");
        privilege1.setServerName(server);
        privilege1.setDbName(db);
        privilege1.setAction("*");
        privilege1.setCreateTime(System.currentTimeMillis());
        privilege1.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, "roleG0", privilege1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, "roleU0", privilege1);
        try {
            sentryStore.alterSentryRoleGrantPrivilege("user0_0", "roleG1", privilege1);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        try {
            sentryStore.alterSentryRoleRevokePrivilege("user0_0", "roleG1", privilege1);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("DATABASE");
        privilege2.setServerName(server);
        privilege2.setDbName(db);
        privilege2.setAction("*");
        privilege2.setCreateTime(System.currentTimeMillis());
        privilege2.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, "roleG0", privilege2);
        sentryStore.alterSentryRoleGrantPrivilege("user0_0", "roleG1", privilege2);
        this.validatePrivilegeByRoleName("roleG1", privilege2);
        sentryStore.alterSentryRoleRevokePrivilege("user0_0", "roleG1", privilege2);
        this.validateEmptyPrivilegeByRoleName("roleG1");
        sentryStore.alterSentryRoleGrantPrivilege("user0_1", "roleG1", privilege2);
        this.validatePrivilegeByRoleName("roleG1", privilege2);
        sentryStore.alterSentryRoleRevokePrivilege("user0_1", "roleG1", privilege2);
        this.validateEmptyPrivilegeByRoleName("roleG1");
        sentryStore.alterSentryRoleRevokePrivilege(grantor, "roleG0", privilege2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, "roleU0", privilege2);
        sentryStore.alterSentryRoleGrantPrivilege("user0_0", "roleG1", privilege2);
        this.validatePrivilegeByRoleName("roleG1", privilege2);
        sentryStore.alterSentryRoleRevokePrivilege("user0_0", "roleG1", privilege2);
        this.validateEmptyPrivilegeByRoleName("roleG1");
        try {
            sentryStore.alterSentryRoleGrantPrivilege("user0_1", "roleG1", privilege2);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        try {
            sentryStore.alterSentryRoleRevokePrivilege("user0_1", "roleG1", privilege2);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        sentryStore.alterSentryRoleRevokePrivilege(grantor, "roleU0", privilege2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, "roleU2", privilege2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, "roleG0", privilege2);
        sentryStore.alterSentryRoleGrantPrivilege("user0_0", "roleG1", privilege2);
        this.validatePrivilegeByRoleName("roleG1", privilege2);
        sentryStore.alterSentryRoleRevokePrivilege("user0_0", "roleG1", privilege2);
        this.validateEmptyPrivilegeByRoleName("roleG1");
        sentryStore.alterSentryRoleGrantPrivilege("user0_1", "roleG1", privilege2);
        this.validatePrivilegeByRoleName("roleG1", privilege2);
        sentryStore.alterSentryRoleRevokePrivilege("user0_1", "roleG1", privilege2);
        this.validateEmptyPrivilegeByRoleName("roleG1");
        sentryStore.alterSentryRoleGrantPrivilege("user1_0", "roleG1", privilege2);
        this.validatePrivilegeByRoleName("roleG1", privilege2);
        sentryStore.alterSentryRoleRevokePrivilege("user1_0", "roleG1", privilege2);
        this.validateEmptyPrivilegeByRoleName("roleG1");
        try {
            sentryStore.alterSentryRoleGrantPrivilege("user1_1", "roleG1", privilege2);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        try {
            sentryStore.alterSentryRoleRevokePrivilege("user1_1", "roleG1", privilege2);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        sentryStore.alterSentryRoleRevokePrivilege(grantor, "roleG0", privilege2);
        sentryStore.alterSentryRoleRevokePrivilege(grantor, "roleU2", privilege2);
    }

    private void validatePrivilegeByRoleName(String roleName, TSentryPrivilege exceptedTPrivelege) throws Exception {
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        TestSentryStore.assertEquals((Object)exceptedTPrivelege.getServerName(), (Object)mPrivilege.getServerName());
        TestSentryStore.assertEquals((Object)exceptedTPrivelege.getDbName(), (Object)mPrivilege.getDbName());
        TestSentryStore.assertEquals((Object)"*", (Object)mPrivilege.getAction());
    }

    private void validateEmptyPrivilegeByRoleName(String roleName) throws Exception {
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)0L, (long)privileges.size());
    }

    @Test
    public void testGrantCheckWithGrantOption() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0", "user1", "user2", "user3", "user4"};
        String[] groups = new String[]{"group0", "group1", "group2", "group3", "group4"};
        String[] roles = new String[]{"role0", "role1", "role2", "role3", "role4"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("DATABASE");
        privilege1.setServerName(server);
        privilege1.setDbName(db);
        privilege1.setAction("*");
        privilege1.setCreateTime(System.currentTimeMillis());
        privilege1.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege1);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        roleName = roles[1];
        grantor = users[0];
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("DATABASE");
        privilege2.setServerName(server);
        privilege2.setDbName(db);
        privilege2.setAction("select");
        privilege2.setCreateTime(System.currentTimeMillis());
        privilege2.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege2);
        roleName = roles[2];
        grantor = users[0];
        TSentryPrivilege privilege3 = new TSentryPrivilege();
        privilege3.setPrivilegeScope("TABLE");
        privilege3.setServerName(server);
        privilege3.setDbName(db);
        privilege3.setTableName(table);
        privilege3.setAction("*");
        privilege3.setCreateTime(System.currentTimeMillis());
        privilege3.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege3);
        roleName = roles[3];
        grantor = users[1];
        TSentryPrivilege privilege4 = new TSentryPrivilege();
        privilege4.setPrivilegeScope("DATABASE");
        privilege4.setServerName(server);
        privilege4.setDbName(db);
        privilege4.setAction("insert");
        privilege4.setCreateTime(System.currentTimeMillis());
        privilege4.setGrantOption(TSentryGrantOption.FALSE);
        try {
            sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege4);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        roleName = roles[4];
        grantor = users[2];
        TSentryPrivilege privilege5 = new TSentryPrivilege();
        privilege5.setPrivilegeScope("TABLE");
        privilege5.setServerName(server);
        privilege5.setDbName(db);
        privilege5.setTableName(table);
        privilege5.setAction("insert");
        privilege5.setCreateTime(System.currentTimeMillis());
        privilege5.setGrantOption(TSentryGrantOption.FALSE);
        try {
            sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege5);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testRevokeCheckWithGrantOption() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0", "user1", "user2"};
        String[] roles = new String[]{"role0", "role1", "role2"};
        String[] groups = new String[]{"group0", "group1", "group2"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
            sentryStore.alterSentryRoleAddUsers(roles[i], (Set)Sets.newHashSet((Object[])new String[]{users[i]}));
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("DATABASE");
        privilege1.setServerName(server);
        privilege1.setDbName(db);
        privilege1.setAction("select");
        privilege1.setCreateTime(System.currentTimeMillis());
        privilege1.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege1);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        roleName = roles[1];
        grantor = "g1";
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("TABLE");
        privilege2.setServerName(server);
        privilege2.setDbName(db);
        privilege2.setTableName(table);
        privilege2.setAction("*");
        privilege2.setCreateTime(System.currentTimeMillis());
        privilege2.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege2);
        roleName = roles[2];
        grantor = "g1";
        TSentryPrivilege privilege3 = new TSentryPrivilege();
        privilege3.setPrivilegeScope("TABLE");
        privilege3.setServerName(server);
        privilege3.setDbName(db);
        privilege3.setTableName(table);
        privilege3.setAction("select");
        privilege3.setCreateTime(System.currentTimeMillis());
        privilege3.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege3);
        roleName = roles[2];
        grantor = users[1];
        try {
            sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege3);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        roleName = roles[1];
        grantor = users[0];
        try {
            sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege2);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        roleName = roles[2];
        grantor = users[0];
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege3);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((long)0L, (long)privileges.size());
    }

    @Test
    public void testRevokeAllGrantOption() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0"};
        String[] roles = new String[]{"role0"};
        String[] groups = new String[]{"group0"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("select");
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        roleName = roles[0];
        grantor = "g1";
        privilege.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        roleName = roles[0];
        grantor = "g1";
        privilege.setGrantOption(TSentryGrantOption.UNSET);
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)0L, (long)privileges.size());
    }

    @Test
    public void testGrantCheckWithColumn() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0", "user1"};
        String[] roles = new String[]{"role0", "role1"};
        String[] groups = new String[]{"group0", "group1"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("TABLE");
        privilege1.setServerName(server);
        privilege1.setDbName(db);
        privilege1.setTableName(table);
        privilege1.setAction("select");
        privilege1.setCreateTime(System.currentTimeMillis());
        privilege1.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege1);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        roleName = roles[1];
        grantor = users[0];
        String column = "c1";
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("COLUMN");
        privilege2.setServerName(server);
        privilege2.setDbName(db);
        privilege2.setTableName(table);
        privilege2.setColumnName(column);
        privilege2.setAction("select");
        privilege2.setCreateTime(System.currentTimeMillis());
        privilege2.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege2);
        roleName = roles[0];
        grantor = users[1];
        try {
            sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege1);
            TestSentryStore.fail((String)"Expected SentryGrantDeniedException exception");
        }
        catch (SentryGrantDeniedException sentryGrantDeniedException) {
            // empty catch block
        }
        roleName = roles[1];
        grantor = users[0];
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege2);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((long)0L, (long)privileges.size());
    }

    @Test
    public void testGrantDuplicatePrivilege() throws Exception {
        String roleName = "test-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        this.createRole(roleName);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        privilege.setServerName("Server1");
        privilege.setDbName("DB1");
        privilege.setTableName("TBL1");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
    }

    @Test
    public void testListSentryPrivilegesForProvider() throws Exception {
        String roleName1 = "list-privs-r1";
        String roleName2 = "list-privs-r2";
        String groupName1 = "list-privs-g1";
        String groupName2 = "list-privs-g2";
        String userName1 = "list-privs-u1";
        String userName2 = "list-privs-u2";
        String userWithoutRole = "user-no-privs";
        HashSet noRoleUsers = Sets.newHashSet((Object[])new String[]{userWithoutRole});
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("TABLE");
        privilege1.setServerName("server1");
        privilege1.setDbName("db1");
        privilege1.setTableName("tbl1");
        privilege1.setAction("SELECT");
        privilege1.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege1);
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("SERVER");
        privilege2.setServerName("server1");
        privilege2.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege2);
        HashSet groups = Sets.newHashSet();
        HashSet users = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(groupName1);
        groups.add(group);
        users.add(userName1);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)groups);
        sentryStore.alterSentryRoleAddUsers(roleName1, (Set)users);
        groups.clear();
        users.clear();
        group = new TSentryGroup();
        group.setGroupName(groupName2);
        groups.add(group);
        users.add(userName2);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)groups);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName2, (Set)groups);
        sentryStore.alterSentryRoleAddUsers(roleName1, (Set)users);
        sentryStore.alterSentryRoleAddUsers(roleName2, (Set)users);
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), (Set)noRoleUsers, new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{""}), (Set)Sets.newHashSet((Object[])new String[]{userName1}), new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), (Set)Sets.newHashSet((Object[])new String[]{userName1}), new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName1})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{"not a role"})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), (Set)Sets.newHashSet((Object[])new String[]{""}), new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{""}), (Set)Sets.newHashSet((Object[])new String[]{userName2}), new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), (Set)Sets.newHashSet((Object[])new String[]{userName2}), new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName1})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName2})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{"not a role"})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), (Set)Sets.newHashSet((Object[])new String[]{userName1, userName2}), new TSentryActiveRoleSet(true, new HashSet()))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName1})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName2})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{"not a role"})))));
        TestSentryStore.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), (Set)noRoleUsers, new TSentryActiveRoleSet(false, new HashSet()))));
    }

    @Test
    public void testListRole() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String roleName3 = "role3";
        String group1 = "group1";
        String group2 = "group2";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        sentryStore.createSentryRole(roleName3);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group1)}));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName2, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group2)}));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName3, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group1), new TSentryGroup(group2)}));
        TestSentryStore.assertEquals((long)2L, (long)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{group1}), false).size());
        TestSentryStore.assertEquals((long)2L, (long)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{group2}), false).size());
        TestSentryStore.assertEquals((long)3L, (long)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{group1, group2}), false).size());
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{"foo"}), true).size());
    }

    @Test
    public void testDropDbObject() throws Exception {
        String roleName1 = "list-privs-r1";
        String roleName2 = "list-privs-r2";
        String roleName3 = "list-privs-r3";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        sentryStore.createSentryRole(roleName3);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName("tbl1");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege1 = new TSentryPrivilege(privilege_tbl1);
        privilege1.setAction("SELECT");
        TSentryPrivilege privilege2_1 = new TSentryPrivilege(privilege_tbl1);
        privilege2_1.setAction("INSERT");
        TSentryPrivilege privilege3_1 = new TSentryPrivilege(privilege_tbl1);
        privilege3_1.setAction("*");
        TSentryPrivilege privilege_server = new TSentryPrivilege();
        privilege_server.setPrivilegeScope("SERVER");
        privilege_server.setServerName("server1");
        privilege_server.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl2 = new TSentryPrivilege();
        privilege_tbl2.setPrivilegeScope("TABLE");
        privilege_tbl2.setServerName("server1");
        privilege_tbl2.setDbName("db1");
        privilege_tbl2.setTableName("tbl2");
        privilege_tbl2.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege2_3 = new TSentryPrivilege(privilege_tbl2);
        privilege2_3.setAction("SELECT");
        TSentryPrivilege privilege3_2 = new TSentryPrivilege(privilege_tbl2);
        privilege3_2.setAction("INSERT");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege2_1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_server);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege2_3);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName3, privilege3_1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName3, privilege3_2);
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl1));
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
        TestSentryStore.assertEquals((long)2L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName2).size());
        TestSentryStore.assertEquals((long)1L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName3).size());
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl2));
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
        TestSentryStore.assertEquals((long)1L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName2).size());
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName3).size());
    }

    @Test
    public void testDropTableWithMultiAction() throws Exception {
        String roleName1 = "role1";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName("tbl1");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("insert");
        TSentryPrivilege privilege_tbl1_select = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_select.setAction("select");
        TSentryPrivilege privilege_tbl1_alter = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_alter.setAction("alter");
        TSentryPrivilege privilege_tbl1_drop = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_drop.setAction("drop");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_select);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_alter);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_drop);
        TestSentryStore.assertEquals((long)4L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl1));
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
    }

    @Test
    public void testDropTableWithColumn() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String grantor = "g1";
        String table1 = "tbl1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setAction("select");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c1 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c1.setPrivilegeScope("COLUMN");
        privilege_tbl1_c1.setColumnName("c1");
        privilege_tbl1_c1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c2 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c2.setPrivilegeScope("COLUMN");
        privilege_tbl1_c2.setColumnName("c2");
        privilege_tbl1_c2.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c3 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c3.setPrivilegeScope("COLUMN");
        privilege_tbl1_c3.setColumnName("c3");
        privilege_tbl1_c3.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_tbl1_c3);
        Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        TestSentryStore.assertEquals((long)2L, (long)privilegeSet.size());
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        TestSentryStore.assertEquals((long)1L, (long)privilegeSet.size());
        TSentryAuthorizable tableAuthorizable = this.toTSentryAuthorizable(privilege_tbl1);
        sentryStore.dropPrivilege(tableAuthorizable);
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        TestSentryStore.assertEquals((long)0L, (long)privilegeSet.size());
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        TestSentryStore.assertEquals((long)0L, (long)privilegeSet.size());
    }

    @Test
    public void testDropOverlappedPrivileges() throws Exception {
        String roleName1 = "list-privs-r1";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName("tbl1");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("INSERT");
        TSentryPrivilege privilege_tbl1_all = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_all.setAction("*");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_all);
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl1));
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
    }

    private TSentryAuthorizable toTSentryAuthorizable(TSentryPrivilege tSentryPrivilege) {
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        tSentryAuthorizable.setServer(tSentryPrivilege.getServerName());
        tSentryAuthorizable.setDb(tSentryPrivilege.getDbName());
        tSentryAuthorizable.setTable(tSentryPrivilege.getTableName());
        tSentryAuthorizable.setUri(tSentryPrivilege.getURI());
        return tSentryAuthorizable;
    }

    @Test
    public void testRenameTable() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String roleName3 = "role3";
        String grantor = "g1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        sentryStore.createSentryRole(roleName3);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("insert");
        TSentryPrivilege privilege_tbl1_select = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_select.setAction("select");
        TSentryPrivilege privilege_tbl1_all = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_all.setAction("*");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_tbl1_select);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName3, privilege_tbl1_all);
        TSentryAuthorizable oldTable = this.toTSentryAuthorizable(privilege_tbl1);
        TSentryAuthorizable newTable = this.toTSentryAuthorizable(privilege_tbl1);
        newTable.setTable(table2);
        sentryStore.renamePrivilege(oldTable, newTable);
        for (String roleName : Sets.newHashSet((Object[])new String[]{roleName1, roleName2, roleName3})) {
            Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName);
            TestSentryStore.assertEquals((long)1L, (long)privilegeSet.size());
            for (TSentryPrivilege privilege : privilegeSet) {
                TestSentryStore.assertTrue((boolean)table2.equalsIgnoreCase(privilege.getTableName()));
            }
        }
    }

    @Test
    public void testRenameTableWithMultiAction() throws Exception {
        String roleName1 = "role1";
        String grantor = "g1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("insert");
        TSentryPrivilege privilege_tbl1_select = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_select.setAction("select");
        TSentryPrivilege privilege_tbl1_alter = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_alter.setAction("alter");
        TSentryPrivilege privilege_tbl1_drop = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_drop.setAction("drop");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_select);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_alter);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_drop);
        TSentryAuthorizable oldTable = this.toTSentryAuthorizable(privilege_tbl1);
        TSentryAuthorizable newTable = this.toTSentryAuthorizable(privilege_tbl1);
        newTable.setTable(table2);
        sentryStore.renamePrivilege(oldTable, newTable);
        Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        TestSentryStore.assertEquals((long)4L, (long)privilegeSet.size());
        for (TSentryPrivilege privilege : privilegeSet) {
            TestSentryStore.assertTrue((boolean)table2.equalsIgnoreCase(privilege.getTableName()));
        }
    }

    @Test
    public void testSentryRoleSize() throws Exception {
        for (long i = 0L; i < 5L; ++i) {
            TestSentryStore.assertEquals((Object)i, (Object)sentryStore.getRoleCountGauge().getValue());
            sentryStore.createSentryRole("role" + i);
        }
    }

    @Test
    public void testSentryPrivilegeSize() throws Exception {
        String role1 = "role1";
        String role2 = "role2";
        sentryStore.createSentryRole(role1);
        sentryStore.createSentryRole(role2);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName("server1");
        privilege.setDbName("db1");
        privilege.setTableName("tb1");
        privilege.setCreateTime(System.currentTimeMillis());
        String grantor = "g1";
        TestSentryStore.assertEquals((Object)0L, (Object)sentryStore.getPrivilegeCountGauge().getValue());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, role1, privilege);
        TestSentryStore.assertEquals((Object)1L, (Object)sentryStore.getPrivilegeCountGauge().getValue());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, role2, privilege);
        TestSentryStore.assertEquals((Object)1L, (Object)sentryStore.getPrivilegeCountGauge().getValue());
        privilege.setTableName("tb2");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, role2, privilege);
        TestSentryStore.assertEquals((Object)2L, (Object)sentryStore.getPrivilegeCountGauge().getValue());
    }

    @Test
    public void testSentryGroupsSize() throws Exception {
        String role1 = "role1";
        String role2 = "role2";
        sentryStore.createSentryRole(role1);
        sentryStore.createSentryRole(role2);
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName("group1");
        groups.add(group);
        String grantor = "g1";
        sentryStore.alterSentryRoleAddGroups(grantor, role1, (Set)groups);
        TestSentryStore.assertEquals((Object)1L, (Object)sentryStore.getGroupCountGauge().getValue());
        sentryStore.alterSentryRoleAddGroups(grantor, role2, (Set)groups);
        TestSentryStore.assertEquals((Object)1L, (Object)sentryStore.getGroupCountGauge().getValue());
        groups.add(new TSentryGroup("group2"));
        sentryStore.alterSentryRoleAddGroups(grantor, role2, (Set)groups);
        TestSentryStore.assertEquals((Object)2L, (Object)sentryStore.getGroupCountGauge().getValue());
    }

    @Test
    public void testSentryUsersSize() throws Exception {
        String role1 = "role1";
        String role2 = "role2";
        sentryStore.createSentryRole(role1);
        sentryStore.createSentryRole(role2);
        HashSet users = Sets.newHashSet((Object[])new String[]{"user1"});
        sentryStore.alterSentryRoleAddUsers(role1, (Set)users);
        TestSentryStore.assertEquals((Object)1L, (Object)sentryStore.getUserCountGauge().getValue());
        sentryStore.alterSentryRoleAddUsers(role2, (Set)users);
        TestSentryStore.assertEquals((Object)1L, (Object)sentryStore.getUserCountGauge().getValue());
        users.add("user2");
        sentryStore.alterSentryRoleAddUsers(role2, (Set)users);
        TestSentryStore.assertEquals((Object)2L, (Object)sentryStore.getUserCountGauge().getValue());
    }

    @Test
    public void testRenameTableWithColumn() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String grantor = "g1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setAction("select");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c1 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c1.setPrivilegeScope("COLUMN");
        privilege_tbl1_c1.setColumnName("c1");
        privilege_tbl1_c1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c2 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c2.setPrivilegeScope("COLUMN");
        privilege_tbl1_c2.setColumnName("c2");
        privilege_tbl1_c2.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c3 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c3.setPrivilegeScope("COLUMN");
        privilege_tbl1_c3.setColumnName("c3");
        privilege_tbl1_c3.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_tbl1_c3);
        Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        TestSentryStore.assertEquals((long)2L, (long)privilegeSet.size());
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        TestSentryStore.assertEquals((long)1L, (long)privilegeSet.size());
        TSentryAuthorizable oldTable = this.toTSentryAuthorizable(privilege_tbl1);
        TSentryAuthorizable newTable = this.toTSentryAuthorizable(privilege_tbl1);
        newTable.setTable(table2);
        sentryStore.renamePrivilege(oldTable, newTable);
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        TestSentryStore.assertEquals((long)2L, (long)privilegeSet.size());
        for (TSentryPrivilege privilege : privilegeSet) {
            TestSentryStore.assertTrue((boolean)table2.equalsIgnoreCase(privilege.getTableName()));
        }
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        TestSentryStore.assertEquals((long)1L, (long)privilegeSet.size());
    }

    @Test
    public void testSentryTablePrivilegeSome() throws Exception {
        String roleName = "test-table-privilege-some";
        String grantor = "g1";
        String dbName = "db1";
        String table = "tb1";
        this.createRole(roleName);
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege("TABLE", "server1", "ALL");
        tSentryPrivilege.setDbName(dbName);
        tSentryPrivilege.setTableName(table);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, tSentryPrivilege);
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        tSentryAuthorizable.setDb(dbName);
        tSentryAuthorizable.setTable("+");
        tSentryAuthorizable.setServer("server1");
        Set privileges = sentryStore.getTSentryPrivileges(new HashSet<String>(Arrays.asList(roleName)), tSentryAuthorizable);
        TestSentryStore.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
        HashSet<TSentryGroup> tSentryGroups = new HashSet<TSentryGroup>();
        tSentryGroups.add(new TSentryGroup("group1"));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, tSentryGroups);
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(true, new HashSet<String>(Arrays.asList(roleName)));
        Set privs = sentryStore.listSentryPrivilegesForProvider(new HashSet<String>(Arrays.asList("group1")), (Set)Sets.newHashSet((Object[])new String[]{grantor}), thriftRoleSet, tSentryAuthorizable);
        TestSentryStore.assertTrue((privs.size() == 1 ? 1 : 0) != 0);
        TestSentryStore.assertTrue((boolean)privs.contains("server=server1->db=" + dbName + "->table=" + table + "->action=all"));
    }

    @Test
    public void testSentryColumnPrivilegeSome() throws Exception {
        String roleName = "test-column-privilege-some";
        String grantor = "g1";
        String dbName = "db1";
        String table = "tb1";
        String column = "col1";
        this.createRole(roleName);
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege("TABLE", "server1", "ALL");
        tSentryPrivilege.setDbName(dbName);
        tSentryPrivilege.setTableName(table);
        tSentryPrivilege.setColumnName(column);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, tSentryPrivilege);
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        tSentryAuthorizable.setDb(dbName);
        tSentryAuthorizable.setTable(table);
        tSentryAuthorizable.setColumn("+");
        tSentryAuthorizable.setServer("server1");
        Set privileges = sentryStore.getTSentryPrivileges(new HashSet<String>(Arrays.asList(roleName)), tSentryAuthorizable);
        TestSentryStore.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
        HashSet<TSentryGroup> tSentryGroups = new HashSet<TSentryGroup>();
        tSentryGroups.add(new TSentryGroup("group1"));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, tSentryGroups);
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(true, new HashSet<String>(Arrays.asList(roleName)));
        Set privs = sentryStore.listSentryPrivilegesForProvider(new HashSet<String>(Arrays.asList("group1")), (Set)Sets.newHashSet((Object[])new String[]{grantor}), thriftRoleSet, tSentryAuthorizable);
        TestSentryStore.assertTrue((privs.size() == 1 ? 1 : 0) != 0);
        TestSentryStore.assertTrue((boolean)privs.contains("server=server1->db=" + dbName + "->table=" + table + "->column=" + column + "->action=all"));
    }

    @Test
    public void testSentryVersionCheck() throws Exception {
        sentryStore.verifySentryStoreSchema(false);
        TestSentryStore.assertEquals((Object)sentryStore.getSentryVersion(), (Object)SentryStoreSchemaInfo.getSentryVersion());
        sentryStore.verifySentryStoreSchema(true);
        sentryStore.setSentryVersion("test-version", "test-version");
        try {
            sentryStore.verifySentryStoreSchema(true);
            TestSentryStore.fail((String)"SentryAccessDeniedException should be thrown.");
        }
        catch (SentryAccessDeniedException e) {
            sentryStore.verifySentryStoreSchema(false);
        }
    }

    @Test
    public void testRetrieveFullPermssionsImage() throws Exception {
        String roleName1 = "privs-r1";
        String roleName2 = "privs-r2";
        String groupName1 = "privs-g1";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("TABLE");
        privilege1.setServerName("server1");
        privilege1.setDbName("db1");
        privilege1.setTableName("tbl1");
        privilege1.setAction("SELECT");
        privilege1.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege1);
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("SERVER");
        privilege2.setServerName("server1");
        privilege1.setDbName("db2");
        privilege1.setAction("ALL");
        privilege2.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege2);
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(groupName1);
        groups.add(group);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)groups);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName2, (Set)groups);
        PermissionsImage permImage = sentryStore.retrieveFullPermssionsImage();
        Map privs = permImage.getPrivilegeImage();
        Map roles = permImage.getRoleImage();
        TestSentryStore.assertEquals((long)2L, (long)((Map)privs.get("db1.tbl1")).size());
        TestSentryStore.assertEquals((long)2L, (long)roles.size());
    }

    @Test
    public void testPersistFullPathsImage() throws Exception {
        HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table1.1", "/user/hive/warehouse/db2.db/table1.2"}));
        authzPaths.put("db1.table2", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table2.1", "/user/hive/warehouse/db2.db/table2.2"}));
        authzPaths.put("db2.table2", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table2.1", "/user/hive/warehouse/db2.db/table2.3"}));
        long notificationID = 11L;
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        PathsImage pathsImage = sentryStore.retrieveFullPathsImage();
        long savedNotificationID = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)1L, (long)pathsImage.getCurImgNum());
        Map pathImage = pathsImage.getPathImage();
        TestSentryStore.assertEquals((long)3L, (long)pathImage.size());
        for (Map.Entry entry : pathImage.entrySet()) {
            TestSentryStore.assertEquals((long)2L, (long)((Collection)entry.getValue()).size());
        }
        TestSentryStore.assertEquals((long)2L, (long)((Collection)pathImage.get("db2.table2")).size());
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"/user/hive/warehouse/db2.db/table1.1", "/user/hive/warehouse/db2.db/table1.2"}), (Collection)((Collection)pathImage.get("db1.table1"))));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"/user/hive/warehouse/db2.db/table2.1", "/user/hive/warehouse/db2.db/table2.2"}), (Collection)((Collection)pathImage.get("db1.table2"))));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"/user/hive/warehouse/db2.db/table2.1", "/user/hive/warehouse/db2.db/table2.3"}), (Collection)((Collection)pathImage.get("db2.table2"))));
        TestSentryStore.assertEquals((long)6L, (long)sentryStore.getMPaths().size());
        TestSentryStore.assertEquals((long)notificationID, (long)savedNotificationID);
    }

    @Test
    public void testAddPathsWithDuplicatedNotificationIdShouldBeAllowed() throws Exception {
        long notificationID = 1L;
        sentryStore.persistFullPathsImage(new HashMap(), 0L);
        UniquePathsUpdate update1 = new UniquePathsUpdate("u1", notificationID, false);
        UniquePathsUpdate update2 = new UniquePathsUpdate("u2", notificationID, false);
        update1.newPathChange("db1").addToAddPaths(Arrays.asList("/hive/db1"));
        update2.newPathChange("db2").addToAddPaths(Arrays.asList("/hive/db2"));
        sentryStore.addAuthzPathsMapping("db1", Arrays.asList("/hive/db1"), update1);
        sentryStore.addAuthzPathsMapping("db2", Arrays.asList("/hive/db2"), update2);
        long latestID = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)notificationID, (long)latestID);
        Map pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
        TestSentryStore.assertEquals((long)1L, (long)((Collection)pathsImage.get("db1")).size());
        TestSentryStore.assertTrue((boolean)((Collection)pathsImage.get("db1")).contains("/hive/db1"));
        TestSentryStore.assertEquals((long)1L, (long)((Collection)pathsImage.get("db2")).size());
        TestSentryStore.assertTrue((boolean)((Collection)pathsImage.get("db2")).contains("/hive/db2"));
        List pathsChanges = sentryStore.getMSentryPathChanges();
        TestSentryStore.assertEquals((long)2L, (long)pathsChanges.size());
        TestSentryStore.assertEquals((long)1L, (long)((MSentryPathChange)pathsChanges.get(0)).getChangeID());
        TestSentryStore.assertTrue((boolean)((MSentryPathChange)pathsChanges.get(0)).getPathChange().contains("/hive/db1"));
        TestSentryStore.assertEquals((long)2L, (long)((MSentryPathChange)pathsChanges.get(1)).getChangeID());
        TestSentryStore.assertTrue((boolean)((MSentryPathChange)pathsChanges.get(1)).getPathChange().contains("/hive/db2"));
        TestSentryStore.assertEquals((Object)"u1", (Object)((MSentryPathChange)pathsChanges.get(0)).getNotificationHash());
        TestSentryStore.assertEquals((Object)"u2", (Object)((MSentryPathChange)pathsChanges.get(1)).getNotificationHash());
    }

    @Test
    public void testPersistDuplicatedNotificationIdShouldBeAllowed() throws Exception {
        long notificationID = 1L;
        sentryStore.persistLastProcessedNotificationID(Long.valueOf(notificationID));
        sentryStore.persistLastProcessedNotificationID(Long.valueOf(notificationID));
        long latestID = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)notificationID, (long)latestID);
    }

    @Test
    public void testAddDeleteAuthzPathsMapping() throws Exception {
        long notificationID = 0L;
        sentryStore.persistFullPathsImage(new HashMap(), notificationID);
        Long lastNotificationId = sentryStore.getLastProcessedNotificationID();
        UniquePathsUpdate addUpdate = new UniquePathsUpdate("u1", 1L, false);
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl1"));
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl2"));
        sentryStore.addAuthzPathsMapping("db1.table", (Collection)Sets.newHashSet((Object[])new String[]{"db1/tbl1", "db1/tbl2"}), addUpdate);
        PathsImage pathsImage = sentryStore.retrieveFullPathsImage();
        Map pathImage = pathsImage.getPathImage();
        TestSentryStore.assertEquals((long)1L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)2L, (long)((Collection)pathImage.get("db1.table")).size());
        TestSentryStore.assertEquals((long)2L, (long)sentryStore.getMPaths().size());
        long lastChangeID = sentryStore.getLastProcessedPathChangeID();
        MSentryPathChange addPathChange = sentryStore.getMSentryPathChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)addUpdate.JSONSerialize(), (Object)addPathChange.getPathChange());
        lastNotificationId = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)1L, (long)lastNotificationId);
        UniquePathsUpdate delUpdate = new UniquePathsUpdate("u2", 2L, false);
        delUpdate.newPathChange("db1.table").addToDelPaths(Arrays.asList("db1", "tbl1"));
        sentryStore.deleteAuthzPathsMapping("db1.table", (Iterable)Sets.newHashSet((Object[])new String[]{"db1/tbl1"}), delUpdate);
        pathImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)1L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)1L, (long)((Collection)pathImage.get("db1.table")).size());
        TestSentryStore.assertEquals((long)1L, (long)sentryStore.getMPaths().size());
        lastChangeID = sentryStore.getLastProcessedPathChangeID();
        MSentryPathChange delPathChange = sentryStore.getMSentryPathChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)delUpdate.JSONSerialize(), (Object)delPathChange.getPathChange());
        lastNotificationId = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)2L, (long)lastNotificationId);
        UniquePathsUpdate delAllupdate = new UniquePathsUpdate("u3", 3L, false);
        delAllupdate.newPathChange("db1.table").addToDelPaths((List)Lists.newArrayList((Object[])new String[]{"__ALL_PATHS__"}));
        sentryStore.deleteAllAuthzPathsMapping("db1.table", delAllupdate);
        pathImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)0L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getMPaths().size());
        lastChangeID = sentryStore.getLastProcessedPathChangeID();
        MSentryPathChange delAllPathChange = sentryStore.getMSentryPathChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)delAllupdate.JSONSerialize(), (Object)delAllPathChange.getPathChange());
        lastNotificationId = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)3L, (long)lastNotificationId);
    }

    @Test
    public void testRenameUpdateAuthzPathsMapping() throws Exception {
        HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
        Long lastNotificationId = sentryStore.getLastProcessedNotificationID();
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{"user/hive/warehouse/db1.db/table1", "user/hive/warehouse/db1.db/table1/p1"}));
        authzPaths.put("db1.table2", Sets.newHashSet((Object[])new String[]{"user/hive/warehouse/db1.db/table2"}));
        sentryStore.persistFullPathsImage(authzPaths, lastNotificationId.longValue());
        Map pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
        UniquePathsUpdate renameUpdate = new UniquePathsUpdate("u1", 1L, false);
        renameUpdate.newPathChange("db1.table1").addToDelPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "table1"));
        renameUpdate.newPathChange("db1.newTable1").addToAddPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable1"));
        sentryStore.renameAuthzPathsMapping("db1.table1", "db1.newTable1", "user/hive/warehouse/db1.db/table1", "user/hive/warehouse/db1.db/newTable1", renameUpdate);
        pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
        TestSentryStore.assertEquals((long)3L, (long)sentryStore.getMPaths().size());
        TestSentryStore.assertTrue((boolean)pathsImage.containsKey("db1.newTable1"));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"user/hive/warehouse/db1.db/table1/p1", "user/hive/warehouse/db1.db/newTable1"}), (Collection)((Collection)pathsImage.get("db1.newTable1"))));
        long lastChangeID = sentryStore.getLastProcessedPathChangeID();
        MSentryPathChange renamePathChange = sentryStore.getMSentryPathChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)renameUpdate.JSONSerialize(), (Object)renamePathChange.getPathChange());
        lastNotificationId = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)1L, (long)lastNotificationId);
        renameUpdate = new UniquePathsUpdate("u2", 2L, false);
        renameUpdate.newPathChange("db1.newTable1").addToDelPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable1"));
        renameUpdate.newPathChange("db1.newTable2").addToAddPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable1"));
        sentryStore.renameAuthzObj("db1.newTable1", "db1.newTable2", renameUpdate);
        pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
        TestSentryStore.assertEquals((long)3L, (long)sentryStore.getMPaths().size());
        TestSentryStore.assertTrue((boolean)pathsImage.containsKey("db1.newTable2"));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"user/hive/warehouse/db1.db/table1/p1", "user/hive/warehouse/db1.db/newTable1"}), (Collection)((Collection)pathsImage.get("db1.newTable2"))));
        lastNotificationId = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)2L, (long)lastNotificationId);
        lastChangeID = sentryStore.getLastProcessedPathChangeID();
        renamePathChange = sentryStore.getMSentryPathChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)renameUpdate.JSONSerialize(), (Object)renamePathChange.getPathChange());
        UniquePathsUpdate update = new UniquePathsUpdate("u3", 3L, false);
        update.newPathChange("db1.newTable1").addToDelPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable1"));
        update.newPathChange("db1.newTable1").addToAddPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable2"));
        sentryStore.updateAuthzPathsMapping("db1.newTable2", "user/hive/warehouse/db1.db/newTable1", "user/hive/warehouse/db1.db/newTable2", update);
        pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
        TestSentryStore.assertEquals((long)3L, (long)sentryStore.getMPaths().size());
        TestSentryStore.assertTrue((boolean)pathsImage.containsKey("db1.newTable2"));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"user/hive/warehouse/db1.db/table1/p1", "user/hive/warehouse/db1.db/newTable2"}), (Collection)((Collection)pathsImage.get("db1.newTable2"))));
        lastChangeID = sentryStore.getLastProcessedPathChangeID();
        MSentryPathChange updatePathChange = sentryStore.getMSentryPathChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)update.JSONSerialize(), (Object)updatePathChange.getPathChange());
        lastNotificationId = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)3L, (long)lastNotificationId);
    }

    @Test
    public void testPersistAndReplaceANewPathsImage() throws Exception {
        HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
        long notificationID = 1L;
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table1.1", "/user/hive/warehouse/db2.db/table1.2"}));
        authzPaths.put("db1.table2", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table2.1", "/user/hive/warehouse/db2.db/table2.2"}));
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        PathsImage pathsImage = sentryStore.retrieveFullPathsImage();
        TestSentryStore.assertEquals((long)1L, (long)pathsImage.getCurImgNum());
        authzPaths.clear();
        authzPaths.put("db3.table1", Sets.newHashSet((Object[])new String[]{"/another-warehouse/db2.db/table1.1", "/another-warehouse/db2.db/table1.2"}));
        authzPaths.put("db3.table2", Sets.newHashSet((Object[])new String[]{"/another-warehouse/db2.db/table2.1", "/another-warehouse/db2.db/table2.2"}));
        authzPaths.put("db4.table2", Sets.newHashSet((Object[])new String[]{"/another-warehouse/db2.db/table2.1", "/another-warehouse/db2.db/table2.3"}));
        sentryStore.persistFullPathsImage(authzPaths, notificationID + 1L);
        pathsImage = sentryStore.retrieveFullPathsImage();
        TestSentryStore.assertEquals((long)2L, (long)pathsImage.getCurImgNum());
        Map pathImage = pathsImage.getPathImage();
        TestSentryStore.assertEquals((long)3L, (long)pathImage.size());
        for (Map.Entry entry : pathImage.entrySet()) {
            TestSentryStore.assertEquals((long)2L, (long)((Collection)entry.getValue()).size());
        }
        TestSentryStore.assertEquals((long)2L, (long)((Collection)pathImage.get("db4.table2")).size());
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"/another-warehouse/db2.db/table1.1", "/another-warehouse/db2.db/table1.2"}), (Collection)((Collection)pathImage.get("db3.table1"))));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"/another-warehouse/db2.db/table2.1", "/another-warehouse/db2.db/table2.2"}), (Collection)((Collection)pathImage.get("db3.table2"))));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"/another-warehouse/db2.db/table2.1", "/another-warehouse/db2.db/table2.3"}), (Collection)((Collection)pathImage.get("db4.table2"))));
        TestSentryStore.assertEquals((long)6L, (long)sentryStore.getMPaths().size());
    }

    @Test
    public void testAddDeleteAfterReplacingANewPathsImage() throws Exception {
        long notificationID = 1L;
        UniquePathsUpdate addUpdate = new UniquePathsUpdate("u1", notificationID, false);
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl1"));
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl2"));
        sentryStore.addAuthzPathsMapping("db1.table", (Collection)Sets.newHashSet((Object[])new String[]{"db1/tbl1", "db1/tbl2"}), addUpdate);
        HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
        authzPaths.put("db2.table3", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table1.1", "/user/hive/warehouse/db2.db/table1.2"}));
        sentryStore.persistFullPathsImage(authzPaths, ++notificationID);
        UniquePathsUpdate newAddUpdate = new UniquePathsUpdate("u2", ++notificationID, false);
        newAddUpdate.newPathChange("db2.table").addToAddPaths(Arrays.asList("db2", "tbl1"));
        newAddUpdate.newPathChange("db2.table").addToAddPaths(Arrays.asList("db2", "tbl2"));
        sentryStore.addAuthzPathsMapping("db2.table", (Collection)Sets.newHashSet((Object[])new String[]{"db2/tbl1", "db2/tbl2"}), newAddUpdate);
        PathsImage pathsImage = sentryStore.retrieveFullPathsImage();
        Map pathImage = pathsImage.getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)2L, (long)((Collection)pathImage.get("db2.table")).size());
        TestSentryStore.assertEquals((long)4L, (long)sentryStore.getMPaths().size());
        UniquePathsUpdate delUpdate = new UniquePathsUpdate("u3", ++notificationID, false);
        delUpdate.newPathChange("db2.table").addToDelPaths(Arrays.asList("db2", "tbl1"));
        sentryStore.deleteAuthzPathsMapping("db2.table", (Iterable)Sets.newHashSet((Object[])new String[]{"db2/tbl1"}), delUpdate);
        pathsImage = sentryStore.retrieveFullPathsImage();
        pathImage = pathsImage.getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)1L, (long)((Collection)pathImage.get("db2.table")).size());
        TestSentryStore.assertEquals((long)3L, (long)sentryStore.getMPaths().size());
        Long lastNotificationId = sentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)notificationID, (long)lastNotificationId);
    }

    @Test
    public void testRenameUpdateAfterReplacingANewPathsImage() throws Exception {
        long notificationID = 1L;
        HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table1.1", "/user/hive/warehouse/db2.db/table1.2"}));
        authzPaths.put("db1.table2", Sets.newHashSet((Object[])new String[]{"/user/hive/warehouse/db2.db/table2.1", "/user/hive/warehouse/db2.db/table2.2"}));
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        ++notificationID;
        authzPaths.clear();
        authzPaths.put("db3.table1", Sets.newHashSet((Object[])new String[]{"/another-warehouse/db3.db/table1.1", "/another-warehouse/db3.db/table1.2"}));
        authzPaths.put("db3.table2", Sets.newHashSet((Object[])new String[]{"/another-warehouse/db3.db/table2.1", "/another-warehouse/db3.db/table2.2"}));
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        UniquePathsUpdate renameUpdate = new UniquePathsUpdate("u1", ++notificationID, false);
        renameUpdate.newPathChange("db3.table1").addToDelPaths(Arrays.asList("another-warehouse", "db3.db", "table1.1"));
        renameUpdate.newPathChange("db1.newTable1").addToAddPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable1"));
        sentryStore.renameAuthzPathsMapping("db3.table1", "db1.newTable1", "/another-warehouse/db3.db/table1.1", "user/hive/warehouse/db1.db/newTable1", renameUpdate);
        Map pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
        TestSentryStore.assertEquals((long)4L, (long)sentryStore.getMPaths().size());
        TestSentryStore.assertTrue((boolean)pathsImage.containsKey("db1.newTable1"));
        TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"/another-warehouse/db3.db/table1.2", "user/hive/warehouse/db1.db/newTable1"}), (Collection)((Collection)pathsImage.get("db1.newTable1"))));
        UniquePathsUpdate update = new UniquePathsUpdate("u2", ++notificationID, false);
        update.newPathChange("db1.newTable1").addToDelPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable1"));
        update.newPathChange("db1.newTable1").addToAddPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable2"));
        sentryStore.updateAuthzPathsMapping("db1.newTable2", "user/hive/warehouse/db1.db/newTable1", "user/hive/warehouse/db1.db/newTable2", update);
        pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)3L, (long)pathsImage.size());
        TestSentryStore.assertEquals((long)5L, (long)sentryStore.getMPaths().size());
        TestSentryStore.assertTrue((boolean)pathsImage.containsKey("db1.newTable2"));
        TestSentryStore.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"user/hive/warehouse/db1.db/newTable2"}), pathsImage.get("db1.newTable2"));
    }

    @Test
    public void testQueryParamBuilder() {
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add("key", "val");
        TestSentryStore.assertEquals((Object)"(this.key == :key)", (Object)paramBuilder.toString());
        paramBuilder.add("key1", " Val1 ", true);
        TestSentryStore.assertEquals((Object)"(this.key == :key && this.key1 == :key1)", (Object)paramBuilder.toString());
        Map params = paramBuilder.getArguments();
        TestSentryStore.assertEquals((Object)"val", params.get("key"));
        TestSentryStore.assertEquals((Object)"Val1", params.get("key1"));
        paramBuilder = QueryParamBuilder.newQueryParamBuilder((QueryParamBuilder.Op)QueryParamBuilder.Op.OR);
        paramBuilder.add("key", " Val ", true);
        paramBuilder.addNotNull("notNullField");
        paramBuilder.addNull("nullField");
        TestSentryStore.assertEquals((Object)"(this.key == :key || this.notNullField != \"__NULL__\" || this.nullField == \"__NULL__\")", (Object)paramBuilder.toString());
        params = paramBuilder.getArguments();
        TestSentryStore.assertEquals((Object)"Val", params.get("key"));
        paramBuilder = QueryParamBuilder.newQueryParamBuilder().addNull("var1").addNotNull("var2");
        TestSentryStore.assertEquals((Object)"(this.var1 == \"__NULL__\" && this.var2 != \"__NULL__\")", (Object)paramBuilder.toString());
        paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.addString("e1").addString("e2").newChild().add("v3", "e3").add("v4", "e4").newChild().addString("e5").addString("e6");
        TestSentryStore.assertEquals((Object)"(e1 && e2 && (this.v3 == :v3 || this.v4 == :v4 || (e5 && e6)))", (Object)paramBuilder.toString());
        params = paramBuilder.getArguments();
        TestSentryStore.assertEquals((Object)"e3", params.get("v3"));
        TestSentryStore.assertEquals((Object)"e4", params.get("v4"));
        paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        HashSet<String> names = new HashSet<String>();
        names.add("foo");
        names.add("bar");
        names.add("bob");
        paramBuilder.addSet("prefix == ", names);
        TestSentryStore.assertEquals((Object)"(prefix == :var0 && prefix == :var1 && prefix == :var2)", (Object)paramBuilder.toString());
        params = paramBuilder.getArguments();
        HashSet<String> result = new HashSet<String>();
        result.add((String)params.get("var0"));
        result.add((String)params.get("var1"));
        result.add((String)params.get("var2"));
        TestSentryStore.assertTrue((boolean)result.containsAll(names));
        TestSentryStore.assertTrue((boolean)names.containsAll(result));
    }

    @Test
    public void testPrivilegesWithPermUpdate() throws Exception {
        long lastChangeID;
        String roleName = "test-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String authzObj = "db1.tbl1";
        this.createRole(roleName);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("Column");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("select");
        privilege.setCreateTime(System.currentTimeMillis());
        PermissionsUpdate addUpdate = new PermissionsUpdate(0L, false);
        addUpdate.addPrivilegeUpdate(authzObj).putToAddPrivileges(roleName, privilege.getAction().toUpperCase());
        HashMap addPrivilegesUpdateMap = Maps.newHashMap();
        addPrivilegesUpdateMap.put(privilege, addUpdate);
        sentryStore.alterSentryRoleGrantPrivileges(grantor, roleName, (Set)Sets.newHashSet((Object[])new TSentryPrivilege[]{privilege}), (Map)addPrivilegesUpdateMap);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        TestSentryStore.assertEquals((String)privileges.toString(), (long)1L, (long)privileges.size());
        long initialID = lastChangeID = sentryStore.getLastProcessedPermChangeID().longValue();
        MSentryPermChange addPermChange = sentryStore.getMSentryPermChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)addUpdate.JSONSerialize(), (Object)addPermChange.getPermChange());
        PermissionsUpdate delUpdate = new PermissionsUpdate(0L, false);
        delUpdate.addPrivilegeUpdate(authzObj).putToDelPrivileges(roleName, privilege.getAction().toUpperCase());
        HashMap delPrivilegesUpdateMap = Maps.newHashMap();
        delPrivilegesUpdateMap.put(privilege, delUpdate);
        sentryStore.alterSentryRoleRevokePrivileges(grantor, roleName, (Set)Sets.newHashSet((Object[])new TSentryPrivilege[]{privilege}), (Map)delPrivilegesUpdateMap);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        TestSentryStore.assertEquals((long)0L, (long)privileges.size());
        lastChangeID = sentryStore.getLastProcessedPermChangeID();
        MSentryPermChange delPermChange = sentryStore.getMSentryPermChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)delUpdate.JSONSerialize(), (Object)delPermChange.getPermChange());
        List mSentryPermChanges = sentryStore.getMSentryPermChanges(initialID);
        TestSentryStore.assertEquals((long)(lastChangeID - initialID + 1L), (long)mSentryPermChanges.size());
        TestSentryStore.assertEquals((Object)true, (Object)sentryStore.permChangeExists(1L));
    }

    @Test
    public void testAddDeleteGroupsWithPermUpdate() throws Exception {
        String roleName = "test-groups";
        String grantor = "g1";
        this.createRole(roleName);
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName("test-groups-g1");
        groups.add(group);
        group = new TSentryGroup();
        group.setGroupName("test-groups-g2");
        groups.add(group);
        PermissionsUpdate addUpdate = new PermissionsUpdate(0L, false);
        TRoleChanges addrUpdate = addUpdate.addRoleUpdate(roleName);
        for (TSentryGroup g : groups) {
            addrUpdate.addToAddGroups(g.getGroupName());
        }
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, (Set)groups, (Updateable.Update)addUpdate);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        TestSentryStore.assertEquals((long)2L, (long)role.getGroups().size());
        long lastChangeID = sentryStore.getLastProcessedPermChangeID();
        MSentryPermChange addPermChange = sentryStore.getMSentryPermChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)addUpdate.JSONSerialize(), (Object)addPermChange.getPermChange());
        PermissionsUpdate delUpdate = new PermissionsUpdate(0L, false);
        TRoleChanges delrUpdate = delUpdate.addRoleUpdate(roleName);
        for (TSentryGroup g : groups) {
            delrUpdate.addToDelGroups(g.getGroupName());
        }
        sentryStore.alterSentryRoleDeleteGroups(roleName, (Set)groups, (Updateable.Update)delUpdate);
        role = sentryStore.getMSentryRoleByName(roleName);
        TestSentryStore.assertEquals(Collections.emptySet(), (Object)role.getGroups());
        MSentryPermChange delPermChange = sentryStore.getMSentryPermChangeByID(lastChangeID + 1L);
        TestSentryStore.assertEquals((Object)delUpdate.JSONSerialize(), (Object)delPermChange.getPermChange());
    }

    @Test
    public void testCreateDropRoleWithPermUpdate() throws Exception {
        String roleName = "test-drop-role";
        this.createRole(roleName);
        PermissionsUpdate delUpdate = new PermissionsUpdate(0L, false);
        delUpdate.addPrivilegeUpdate("__ALL_AUTHZ_OBJ__").putToDelPrivileges(roleName, "__ALL_AUTHZ_OBJ__");
        delUpdate.addRoleUpdate(roleName).addToDelGroups("__ALL_GROUPS__");
        sentryStore.dropSentryRole(roleName, (Updateable.Update)delUpdate);
        this.checkRoleDoesNotExist(roleName);
        long lastChangeID = sentryStore.getLastProcessedPermChangeID();
        MSentryPermChange delPermChange = sentryStore.getMSentryPermChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)delUpdate.JSONSerialize(), (Object)delPermChange.getPermChange());
    }

    @Test
    public void testDropObjWithPermUpdate() throws Exception {
        String roleName1 = "list-privs-r1";
        String roleName2 = "list-privs-r2";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        String authzObj = "db1.tbl1";
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName("tbl1");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        privilege_tbl1.setAction("SELECT");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1);
        PermissionsUpdate dropUpdate = new PermissionsUpdate(0L, false);
        dropUpdate.addPrivilegeUpdate(authzObj).putToDelPrivileges("__ALL_ROLES__", "__ALL_ROLES__");
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl1), (Updateable.Update)dropUpdate);
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName2).size());
        long lastChangeID = sentryStore.getLastProcessedPermChangeID();
        MSentryPermChange dropPermChange = sentryStore.getMSentryPermChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)dropUpdate.JSONSerialize(), (Object)dropPermChange.getPermChange());
    }

    @Test
    public void testRenameObjWithPermUpdate() throws Exception {
        String roleName1 = "role1";
        String grantor = "g1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        privilege_tbl1.setAction("*");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1);
        String oldAuthz = "db1.tbl1";
        String newAuthz = "db1.tbl2";
        PermissionsUpdate renameUpdate = new PermissionsUpdate(0L, false);
        TPrivilegeChanges privUpdate = renameUpdate.addPrivilegeUpdate("__RENAME_PRIV__");
        privUpdate.putToAddPrivileges(newAuthz, newAuthz);
        privUpdate.putToDelPrivileges(oldAuthz, oldAuthz);
        TSentryAuthorizable oldTable = this.toTSentryAuthorizable(privilege_tbl1);
        TSentryAuthorizable newTable = this.toTSentryAuthorizable(privilege_tbl1);
        newTable.setTable(table2);
        sentryStore.renamePrivilege(oldTable, newTable, (Updateable.Update)renameUpdate);
        Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        TestSentryStore.assertEquals((long)1L, (long)privilegeSet.size());
        for (TSentryPrivilege privilege : privilegeSet) {
            TestSentryStore.assertTrue((boolean)table2.equalsIgnoreCase(privilege.getTableName()));
        }
        long lastChangeID = sentryStore.getLastProcessedPermChangeID();
        MSentryPermChange renamePermChange = sentryStore.getMSentryPermChangeByID(lastChangeID);
        TestSentryStore.assertEquals((Object)renameUpdate.JSONSerialize(), (Object)renamePermChange.getPermChange());
    }

    protected static void addGroupsToUser(String user, String ... groupNames) {
        policyFile.addGroupsToUser(user, groupNames);
    }

    protected static void writePolicyFile() throws Exception {
        policyFile.write(policyFilePath);
    }

    @Test
    public void testPurgeDeltaChanges() throws Exception {
        String role = "purgeRole";
        String grantor = "g1";
        String table = "purgeTable";
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getMSentryPermChanges().size());
        TestSentryStore.assertEquals((long)0L, (long)sentryStore.getMSentryPathChanges().size());
        sentryStore.createSentryRole(role);
        int privCleanCount = 200;
        int extraPrivs = 5;
        int numPermChanges = extraPrivs + privCleanCount;
        for (int i = 0; i < numPermChanges; ++i) {
            TSentryPrivilege privilege = new TSentryPrivilege();
            privilege.setPrivilegeScope("Column");
            privilege.setServerName("server");
            privilege.setDbName("db");
            privilege.setTableName(table);
            privilege.setColumnName("column");
            privilege.setAction("select");
            privilege.setCreateTime(System.currentTimeMillis());
            PermissionsUpdate update = new PermissionsUpdate((long)(i + 1), false);
            sentryStore.alterSentryRoleGrantPrivilege(grantor, role, privilege, (Updateable.Update)update);
        }
        TestSentryStore.assertEquals((long)numPermChanges, (long)sentryStore.getMSentryPermChanges().size());
        sentryStore.purgeDeltaChangeTables();
        TestSentryStore.assertEquals((long)privCleanCount, (long)sentryStore.getMSentryPermChanges().size());
    }

    @Test
    public void testpurgeNotificationIdTable() throws Exception {
        int id;
        int totalentires = 200;
        int remainingEntires = 100;
        TestSentryStore.assertTrue((boolean)sentryStore.isHmsNotificationEmpty());
        for (id = 1; id <= totalentires; ++id) {
            sentryStore.persistLastProcessedNotificationID(Long.valueOf(id));
        }
        TestSentryStore.assertEquals((long)totalentires, (long)sentryStore.getMSentryHmsNotificationCore().size());
        sentryStore.purgeNotificationIdTable();
        TestSentryStore.assertEquals((long)remainingEntires, (long)sentryStore.getMSentryHmsNotificationCore().size());
        sentryStore.purgeNotificationIdTable();
        TestSentryStore.assertEquals((long)remainingEntires, (long)sentryStore.getMSentryHmsNotificationCore().size());
        sentryStore.clearAllTables();
        totalentires = 50;
        for (id = 1; id <= totalentires; ++id) {
            sentryStore.persistLastProcessedNotificationID(Long.valueOf(id));
        }
        TestSentryStore.assertEquals((long)totalentires, (long)sentryStore.getMSentryHmsNotificationCore().size());
        sentryStore.purgeNotificationIdTable();
        TestSentryStore.assertEquals((long)totalentires, (long)sentryStore.getMSentryHmsNotificationCore().size());
    }

    @Test(timeout=60000L)
    public void testConcurrentUpdateChanges() throws Exception {
        int numThreads = 20;
        int numChangesPerThread = 100;
        final TransactionManager tm = sentryStore.getTransactionManager();
        final AtomicLong seqNumGenerator = new AtomicLong(0L);
        final CyclicBarrier barrier = new CyclicBarrier(20);
        ExecutorService executor = Executors.newFixedThreadPool(20);
        for (int i = 0; i < 20; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        LOGGER.error("Barrier failed to await", (Throwable)e);
                        return;
                    }
                    for (int j = 0; j < 100; ++j) {
                        ArrayList<DeltaTransactionBlock> tbs = new ArrayList<DeltaTransactionBlock>();
                        PermissionsUpdate update = new PermissionsUpdate(seqNumGenerator.getAndIncrement(), false);
                        tbs.add(new DeltaTransactionBlock((Updateable.Update)update));
                        try {
                            tm.executeTransactionBlocksWithRetry(tbs);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to execute permission update transaction", (Throwable)e);
                            Assert.fail((String)String.format("Transaction failed: %s", e.getMessage()));
                        }
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(60L, TimeUnit.SECONDS);
        List changes = sentryStore.getMSentryPermChanges();
        int actualSize = changes.size();
        if (actualSize != 2000) {
            LOGGER.warn("Detected {} dropped changes", (Object)(2000 - actualSize));
        }
        TreeSet<Long> changeIDs = new TreeSet<Long>();
        for (MSentryPermChange change : changes) {
            changeIDs.add(change.getChangeID());
        }
        TestSentryStore.assertEquals((String)"duplicated change ID", (long)actualSize, (long)changeIDs.size());
        long prevId = (Long)changeIDs.first() - 1L;
        for (Long changeId : changeIDs) {
            TestSentryStore.assertTrue((String)String.format("Found non-consecutive number: prev=%d cur=%d", prevId, changeId), (changeId - prevId == 1L ? 1 : 0) != 0);
            prevId = changeId;
        }
    }

    @Test
    public void testDuplicateNotification() throws Exception {
        block3: {
            Long lastNotificationId;
            HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
            Long l = lastNotificationId = sentryStore.getLastProcessedNotificationID();
            Long l2 = lastNotificationId = Long.valueOf(lastNotificationId + 1L);
            authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{"user/hive/warehouse/db1.db/table1", "user/hive/warehouse/db1.db/table1/p1"}));
            authzPaths.put("db1.table2", Sets.newHashSet((Object[])new String[]{"user/hive/warehouse/db1.db/table2"}));
            sentryStore.persistFullPathsImage(authzPaths, lastNotificationId.longValue());
            Map pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
            TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
            if (lastNotificationId == null) {
                lastNotificationId = 0L;
            }
            l2 = lastNotificationId;
            Long l3 = lastNotificationId = Long.valueOf(lastNotificationId + 1L);
            UniquePathsUpdate renameUpdate = new UniquePathsUpdate("u1", lastNotificationId.longValue(), false);
            renameUpdate.newPathChange("db1.table1").addToDelPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "table1"));
            renameUpdate.newPathChange("db1.newTable1").addToAddPaths(Arrays.asList("user", "hive", "warehouse", "db1.db", "newTable1"));
            sentryStore.renameAuthzPathsMapping("db1.table1", "db1.newTable1", "user/hive/warehouse/db1.db/table1", "user/hive/warehouse/db1.db/newTable1", renameUpdate);
            pathsImage = sentryStore.retrieveFullPathsImage().getPathImage();
            TestSentryStore.assertEquals((long)2L, (long)pathsImage.size());
            TestSentryStore.assertEquals((long)3L, (long)sentryStore.getMPaths().size());
            TestSentryStore.assertTrue((boolean)pathsImage.containsKey("db1.newTable1"));
            TestSentryStore.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)Lists.newArrayList((Object[])new String[]{"user/hive/warehouse/db1.db/table1/p1", "user/hive/warehouse/db1.db/newTable1"}), (Collection)((Collection)pathsImage.get("db1.newTable1"))));
            long lastChangeID = sentryStore.getLastProcessedPathChangeID();
            MSentryPathChange renamePathChange = sentryStore.getMSentryPathChangeByID(lastChangeID);
            TestSentryStore.assertEquals((Object)renameUpdate.JSONSerialize(), (Object)renamePathChange.getPathChange());
            Long savedLastNotificationId = sentryStore.getLastProcessedNotificationID();
            TestSentryStore.assertEquals((long)lastNotificationId, (long)savedLastNotificationId);
            try {
                sentryStore.renameAuthzPathsMapping("db1.table1", "db1.newTable1", "user/hive/warehouse/db1.db/table1", "user/hive/warehouse/db1.db/newTable1", renameUpdate);
            }
            catch (Exception e) {
                if (e.getCause() instanceof JDODataStoreException) break block3;
                TestSentryStore.fail((String)"Unexpected failure occured while processing duplicate notification");
            }
        }
    }

    @Test
    public void testIsAuthzPathsMappingEmpty() throws Exception {
        UniquePathsUpdate addUpdate = new UniquePathsUpdate("u1", 1L, false);
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl1"));
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl2"));
        sentryStore.persistFullPathsImage(new HashMap(), 0L);
        TestSentryStore.assertEquals((Object)sentryStore.isAuthzPathsMappingEmpty(), (Object)true);
        sentryStore.addAuthzPathsMapping("db1.table", (Collection)Sets.newHashSet((Object[])new String[]{"db1/tbl1", "db1/tbl2"}), addUpdate);
        PathsImage pathsImage = sentryStore.retrieveFullPathsImage();
        Map pathImage = pathsImage.getPathImage();
        TestSentryStore.assertEquals((long)1L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)2L, (long)((Collection)pathImage.get("db1.table")).size());
        TestSentryStore.assertEquals((long)2L, (long)sentryStore.getMPaths().size());
        TestSentryStore.assertEquals((Object)sentryStore.isAuthzPathsMappingEmpty(), (Object)false);
        sentryStore.clearAllTables();
        TestSentryStore.assertEquals((Object)sentryStore.isAuthzPathsMappingEmpty(), (Object)true);
    }

    @Test
    public void testAddDeleteAuthzPathsMappingNoDeltaSavedWithoutHDFSSync() throws Exception {
        conf.set("sentry.service.processor.factories", "");
        conf.set("sentry.policy.store.plugins", "");
        SentryStore localSentryStore = new SentryStore(conf);
        localSentryStore.persistFullPathsImage(new HashMap(), 0L);
        Long lastNotificationId = sentryStore.getLastProcessedNotificationID();
        UniquePathsUpdate addUpdate = new UniquePathsUpdate("u1", 1L, false);
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl1"));
        addUpdate.newPathChange("db1.table").addToAddPaths(Arrays.asList("db1", "tbl2"));
        localSentryStore.addAuthzPathsMapping("db1.table", (Collection)Sets.newHashSet((Object[])new String[]{"db1/tbl1", "db1/tbl2"}), addUpdate);
        PathsImage pathsImage = localSentryStore.retrieveFullPathsImage();
        Map pathImage = pathsImage.getPathImage();
        TestSentryStore.assertEquals((long)1L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)2L, (long)((Collection)pathImage.get("db1.table")).size());
        TestSentryStore.assertEquals((long)2L, (long)localSentryStore.getMPaths().size());
        long lastChangeID = localSentryStore.getLastProcessedPathChangeID();
        TestSentryStore.assertEquals((long)0L, (long)lastChangeID);
        UniquePathsUpdate delUpdate = new UniquePathsUpdate("u2", 2L, false);
        delUpdate.newPathChange("db1.table").addToDelPaths(Arrays.asList("db1", "tbl1"));
        localSentryStore.deleteAuthzPathsMapping("db1.table", (Iterable)Sets.newHashSet((Object[])new String[]{"db1/tbl1"}), delUpdate);
        pathImage = localSentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)1L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)1L, (long)((Collection)pathImage.get("db1.table")).size());
        TestSentryStore.assertEquals((long)1L, (long)localSentryStore.getMPaths().size());
        lastChangeID = localSentryStore.getLastProcessedPathChangeID();
        TestSentryStore.assertEquals((long)0L, (long)lastChangeID);
        UniquePathsUpdate delAllupdate = new UniquePathsUpdate("u3", 3L, false);
        delAllupdate.newPathChange("db1.table").addToDelPaths((List)Lists.newArrayList((Object[])new String[]{"__ALL_PATHS__"}));
        localSentryStore.deleteAllAuthzPathsMapping("db1.table", delAllupdate);
        pathImage = localSentryStore.retrieveFullPathsImage().getPathImage();
        TestSentryStore.assertEquals((long)0L, (long)pathImage.size());
        TestSentryStore.assertEquals((long)0L, (long)localSentryStore.getMPaths().size());
        lastChangeID = localSentryStore.getLastProcessedPathChangeID();
        TestSentryStore.assertEquals((long)0L, (long)lastChangeID);
        lastNotificationId = localSentryStore.getLastProcessedNotificationID();
        TestSentryStore.assertEquals((long)0L, (long)lastNotificationId);
        conf.set("sentry.service.processor.factories", "org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory");
        conf.set("sentry.policy.store.plugins", "org.apache.sentry.hdfs.SentryPlugin");
    }

    @Test
    public void testRetrieveEmptyPathImage() throws Exception {
        String[] prefixes = new String[]{};
        PathsUpdate pathsUpdate = sentryStore.retrieveFullPathsImageUpdate(prefixes);
        TPathsUpdate tPathsUpdate = pathsUpdate.toThrift();
        TPathsDump pathDump = tPathsUpdate.getPathsDump();
        Map nodeMap = pathDump.getNodeMap();
        TestSentryStore.assertEquals((long)1L, (long)nodeMap.size());
        System.out.printf(nodeMap.toString(), new Object[0]);
    }

    @Test
    public void testRetrievePathImageWithSingleEntry() throws Exception {
        String prefix = "user/hive/warehouse";
        String[] prefixes = new String[]{"/" + prefix};
        HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
        String tablePath = prefix + "/db2.db/table1.1";
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{tablePath}));
        long notificationID = 1L;
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        PathsUpdate pathsUpdate = sentryStore.retrieveFullPathsImageUpdate(prefixes);
        TestSentryStore.assertEquals((long)notificationID, (long)pathsUpdate.getImgNum());
        TPathsUpdate tPathsUpdate = pathsUpdate.toThrift();
        TPathsDump pathDump = tPathsUpdate.getPathsDump();
        Map nodeMap = pathDump.getNodeMap();
        System.out.printf(nodeMap.toString(), new Object[0]);
        TestSentryStore.assertEquals((long)6L, (long)nodeMap.size());
        int rootId = pathDump.getRootId();
        TPathEntry root = (TPathEntry)nodeMap.get(rootId);
        TestSentryStore.assertEquals((Object)"/", (Object)root.getPathElement());
        TPathEntry child = root;
        for (String path : tablePath.split("/")) {
            List children = child.getChildren();
            TestSentryStore.assertEquals((long)1L, (long)children.size());
            child = (TPathEntry)nodeMap.get(children.get(0));
            TestSentryStore.assertEquals((Object)path, (Object)child.getPathElement());
        }
    }

    @Test
    public void testRetrievePathImageWithMultipleLeadingSlashes() throws Exception {
        String prefix = "user/hive/warehouse";
        String[] prefixes = new String[]{"/" + prefix};
        HashMap<String, HashSet> authzPaths = new HashMap<String, HashSet>();
        String tablePath = prefix + "/loc1/db2.db/table1.1";
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{tablePath}));
        long notificationID = 1L;
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        PathsUpdate pathsUpdate = sentryStore.retrieveFullPathsImageUpdate(prefixes);
        TestSentryStore.assertEquals((long)notificationID, (long)pathsUpdate.getImgNum());
        TPathsUpdate tPathsUpdate = pathsUpdate.toThrift();
        TPathsDump pathDump = tPathsUpdate.getPathsDump();
        Map nodeMap = pathDump.getNodeMap();
        TestSentryStore.assertEquals((long)7L, (long)nodeMap.size());
        prefix = "/user/hive/warehouse";
        prefixes = new String[]{prefix};
        authzPaths = new HashMap();
        tablePath = prefix + "/loc1/db2.db/table1.1";
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{tablePath}));
        notificationID = 2L;
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        pathsUpdate = sentryStore.retrieveFullPathsImageUpdate(prefixes);
        TestSentryStore.assertEquals((long)notificationID, (long)pathsUpdate.getImgNum());
        tPathsUpdate = pathsUpdate.toThrift();
        pathDump = tPathsUpdate.getPathsDump();
        nodeMap = pathDump.getNodeMap();
        TestSentryStore.assertEquals((long)7L, (long)nodeMap.size());
        prefix = "///user/hive/warehouse";
        prefixes = new String[]{prefix};
        authzPaths = new HashMap();
        tablePath = prefix + "/loc1/db2.db/table1.1";
        authzPaths.put("db1.table1", Sets.newHashSet((Object[])new String[]{tablePath}));
        notificationID = 3L;
        sentryStore.persistFullPathsImage(authzPaths, notificationID);
        pathsUpdate = sentryStore.retrieveFullPathsImageUpdate(prefixes);
        TestSentryStore.assertEquals((long)notificationID, (long)pathsUpdate.getImgNum());
        tPathsUpdate = pathsUpdate.toThrift();
        pathDump = tPathsUpdate.getPathsDump();
        nodeMap = pathDump.getNodeMap();
        TestSentryStore.assertEquals((long)7L, (long)nodeMap.size());
    }

    static {
        adminGroups = new String[]{"adminGroup1"};
        conf = null;
        passwd = new char[]{'1', '2', '3'};
    }
}

