/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageFactory;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.file.PolicyFile;
import org.apache.sentry.service.thrift.HMSFollower;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.sentry.service.thrift.HiveSimpleConnectionFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHMSFollowerSentryStoreIntegration {
    private static File dataDir;
    private static SentryStore sentryStore;
    private static String[] adminGroups;
    private static PolicyFile policyFile;
    private static File policyFilePath;
    private static Configuration conf;
    private static char[] passwd;
    private static String dbName1;
    private static String tableName1;
    private static String serverName1;
    SentryJSONMessageFactory messageFactory = new SentryJSONMessageFactory();
    static final String hiveInstance;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration(false);
        String ourUrl = "user:///";
        conf.set("hadoop.security.credential.provider.path", "user:///");
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        if (provider.getCredentialEntry("sentry.store.jdbc.password") == null) {
            provider.createCredentialEntry("sentry.store.jdbc.password", passwd);
            provider.flush();
        }
        dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        conf.set("sentry.verify.schema.version", "false");
        conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dataDir.getPath() + ";create=true");
        conf.set("sentry.store.jdbc.password", "dummy");
        conf.setStrings("sentry.service.admin.group", adminGroups);
        conf.set("sentry.store.group.mapping", "org.apache.sentry.provider.file.LocalGroupMappingService");
        policyFilePath = new File(dataDir, "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", policyFilePath.getPath());
        conf.setInt("sentry.store.transaction.retry", 10);
    }

    @Before
    public void before() throws Exception {
        sentryStore = new SentryStore(conf);
        sentryStore.setPersistUpdateDeltas(true);
        policyFile = new PolicyFile();
        String adminUser = "g1";
        TestHMSFollowerSentryStoreIntegration.addGroupsToUser(adminUser, adminGroups);
        TestHMSFollowerSentryStoreIntegration.writePolicyFile();
    }

    @After
    public void after() {
        if (sentryStore != null) {
            sentryStore.clearAllTables();
            sentryStore.stop();
        }
    }

    @AfterClass
    public static void teardown() {
        if (dataDir != null) {
            FileUtils.deleteQuietly((File)dataDir);
        }
    }

    protected static void addGroupsToUser(String user, String ... groupNames) {
        policyFile.addGroupsToUser(user, groupNames);
    }

    protected static void writePolicyFile() throws Exception {
        policyFile.write(policyFilePath);
    }

    @Test
    public void testDropTableDropRelatedPermission() throws Exception {
        String serverName = "server1";
        Configuration configuration = new Configuration();
        configuration.set(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar(), serverName);
        HMSFollower hmsFollower = new HMSFollower(configuration, sentryStore, null, (HiveConnectionFactory)new HiveSimpleConnectionFactory(conf, new HiveConf()), null);
        String roleName1 = "list-privs-r1";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName(serverName);
        privilege_tbl1.setDbName(dbName1);
        privilege_tbl1.setTableName(tableName1);
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege1 = new TSentryPrivilege(privilege_tbl1);
        privilege1.setAction("SELECT");
        TSentryPrivilege privilege1_2 = new TSentryPrivilege(privilege_tbl1);
        privilege1_2.setAction("INSERT");
        TSentryPrivilege privilege1_3 = new TSentryPrivilege(privilege_tbl1);
        privilege1_3.setAction("*");
        TSentryPrivilege privilege_server = new TSentryPrivilege();
        privilege_server.setPrivilegeScope("SERVER");
        privilege_server.setServerName(serverName1);
        privilege_server.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1_2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_server);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1_3);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs:///db1.db/table1");
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.DROP_TABLE.toString(), this.messageFactory.buildDropTableMessage(new Table(tableName1, dbName1, null, 0, 0, 0, sd, null, null, null, null, null)).toString());
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        hmsFollower.processNotifications(events);
        Assert.assertEquals((long)1L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
    }

    @Test
    public void testDropDatabaseDropRelatedPermission() throws Exception {
        String serverName = "server1";
        Configuration configuration = new Configuration();
        configuration.set(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar(), serverName);
        HMSFollower hmsFollower = new HMSFollower(configuration, sentryStore, null, (HiveConnectionFactory)new HiveSimpleConnectionFactory(conf, new HiveConf()), null);
        String roleName1 = "list-privs-r1";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("DATABASE");
        privilege_tbl1.setServerName(serverName);
        privilege_tbl1.setDbName(dbName1);
        privilege_tbl1.setTableName(tableName1);
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege1 = new TSentryPrivilege(privilege_tbl1);
        privilege1.setAction("SELECT");
        TSentryPrivilege privilege1_2 = new TSentryPrivilege(privilege_tbl1);
        privilege1_2.setAction("INSERT");
        TSentryPrivilege privilege1_3 = new TSentryPrivilege(privilege_tbl1);
        privilege1_3.setAction("*");
        TSentryPrivilege privilege_server = new TSentryPrivilege();
        privilege_server.setPrivilegeScope("SERVER");
        privilege_server.setServerName(serverName1);
        privilege_server.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1_2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_server);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1_3);
        NotificationEvent notificationEvent = new NotificationEvent(1L, 0, EventMessage.EventType.DROP_DATABASE.toString(), this.messageFactory.buildDropDatabaseMessage(new Database(dbName1, null, "hdfs:///" + dbName1, null)).toString());
        ArrayList<NotificationEvent> events = new ArrayList<NotificationEvent>();
        events.add(notificationEvent);
        hmsFollower.processNotifications(events);
        Assert.assertEquals((long)1L, (long)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
    }

    static {
        adminGroups = new String[]{"adminGroup1"};
        conf = null;
        passwd = new char[]{'1', '2', '3'};
        dbName1 = "db1";
        tableName1 = "table1";
        hiveInstance = serverName1 = "server1";
    }
}

