/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import java.util.ArrayList;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.provider.db.service.model.MSentryPathChange;
import org.apache.sentry.provider.db.service.model.MSentryPermChange;
import org.apache.sentry.provider.db.service.model.MSentryUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestMSentryUtil {
    @Test
    public void testMSentryUtilWithPathChanges() throws Exception {
        ArrayList<MSentryPathChange> changes = new ArrayList<MSentryPathChange>();
        PathsUpdate update = new PathsUpdate(1L, false);
        changes.add(new MSentryPathChange(1L, "u1", update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertTrue((String)"List of changes should be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPathChange(2L, "u2", update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertTrue((String)"List of changes should be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPathChange(4L, "u4", update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPathChange(5L, "u5", update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4, 5]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPathChange(6L, "u6", update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4-6]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPathChange(8L, "u8", update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4-6, 8]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
    }

    @Test
    public void testMSentryUtilWithPermChanges() throws Exception {
        ArrayList<MSentryPermChange> changes = new ArrayList<MSentryPermChange>();
        PermissionsUpdate update = new PermissionsUpdate(1L, false);
        changes.add(new MSentryPermChange(1L, update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertTrue((String)"List of changes should be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPermChange(2L, update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertTrue((String)"List of changes should be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPermChange(4L, update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPermChange(5L, update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4, 5]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPermChange(6L, update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4-6]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
        changes.add(new MSentryPermChange(8L, update));
        Assert.assertEquals((String)"Collapsed string should match", (Object)"[1, 2, 4-6, 8]", (Object)MSentryUtil.collapseChangeIDsToString(changes));
        Assert.assertFalse((String)"List of changes should not be consecutive", (boolean)MSentryUtil.isConsecutive(changes));
    }
}

