/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.log.util.CommandUtil;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.junit.Assert;
import org.junit.Test;

public class TestCommandUtil
extends Assert {
    @Test
    public void testCreateCmdForCreateOrDropRole() {
        String roleName = "testRole";
        String createRoleCmdResult = CommandUtil.createCmdForCreateOrDropRole((String)roleName, (boolean)true);
        String dropRoleCmdResult = CommandUtil.createCmdForCreateOrDropRole((String)roleName, (boolean)false);
        String createRoleCmdExcepted = "CREATE ROLE testRole";
        String dropRoleCmdExcepted = "DROP ROLE testRole";
        TestCommandUtil.assertEquals((Object)createRoleCmdExcepted, (Object)createRoleCmdResult);
        TestCommandUtil.assertEquals((Object)dropRoleCmdResult, (Object)dropRoleCmdExcepted);
    }

    @Test
    public void testCreateCmdForRoleAddOrDeleteGroup1() {
        String createRoleAddGroupCmdResult = CommandUtil.createCmdForRoleAddGroup((String)"testRole", (String)this.getGroupStr(1));
        String createRoleAddGroupCmdExcepted = "GRANT ROLE testRole TO GROUP testGroup1";
        String createRoleDeleteGroupCmdResult = CommandUtil.createCmdForRoleDeleteGroup((String)"testRole", (String)this.getGroupStr(1));
        String createRoleDeleteGroupCmdExcepted = "REVOKE ROLE testRole FROM GROUP testGroup1";
        TestCommandUtil.assertEquals((Object)createRoleAddGroupCmdExcepted, (Object)createRoleAddGroupCmdResult);
        TestCommandUtil.assertEquals((Object)createRoleDeleteGroupCmdExcepted, (Object)createRoleDeleteGroupCmdResult);
    }

    @Test
    public void testCreateCmdForRoleAddOrDeleteGroup2() {
        String createRoleAddGroupCmdResult = CommandUtil.createCmdForRoleAddGroup((String)"testRole", (String)this.getGroupStr(3));
        String createRoleAddGroupCmdExcepted = "GRANT ROLE testRole TO GROUP testGroup1, testGroup2, testGroup3";
        String createRoleDeleteGroupCmdResult = CommandUtil.createCmdForRoleDeleteGroup((String)"testRole", (String)this.getGroupStr(3));
        String createRoleDeleteGroupCmdExcepted = "REVOKE ROLE testRole FROM GROUP testGroup1, testGroup2, testGroup3";
        TestCommandUtil.assertEquals((Object)createRoleAddGroupCmdExcepted, (Object)createRoleAddGroupCmdResult);
        TestCommandUtil.assertEquals((Object)createRoleDeleteGroupCmdExcepted, (Object)createRoleDeleteGroupCmdResult);
    }

    @Test
    public void testCreateCmdForRoleAddOrDeleteUser1() {
        String createRoleAddGroupCmdResult = CommandUtil.createCmdForRoleAddUser((String)"testRole", (String)this.getUserStr(1));
        String createRoleAddGroupCmdExcepted = "GRANT ROLE testRole TO USER testUser1";
        String createRoleDeleteGroupCmdResult = CommandUtil.createCmdForRoleDeleteUser((String)"testRole", (String)this.getUserStr(1));
        String createRoleDeleteGroupCmdExcepted = "REVOKE ROLE testRole FROM USER testUser1";
        TestCommandUtil.assertEquals((Object)createRoleAddGroupCmdExcepted, (Object)createRoleAddGroupCmdResult);
        TestCommandUtil.assertEquals((Object)createRoleDeleteGroupCmdExcepted, (Object)createRoleDeleteGroupCmdResult);
    }

    @Test
    public void testCreateCmdForRoleAddOrDeleteUser2() {
        String createRoleAddGroupCmdResult = CommandUtil.createCmdForRoleAddUser((String)"testRole", (String)this.getUserStr(3));
        String createRoleAddGroupCmdExcepted = "GRANT ROLE testRole TO USER testUser1, testUser2, testUser3";
        String createRoleDeleteGroupCmdResult = CommandUtil.createCmdForRoleDeleteUser((String)"testRole", (String)this.getUserStr(3));
        String createRoleDeleteGroupCmdExcepted = "REVOKE ROLE testRole FROM USER testUser1, testUser2, testUser3";
        TestCommandUtil.assertEquals((Object)createRoleAddGroupCmdExcepted, (Object)createRoleAddGroupCmdResult);
        TestCommandUtil.assertEquals((Object)createRoleDeleteGroupCmdExcepted, (Object)createRoleDeleteGroupCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege1() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT ALL ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE ALL ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege2() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("insert", ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT INSERT ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE INSERT ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege3() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege4() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege(null, ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT null ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE null ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege5() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.TABLE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON TABLE tableTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON TABLE tableTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege6() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.SERVER.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON SERVER serverTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON SERVER serverTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege7() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.URI.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON URI hdfs://namenode:port/path/to/dir TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON URI hdfs://namenode:port/path/to/dir FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege8() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.SERVER.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        privilege.setGrantOption(org.apache.sentry.provider.db.service.thrift.TSentryGrantOption.TRUE);
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON SERVER serverTest TO ROLE testRole WITH GRANT OPTION";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON SERVER serverTest FROM ROLE testRole WITH GRANT OPTION";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokeGMPrivilege1() {
        org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantGMPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokeGMPrivilegeRequest();
        org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege privilege = this.getGMPrivilege();
        grantRequest.setPrivilege(privilege);
        revokeRequest.setPrivilege(privilege);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantGMPrivilege((org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokeGMPrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 FROM ROLE testRole";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokeGMPrivilege2() {
        org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantGMPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokeGMPrivilegeRequest();
        org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege privilege = this.getGMPrivilege();
        privilege.setGrantOption(TSentryGrantOption.TRUE);
        grantRequest.setPrivilege(privilege);
        revokeRequest.setPrivilege(privilege);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantGMPrivilege((org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 TO ROLE testRole WITH GRANT OPTION";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokeGMPrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 FROM ROLE testRole WITH GRANT OPTION";
        TestCommandUtil.assertEquals((Object)createGrantPrivilegeCmdExcepted, (Object)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((Object)createRevokePrivilegeCmdExcepted, (Object)createRevokePrivilegeCmdResult);
    }

    private String getGroupStr(int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("testGroup" + (i + 1));
        }
        return sb.toString();
    }

    private String getUserStr(int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("testUser" + (i + 1));
        }
        return sb.toString();
    }

    private TAlterSentryRoleGrantPrivilegeRequest getGrantPrivilegeRequest() {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setRoleName("testRole");
        return request;
    }

    private org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest getRevokePrivilegeRequest() {
        org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest request = new org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest();
        request.setRoleName("testRole");
        return request;
    }

    private org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest getGrantGMPrivilegeRequest() {
        org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest request = new org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest();
        request.setRoleName("testRole");
        return request;
    }

    private TAlterSentryRoleRevokePrivilegeRequest getRevokeGMPrivilegeRequest() {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        request.setRoleName("testRole");
        return request;
    }

    private TSentryPrivilege getPrivilege(String action, String privilegeScope, String dbName, String tableName, String serverName, String URI2) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setAction(action);
        privilege.setPrivilegeScope(privilegeScope);
        privilege.setDbName(dbName);
        privilege.setTableName(tableName);
        privilege.setServerName(serverName);
        privilege.setURI(URI2);
        return privilege;
    }

    private org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege getGMPrivilege() {
        org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege privilege = new org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege();
        privilege.setAction("ACTION");
        privilege.setComponent("COMPONENT");
        ArrayList<TAuthorizable> authorizables = new ArrayList<TAuthorizable>();
        authorizables.add(new TAuthorizable("resourceType1", "resourceName1"));
        authorizables.add(new TAuthorizable("resourceType2", "resourceName2"));
        privilege.setAuthorizables(authorizables);
        return privilege;
    }
}

