/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.utils.ThriftUtil;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.log.entity.GMAuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.JsonLogEntityFactory;
import org.apache.sentry.service.thrift.Status;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJsonLogEntityFactoryGM {
    private static Configuration conf;
    private static String TEST_IP;
    private static String TEST_IMPERSONATOR;
    private static String TEST_ROLE_NAME;
    private static String TEST_USER_NAME;
    private static String TEST_GROUP;
    private static String TEST_ACTION;
    private static String TEST_COMPONENT;
    private static Map<String, String> TEST_PRIVILEGES_MAP;

    @BeforeClass
    public static void init() {
        conf = new Configuration();
        conf.set("sentry.service.name", "Sentry-Service");
        ThriftUtil.setIpAddress((String)TEST_IP);
        ThriftUtil.setImpersonator((String)TEST_IMPERSONATOR);
        TEST_PRIVILEGES_MAP.put("resourceType1", "resourceName1");
        TEST_PRIVILEGES_MAP.put("resourceType2", "resourceName2");
        TEST_PRIVILEGES_MAP.put("resourceType3", "resourceName3");
    }

    @Test
    public void testCreateRole() {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        TCreateSentryRoleResponse response = new TCreateSentryRoleResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        response.setStatus(Status.OK());
        GMAuditMetadataLogEntity amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "CREATE_ROLE", "CREATE ROLE testRole", "ROLE", new HashMap<String, String>());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "CREATE_ROLE", "CREATE ROLE testRole", "ROLE", new HashMap<String, String>());
    }

    @Test
    public void testDropRole() {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        TDropSentryRoleResponse response = new TDropSentryRoleResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        response.setStatus(Status.OK());
        GMAuditMetadataLogEntity amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "DROP_ROLE", "DROP ROLE testRole", "ROLE", new HashMap<String, String>());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "DROP_ROLE", "DROP ROLE testRole", "ROLE", new HashMap<String, String>());
    }

    @Test
    public void testGrantRole() {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        TAlterSentryRoleGrantPrivilegeResponse response = new TAlterSentryRoleGrantPrivilegeResponse();
        TSentryPrivilege privilege = this.getPrivilege();
        request.setPrivilege(privilege);
        response.setStatus(Status.OK());
        GMAuditMetadataLogEntity amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "GRANT_PRIVILEGE", "GRANT ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 resourceType3 resourceName3 TO ROLE testRole", "PRINCIPAL", TEST_PRIVILEGES_MAP);
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "GRANT_PRIVILEGE", "GRANT ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 resourceType3 resourceName3 TO ROLE testRole", "PRINCIPAL", TEST_PRIVILEGES_MAP);
    }

    @Test
    public void testRevokeRole() {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeResponse response = new TAlterSentryRoleRevokePrivilegeResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        TSentryPrivilege privilege = this.getPrivilege();
        request.setPrivilege(privilege);
        response.setStatus(Status.OK());
        GMAuditMetadataLogEntity amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "REVOKE_PRIVILEGE", "REVOKE ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 resourceType3 resourceName3 FROM ROLE testRole", "PRINCIPAL", TEST_PRIVILEGES_MAP);
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "REVOKE_PRIVILEGE", "REVOKE ACTION ON resourceType1 resourceName1 resourceType2 resourceName2 resourceType3 resourceName3 FROM ROLE testRole", "PRINCIPAL", TEST_PRIVILEGES_MAP);
    }

    @Test
    public void testAddRole() {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest();
        TAlterSentryRoleAddGroupsResponse response = new TAlterSentryRoleAddGroupsResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        request.setGroups(this.getGroups());
        response.setStatus(Status.OK());
        GMAuditMetadataLogEntity amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "ADD_ROLE_TO_GROUP", "GRANT ROLE testRole TO GROUP testGroup", "ROLE", new HashMap<String, String>());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "ADD_ROLE_TO_GROUP", "GRANT ROLE testRole TO GROUP testGroup", "ROLE", new HashMap<String, String>());
    }

    @Test
    public void testDeleteRole() {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest();
        TAlterSentryRoleDeleteGroupsResponse response = new TAlterSentryRoleDeleteGroupsResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        request.setGroups(this.getGroups());
        response.setStatus(Status.OK());
        GMAuditMetadataLogEntity amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "DELETE_ROLE_FROM_GROUP", "REVOKE ROLE testRole FROM GROUP testGroup", "ROLE", new HashMap<String, String>());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (GMAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "DELETE_ROLE_FROM_GROUP", "REVOKE ROLE testRole FROM GROUP testGroup", "ROLE", new HashMap<String, String>());
    }

    private void assertCommon(GMAuditMetadataLogEntity amle, String allowedExcepted, String operationExcepted, String operationTextExcepted, String objectTypeExcepted, Map<String, String> privilegesExcepted) {
        Assert.assertEquals((Object)"Sentry-Service", (Object)amle.getServiceName());
        Assert.assertEquals((Object)TEST_IP, (Object)amle.getIpAddress());
        Assert.assertEquals((Object)TEST_USER_NAME, (Object)amle.getUserName());
        Assert.assertEquals((Object)TEST_IMPERSONATOR, (Object)amle.getImpersonator());
        Assert.assertEquals((Object)allowedExcepted, (Object)amle.getAllowed());
        Assert.assertEquals((Object)operationExcepted, (Object)amle.getOperation());
        Assert.assertEquals((Object)operationTextExcepted, (Object)amle.getOperationText());
        Assert.assertEquals((Object)objectTypeExcepted, (Object)amle.getObjectType());
        this.assertPrivilegesMap(privilegesExcepted, amle.getPrivilegesMap());
    }

    private void assertPrivilegesMap(Map<String, String> privilegesExcepted, Map<String, String> privilegesActual) {
        Assert.assertEquals((long)privilegesExcepted.size(), (long)privilegesActual.size());
        for (Map.Entry<String, String> privilege : privilegesExcepted.entrySet()) {
            Assert.assertEquals((Object)privilege.getValue(), (Object)privilegesActual.get(privilege.getKey()));
        }
    }

    private TSentryPrivilege getPrivilege() {
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setAction(TEST_ACTION);
        privilege.setComponent(TEST_COMPONENT);
        ArrayList<TAuthorizable> authorizables = new ArrayList<TAuthorizable>();
        authorizables.add(new TAuthorizable("resourceType1", "resourceName1"));
        authorizables.add(new TAuthorizable("resourceType2", "resourceName2"));
        authorizables.add(new TAuthorizable("resourceType3", "resourceName3"));
        privilege.setAuthorizables(authorizables);
        return privilege;
    }

    private Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        groups.add(TEST_GROUP);
        return groups;
    }

    static {
        TEST_IP = "localhost/127.0.0.1";
        TEST_IMPERSONATOR = "impersonator";
        TEST_ROLE_NAME = "testRole";
        TEST_USER_NAME = "requestUser";
        TEST_GROUP = "testGroup";
        TEST_ACTION = "action";
        TEST_COMPONENT = "component";
        TEST_PRIVILEGES_MAP = new HashMap<String, String>();
    }
}

