/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.utils.ThriftUtil;
import org.apache.sentry.provider.db.log.entity.DBAuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.JsonLogEntityFactory;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.Status;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJsonLogEntityFactory {
    private static Configuration conf;
    private static String TEST_IP;
    private static String TEST_IMPERSONATOR;
    private static String TEST_ROLE_NAME;
    private static String TEST_USER_NAME;
    private static String TEST_DATABASE_NAME;
    private static String TEST_TABLE_NAME;
    private static String TEST_GROUP;

    @BeforeClass
    public static void init() {
        conf = new Configuration();
        conf.set("sentry.service.name", "Sentry-Service");
        ThriftUtil.setIpAddress((String)TEST_IP);
        ThriftUtil.setImpersonator((String)TEST_IMPERSONATOR);
    }

    @Test
    public void testCreateRole() {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        TCreateSentryRoleResponse response = new TCreateSentryRoleResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        response.setStatus(Status.OK());
        DBAuditMetadataLogEntity amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "CREATE_ROLE", "CREATE ROLE testRole", null, null, null, "ROLE");
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "CREATE_ROLE", "CREATE ROLE testRole", null, null, null, "ROLE");
    }

    @Test
    public void testDropRole() {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        TDropSentryRoleResponse response = new TDropSentryRoleResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        response.setStatus(Status.OK());
        DBAuditMetadataLogEntity amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "DROP_ROLE", "DROP ROLE testRole", null, null, null, "ROLE");
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "DROP_ROLE", "DROP ROLE testRole", null, null, null, "ROLE");
    }

    @Test
    public void testGrantRole() {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        TAlterSentryRoleGrantPrivilegeResponse response = new TAlterSentryRoleGrantPrivilegeResponse();
        TSentryPrivilege privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.DATABASE.name(), TEST_DATABASE_NAME, null, null, null);
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.OK());
        DBAuditMetadataLogEntity amle = new DBAuditMetadataLogEntity();
        Set amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((long)amles.size(), (long)1L);
        amle = (DBAuditMetadataLogEntity)amles.iterator().next();
        this.assertCommon(amle, "true", "GRANT_PRIVILEGE", "GRANT ALL ON DATABASE testDB TO ROLE testRole", TEST_DATABASE_NAME, null, null, "PRINCIPAL");
        privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.TABLE.name(), null, TEST_TABLE_NAME, null, null);
        privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.InvalidInput((String)"", null));
        amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((long)amles.size(), (long)1L);
        amle = (DBAuditMetadataLogEntity)amles.iterator().next();
        this.assertCommon(amle, "false", "GRANT_PRIVILEGE", "GRANT ALL ON TABLE testTable TO ROLE testRole", null, TEST_TABLE_NAME, null, "PRINCIPAL");
    }

    @Test
    public void testRevokeRole() {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeResponse response = new TAlterSentryRoleRevokePrivilegeResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        TSentryPrivilege privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.DATABASE.name(), TEST_DATABASE_NAME, null, null, null);
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.OK());
        DBAuditMetadataLogEntity amle = new DBAuditMetadataLogEntity();
        Set amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((long)amles.size(), (long)1L);
        amle = (DBAuditMetadataLogEntity)amles.iterator().next();
        this.assertCommon(amle, "true", "REVOKE_PRIVILEGE", "REVOKE ALL ON DATABASE testDB FROM ROLE testRole", TEST_DATABASE_NAME, null, null, "PRINCIPAL");
        privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.TABLE.name(), null, TEST_TABLE_NAME, null, null);
        privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.InvalidInput((String)"", null));
        amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((long)amles.size(), (long)1L);
        amle = (DBAuditMetadataLogEntity)amles.iterator().next();
        this.assertCommon(amle, "false", "REVOKE_PRIVILEGE", "REVOKE ALL ON TABLE testTable FROM ROLE testRole", null, TEST_TABLE_NAME, null, "PRINCIPAL");
    }

    @Test
    public void testAddRole() {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest();
        TAlterSentryRoleAddGroupsResponse response = new TAlterSentryRoleAddGroupsResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        request.setGroups(this.getGroups());
        response.setStatus(Status.OK());
        DBAuditMetadataLogEntity amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "ADD_ROLE_TO_GROUP", "GRANT ROLE testRole TO GROUP testGroup", null, null, null, "ROLE");
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "ADD_ROLE_TO_GROUP", "GRANT ROLE testRole TO GROUP testGroup", null, null, null, "ROLE");
    }

    @Test
    public void testDeleteRole() {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest();
        TAlterSentryRoleDeleteGroupsResponse response = new TAlterSentryRoleDeleteGroupsResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        request.setGroups(this.getGroups());
        response.setStatus(Status.OK());
        DBAuditMetadataLogEntity amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "DELETE_ROLE_FROM_GROUP", "REVOKE ROLE testRole FROM GROUP testGroup", null, null, null, "ROLE");
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (DBAuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "DELETE_ROLE_FROM_GROUP", "REVOKE ROLE testRole FROM GROUP testGroup", null, null, null, "ROLE");
    }

    private void assertCommon(DBAuditMetadataLogEntity amle, String allowedExcepted, String operationExcepted, String operationTextExcepted, String databaseNameExcepted, String tableNameExcepted, String resourcePathExcepted, String objectTypeExcepted) {
        Assert.assertEquals((Object)"Sentry-Service", (Object)amle.getServiceName());
        Assert.assertEquals((Object)TEST_IP, (Object)amle.getIpAddress());
        Assert.assertEquals((Object)TEST_USER_NAME, (Object)amle.getUserName());
        Assert.assertEquals((Object)TEST_IMPERSONATOR, (Object)amle.getImpersonator());
        Assert.assertEquals((Object)allowedExcepted, (Object)amle.getAllowed());
        Assert.assertEquals((Object)operationExcepted, (Object)amle.getOperation());
        Assert.assertEquals((Object)operationTextExcepted, (Object)amle.getOperationText());
        Assert.assertEquals((Object)tableNameExcepted, (Object)amle.getTableName());
        Assert.assertEquals((Object)databaseNameExcepted, (Object)amle.getDatabaseName());
        Assert.assertEquals((Object)resourcePathExcepted, (Object)amle.getResourcePath());
        Assert.assertEquals((Object)objectTypeExcepted, (Object)amle.getObjectType());
    }

    private TSentryPrivilege getPrivilege(String action, String privilegeScope, String dbName, String tableName, String serverName, String URI2) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setAction(action);
        privilege.setPrivilegeScope(privilegeScope);
        privilege.setDbName(dbName);
        privilege.setTableName(tableName);
        privilege.setServerName(serverName);
        privilege.setURI(URI2);
        return privilege;
    }

    private Set<TSentryGroup> getGroups() {
        LinkedHashSet<TSentryGroup> groups = new LinkedHashSet<TSentryGroup>();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(TEST_GROUP);
        groups.add(group);
        return groups;
    }

    static {
        TEST_IP = "localhost/127.0.0.1";
        TEST_IMPERSONATOR = "impersonator";
        TEST_ROLE_NAME = "testRole";
        TEST_USER_NAME = "requestUser";
        TEST_DATABASE_NAME = "testDB";
        TEST_TABLE_NAME = "testTable";
        TEST_GROUP = "testGroup";
    }
}

