/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import java.util.HashMap;
import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.GMAuditMetadataLogEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ContainerNode;
import org.junit.Assert;
import org.junit.Test;

public class TestGMAuditMetadataLogEntity {
    @Test
    public void testToJsonFormatLog() throws Throwable {
        HashMap<String, String> privilegesMap = new HashMap<String, String>();
        privilegesMap.put("resourceType1", "resourceName1");
        privilegesMap.put("resourceType2", "resourceName2");
        privilegesMap.put("resourceType3", "resourceName3");
        privilegesMap.put("resourceType4", "resourceName4");
        GMAuditMetadataLogEntity gmamle = new GMAuditMetadataLogEntity("serviceName", "userName", "impersonator", "ipAddress", "operation", "eventTime", "operationText", "allowed", "objectType", "component", privilegesMap);
        String jsonAuditLog = gmamle.toJsonFormatLog();
        ContainerNode rootNode = AuditMetadataLogEntity.parse((String)jsonAuditLog);
        this.assertEntryEquals(rootNode, "serviceName", "serviceName");
        this.assertEntryEquals(rootNode, "userName", "userName");
        this.assertEntryEquals(rootNode, "impersonator", "impersonator");
        this.assertEntryEquals(rootNode, "ipAddress", "ipAddress");
        this.assertEntryEquals(rootNode, "operation", "operation");
        this.assertEntryEquals(rootNode, "eventTime", "eventTime");
        this.assertEntryEquals(rootNode, "operationText", "operationText");
        this.assertEntryEquals(rootNode, "allowed", "allowed");
        this.assertEntryEquals(rootNode, "objectType", "objectType");
        this.assertEntryEquals(rootNode, "component", "component");
        this.assertEntryEquals(rootNode, "resourceType1", "resourceName1");
        this.assertEntryEquals(rootNode, "resourceType2", "resourceName2");
        this.assertEntryEquals(rootNode, "resourceType3", "resourceName3");
        this.assertEntryEquals(rootNode, "resourceType4", "resourceName4");
    }

    void assertEntryEquals(ContainerNode rootNode, String key, String value) {
        JsonNode node = this.assertNodeContains(rootNode, key);
        Assert.assertEquals((Object)value, (Object)node.getTextValue());
    }

    private JsonNode assertNodeContains(ContainerNode rootNode, String key) {
        JsonNode node = rootNode.get(key);
        if (node == null) {
            Assert.fail((String)("No entry of name \"" + key + "\" found in " + rootNode.toString()));
        }
        return node;
    }
}

